/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.email;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.storage.MailNotificationStorage;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.EntityConverter;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailDigestDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailParamDAO;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailDigestEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailParamEntity;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.TransactionException;

public class JPAMailNotificationStorage
implements MailNotificationStorage {
    private static final int QUERY_LIMIT = 100;
    private static final Log LOG;
    public static final String DIGEST_DAILY = "daily";
    public static final String DIGEST_WEEKLY = "weekly";
    public static final ArgumentLiteral<Map> WEEKLY_NOTIFS;
    public static final ArgumentLiteral<Map> DAILY_NOTIFS;
    private MailNotifDAO mailNotifDAO;
    private MailDigestDAO mailDigestDAO;
    private MailParamDAO mailParamDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public JPAMailNotificationStorage(MailNotifDAO mailNotifDAO, MailDigestDAO mailDigestDAO, MailParamDAO mailParamDAO, DataInitializer dataInitializer) {
        this.mailNotifDAO = mailNotifDAO;
        this.mailDigestDAO = mailDigestDAO;
        this.mailParamDAO = mailParamDAO;
    }

    @ExoTransactional
    public void save(NotificationInfo message) throws Exception {
        NotificationInfo notificationInfo = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)notificationInfo);
        JPAMailNotificationStorage.save_aroundBody1$advice(this, notificationInfo, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public Map<PluginKey, List<NotificationInfo>> getByUser(NotificationContext context, UserSetting setting) {
        NotificationContext notificationContext = context;
        UserSetting userSetting = setting;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)notificationContext, (Object)userSetting);
        return (Map)JPAMailNotificationStorage.getByUser_aroundBody3$advice(this, notificationContext, userSetting, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void removeMessageAfterSent(NotificationContext context) throws Exception {
        NotificationContext notificationContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)notificationContext);
        JPAMailNotificationStorage.removeMessageAfterSent_aroundBody5$advice(this, notificationContext, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void deleteAllDigests() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        JPAMailNotificationStorage.deleteAllDigests_aroundBody7$advice(this, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private List<NotificationInfo> getWeeklyNotifs(NotificationContext context, String pluginId, String userId) {
        return this.getNotificationsByDigestAndPluginId(context, WEEKLY_NOTIFS, pluginId, userId);
    }

    private List<NotificationInfo> getDailyNotifs(NotificationContext context, String pluginId, String userId) {
        return this.getNotificationsByDigestAndPluginId(context, DAILY_NOTIFS, pluginId, userId);
    }

    private List<NotificationInfo> getNotificationsByDigestAndPluginId(NotificationContext context, ArgumentLiteral<Map> notifsDigestArgument, String pluginId, String userId) {
        HashMap<String, List<NotificationInfo>> notificationsByPluginId = (HashMap<String, List<NotificationInfo>>)context.value(notifsDigestArgument);
        if (notificationsByPluginId == null) {
            notificationsByPluginId = new HashMap<String, List<NotificationInfo>>();
            context.append(notifsDigestArgument, notificationsByPluginId);
        }
        List<NotificationInfo> notificationInfos = null;
        if (notificationsByPluginId.containsKey(pluginId)) {
            notificationInfos = (List)notificationsByPluginId.get(pluginId);
        } else {
            notificationInfos = new ArrayList();
            List<MailNotifEntity> notifEntities = notifsDigestArgument == WEEKLY_NOTIFS ? this.getNotifsByWeek(pluginId) : this.getNotifsByDate(context, pluginId);
            for (MailNotifEntity mailNotifEntity : notifEntities) {
                NotificationInfo model = this.fillModel(mailNotifEntity, null);
                notificationInfos.add(model);
            }
            notificationsByPluginId.put(pluginId, notificationInfos);
        }
        ArrayList<NotificationInfo> resultNotificationInfos = new ArrayList<NotificationInfo>();
        for (NotificationInfo notificationInfo : notificationInfos) {
            NotificationInfo resultNotificationInfo = notificationInfo.clone(false);
            resultNotificationInfo.setTo(userId);
            resultNotificationInfos.add(resultNotificationInfo);
        }
        return resultNotificationInfos;
    }

    private void putMap(Map<PluginKey, List<NotificationInfo>> notificationData, PluginKey key, List<NotificationInfo> values) {
        if (notificationData.containsKey(key)) {
            List<NotificationInfo> messages = notificationData.get(key);
            for (NotificationInfo notificationMessage : values) {
                if (messages.size() != 0 && messages.contains(notificationMessage)) continue;
                messages.add(notificationMessage);
            }
            if (messages.size() > 0) {
                notificationData.put(key, messages);
            }
        } else if (values.size() > 0) {
            notificationData.put(key, values);
        }
    }

    private NotificationInfo fillModel(MailNotifEntity notifEntity, String userId) {
        if (notifEntity == null) {
            return null;
        }
        NotificationInfo message = NotificationInfo.instance().setFrom(notifEntity.getSender()).setTo(userId).setOrder(notifEntity.getOrder()).key(notifEntity.getType()).setOwnerParameter(EntityConverter.convertParamsEntityToParams(notifEntity.getParameters())).setLastModifiedDate(notifEntity.getCreationDate()).setId(String.valueOf(notifEntity.getId()));
        return message;
    }

    private List<MailNotifEntity> getNotifsByDate(NotificationContext context, String pluginId) {
        String dayName = (String)context.value(NotificationJob.DAY_OF_JOB);
        return this.mailNotifDAO.getNotifsByPluginAndDay(pluginId, dayName);
    }

    private List<MailNotifEntity> getNotifsByWeek(String pluginId) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Calendar oneWeekAgo = calendar;
        return this.mailNotifDAO.getNotifsByPluginAndWeek(pluginId, oneWeekAgo);
    }

    static {
        JPAMailNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPAMailNotificationStorage.class);
        WEEKLY_NOTIFS = new ArgumentLiteral(Map.class, "weekly_notifications");
        DAILY_NOTIFS = new ArgumentLiteral(Map.class, "daily_notifications");
    }

    private static /* synthetic */ void save_aroundBody0(JPAMailNotificationStorage ajc$this, NotificationInfo message, JoinPoint joinPoint) {
        MailNotifEntity notifEntity = new MailNotifEntity();
        notifEntity.setSender(message.getFrom());
        notifEntity.setOrder(message.getOrder());
        notifEntity.setType(message.getKey().getId());
        notifEntity.setCreationDate(message.getDateCreated());
        notifEntity = ajc$this.mailNotifDAO.create(notifEntity);
        message.setId(String.valueOf(notifEntity.getId()));
        MailDigestEntity digestEntityDaily = new MailDigestEntity();
        digestEntityDaily.setNotification(notifEntity).setType(DIGEST_DAILY);
        ajc$this.mailDigestDAO.create(digestEntityDaily);
        MailDigestEntity digestEntityWeekly = new MailDigestEntity();
        digestEntityWeekly.setNotification(notifEntity).setType(DIGEST_WEEKLY);
        ajc$this.mailDigestDAO.create(digestEntityWeekly);
        Map parameters = message.getOwnerParameter();
        if (parameters != null && !parameters.isEmpty()) {
            for (String key : parameters.keySet()) {
                MailParamEntity paramEntity = new MailParamEntity();
                paramEntity.setName(key);
                paramEntity.setValue((String)parameters.get(key));
                paramEntity.setNotification(notifEntity);
                ajc$this.mailParamDAO.create(paramEntity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object save_aroundBody1$advice(JPAMailNotificationStorage ajc$this, NotificationInfo message, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAMailNotificationStorage.save_aroundBody0(ajc$this, message, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ Map getByUser_aroundBody2(JPAMailNotificationStorage ajc$this, NotificationContext context, UserSetting setting, JoinPoint joinPoint) {
        boolean isDaily;
        LinkedHashMap<PluginKey, List<NotificationInfo>> notificationData = new LinkedHashMap<PluginKey, List<NotificationInfo>>();
        boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
        if (isWeekly) {
            for (String pluginId : setting.getWeeklyPlugins()) {
                ajc$this.putMap(notificationData, PluginKey.key((String)pluginId), ajc$this.getWeeklyNotifs(context, pluginId, setting.getUserId()));
            }
        }
        if (isDaily = ((Boolean)context.value(NotificationJob.JOB_DAILY)).booleanValue()) {
            for (String pluginId : setting.getDailyPlugins()) {
                ajc$this.putMap(notificationData, PluginKey.key((String)pluginId), ajc$this.getDailyNotifs(context, pluginId, setting.getUserId()));
            }
        }
        return notificationData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getByUser_aroundBody3$advice(JPAMailNotificationStorage ajc$this, NotificationContext context, UserSetting setting, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Map result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Map map = result = JPAMailNotificationStorage.getByUser_aroundBody2(ajc$this, context, setting, (JoinPoint)proceedingJoinPoint);
            return map;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void removeMessageAfterSent_aroundBody4(JPAMailNotificationStorage ajc$this, NotificationContext context, JoinPoint joinPoint) {
        List<MailNotifEntity> allNotificationsWithoutDigests;
        boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
        Map generalWeeklyNotificationData = null;
        generalWeeklyNotificationData = isWeekly ? (Map)context.value(WEEKLY_NOTIFS) : (Map)context.value(DAILY_NOTIFS);
        if (generalWeeklyNotificationData == null) {
            ajc$this.mailDigestDAO.deleteAllDigestsOfType(isWeekly ? DIGEST_WEEKLY : DIGEST_DAILY);
        } else {
            HashSet<Long> mailNotifsIds = new HashSet<Long>();
            Collection notificationsLists = generalWeeklyNotificationData.values();
            for (List notificationsList : notificationsLists) {
                if (notificationsList == null) continue;
                for (NotificationInfo notificationInfo : notificationsList) {
                    try {
                        mailNotifsIds.add(Long.parseLong(notificationInfo.getId()));
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)("can't parse mail notification with id: " + notificationInfo.getId()));
                    }
                }
            }
            if (mailNotifsIds != null && !mailNotifsIds.isEmpty()) {
                ajc$this.mailDigestDAO.deleteDigestsOfTypeByNotificationsIds(mailNotifsIds, isWeekly ? DIGEST_WEEKLY : DIGEST_DAILY);
            }
        }
        do {
            if ((allNotificationsWithoutDigests = ajc$this.mailNotifDAO.getAllNotificationsWithoutDigests(0, 100)) == null || allNotificationsWithoutDigests.isEmpty()) continue;
            ajc$this.mailParamDAO.deleteParamsOfNotifications(allNotificationsWithoutDigests);
            ajc$this.mailNotifDAO.deleteAll(allNotificationsWithoutDigests);
        } while (allNotificationsWithoutDigests.size() == 100);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object removeMessageAfterSent_aroundBody5$advice(JPAMailNotificationStorage ajc$this, NotificationContext context, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAMailNotificationStorage.removeMessageAfterSent_aroundBody4(ajc$this, context, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object deleteAllDigests_aroundBody7$advice(JPAMailNotificationStorage ajc$this, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            ajc$this.mailDigestDAO.deleteAllDigests();
            Object var10_13 = result = null;
            return var10_13;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAMailNotificationStorage.java", JPAMailNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo", "message", "java.lang.Exception", "void"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByUser", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.NotificationContext:org.exoplatform.commons.api.notification.model.UserSetting", "context:setting", "", "java.util.Map"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeMessageAfterSent", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "org.exoplatform.commons.api.notification.NotificationContext", "context", "java.lang.Exception", "void"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAllDigests", "org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage", "", "", "java.lang.Exception", "void"), 172);
    }
}

