/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import org.exoplatform.commons.embedder.Embedder;
import org.exoplatform.commons.embedder.EmbedderFactory;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.mockito.Mockito;

public class EmbedderTest
extends BaseCommonsTestCase {
    private static final Log LOG = ExoLogger.getLogger(EmbedderTest.class);
    private Embedder embedder;

    public void setUp() throws Exception {
        super.setUp();
        WebuiRequestContext context = (WebuiRequestContext)Mockito.mock(WebuiRequestContext.class);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        PortalRequestContext ctx = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        Mockito.when((Object)Util.getPortalRequestContext()).thenReturn((Object)ctx);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testYoutube() {
        String youTubeURL = "http://www.youtube.com/watch?v=CZUXUjhXzDo";
        this.embedder = EmbedderFactory.getInstance((String)youTubeURL);
        ExoMedia videoObj = this.embedder.getExoMedia();
        if (videoObj == null) {
            LOG.warn((Object)"Can't connect to youtube");
            return;
        }
        this.assertRetrurnedData("http://www.youtube.com/watch?v=CZUXUjhXzDo");
        this.assertRetrurnedData("http://www.youtube.com/watch?feature=player_embedded&v=mhu0cNjWE8I");
        this.assertRetrurnedData("http://youtu.be/mhu0cNjWE8I");
        this.assertRetrurnedData("http://www.youtube.com/embed/mhu0cNjWE8I");
        this.assertRetrurnedData("http://m.youtube.com/watch?v=mhu0cNjWE8I");
        this.assertRetrurnedData("https://www.youtube.com/watch?v=CZUXUjhXzDo");
        this.assertRetrurnedData("https://www.youtube.com/watch?feature=player_embedded&v=mhu0cNjWE8I");
        this.assertRetrurnedData("https://youtu.be/mhu0cNjWE8I");
        this.assertRetrurnedData("https://www.youtube.com/embed/mhu0cNjWE8I");
        this.assertRetrurnedData("https://m.youtube.com/watch?v=mhu0cNjWE8I");
    }

    public void testSlideShare() {
        String slideShareURL = "http://www.slideshare.net/sh1mmer/using-nodejs-to-make-html5-work-for-everyone";
        this.embedder = EmbedderFactory.getInstance((String)slideShareURL);
        ExoMedia slideObj = this.embedder.getExoMedia();
        if (slideObj == null) {
            LOG.warn((Object)"Can't connect to slideshare");
        } else {
            EmbedderTest.assertEquals((String)"SlideShare", (String)slideObj.getProvider());
        }
        this.assertRetrurnedData("http://www.slideshare.net/thanhc0110m/social-media-trends-exo-platform-company");
        this.assertRetrurnedData("https://www.slideshare.net/thanhc0110m/social-media-trends-exo-platform-company");
        this.assertRetrurnedData("http://www.slideshare.net/slideshow/embed_code/43654545");
        this.assertRetrurnedData("https://www.slideshare.net/slideshow/embed_code/43654545");
    }

    public void testDailyMotionShare() {
        String dailyMotion = "http://www.dailymotion.com/video/x2g4jx_exo-platform-theserverside-video-te_news";
        this.embedder = EmbedderFactory.getInstance((String)dailyMotion);
        ExoMedia dailyObj = this.embedder.getExoMedia();
        if (dailyObj == null) {
            LOG.warn((Object)"Can't connect to dailymotion");
        }
        this.assertRetrurnedData("http://www.dailymotion.com/video/x2g4jx_exo-platform-theserverside-video-te_news");
        this.assertRetrurnedData("https://www.dailymotion.com/video/x2g4jx_exo-platform-theserverside-video-te_news");
        this.assertRetrurnedData("http://dai.ly/x2g4jx");
        this.assertRetrurnedData("https://dai.ly/x2g4jx");
        this.assertRetrurnedData("http://www.dailymotion.com/embed/video/x2g4jx");
        this.assertRetrurnedData("https://www.dailymotion.com/embed/video/x2g4jx");
    }

    public void testVimeoShare() {
        String dailyMotion = "http://vimeo.com/72407771";
        this.embedder = EmbedderFactory.getInstance((String)dailyMotion);
        ExoMedia vimeoObj = this.embedder.getExoMedia();
        if (vimeoObj == null) {
            LOG.warn((Object)"Can't connect to vimeo");
        }
        this.assertRetrurnedData("http://vimeo.com/72407771");
        this.assertRetrurnedData("https://vimeo.com/72407771");
        this.assertRetrurnedData("http://player.vimeo.com/video/72407771");
        this.assertRetrurnedData("https://player.vimeo.com/video/72407771");
    }

    public void testFlickr() {
        String flickrURL = "https://www.flickr.com/photos/saarblitz/15515790937";
        this.embedder = EmbedderFactory.getInstance((String)flickrURL);
        ExoMedia slideObj = this.embedder.getExoMedia();
        if (slideObj == null) {
            LOG.warn((Object)"Can't connect to flickr");
        } else {
            EmbedderTest.assertEquals((String)"Flickr", (String)slideObj.getProvider());
        }
    }

    public void testNonMediaLink() {
        String googleSiteURL = "www.google.com";
        this.embedder = EmbedderFactory.getInstance((String)googleSiteURL);
        EmbedderTest.assertNull((Object)this.embedder.getExoMedia());
        String youtubeSiteURL = "www.youtube.com";
        this.embedder = EmbedderFactory.getInstance((String)youtubeSiteURL);
        EmbedderTest.assertNull((Object)this.embedder.getExoMedia());
    }

    private void assertRetrurnedData(String youTubeURL) {
        this.embedder = EmbedderFactory.getInstance((String)youTubeURL);
        ExoMedia videoObj = this.embedder.getExoMedia();
        EmbedderTest.assertNotNull((Object)videoObj);
        EmbedderTest.assertNotNull((Object)videoObj.getTitle());
        EmbedderTest.assertNotNull((Object)videoObj.getHtml());
        EmbedderTest.assertNotNull((Object)videoObj.getDescription());
    }
}

