/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.MailNotificationStorage;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationServiceImpl
extends AbstractService
implements NotificationService {
    private static final Log LOG = ExoLogger.getLogger(NotificationServiceImpl.class);
    private final MailNotificationStorage storage;
    private final DigestorService digestorService;
    private final UserSettingService userService;
    private final NotificationContextFactory notificationContextFactory;
    private final ChannelManager channelManager;

    public NotificationServiceImpl(ChannelManager channelManager, UserSettingService userService, DigestorService digestorService, MailNotificationStorage storage, NotificationContextFactory notificationContextFactory) {
        this.userService = userService;
        this.digestorService = digestorService;
        this.storage = storage;
        this.notificationContextFactory = notificationContextFactory;
        this.channelManager = channelManager;
    }

    public void process(NotificationInfo notification) throws Exception {
        if (notification == null) {
            throw new IllegalArgumentException("Notification argument shouldn't be null");
        }
        String pluginId = notification.getKey().getId();
        if (this.notificationContextFactory.getStatisticsService().isStatisticsEnabled()) {
            this.notificationContextFactory.getStatisticsCollector().createNotificationInfoCount(pluginId);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notification);
        List<String> userIds = null;
        List channels = this.channelManager.getChannels();
        for (AbstractChannel channel : channels) {
            if (!CommonsUtils.getService(PluginSettingService.class).isActive(channel.getId(), pluginId)) continue;
            AbstractNotificationLifecycle lifecycle = this.channelManager.getLifecycle(ChannelKey.key((String)channel.getId()));
            if (notification.isSendAll()) {
                SettingService settingService = CommonsUtils.getService(SettingService.class);
                long usersCount = settingService.countContextsByType(Context.USER.getName());
                int maxResults = 100;
                int i = 0;
                while ((long)i < usersCount) {
                    List users = settingService.getContextNamesByType(Context.USER.getName(), i, maxResults);
                    lifecycle.process(ctx, users.toArray(new String[users.size()]));
                    i += maxResults;
                }
                continue;
            }
            if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
                LOG.debug("Notification with id '{}' and parameters = '{}' not sent because receivers are empty", new Object[]{notification.getId(), notification.getOwnerParameter()});
                userIds = Collections.emptyList();
            } else {
                userIds = notification.getSendToUserIds();
            }
            lifecycle.process(ctx, userIds.toArray(new String[userIds.size()]));
        }
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            if (message == null) continue;
            this.process(message);
        }
    }

    public void digest(NotificationContext notifContext) throws Exception {
        List userDigestSettings;
        UserSetting defaultConfigPlugins = this.getDefaultUserSetting(notifContext.getPluginSettingService().getActivePluginIds(UserSetting.EMAIL_CHANNEL));
        long startTime = System.currentTimeMillis();
        int limit = 100;
        int offset = 0;
        while ((userDigestSettings = this.userService.getDigestSettingForAllUser(notifContext, offset, limit)).size() != 0) {
            this.send(notifContext, userDigestSettings);
            offset += limit;
        }
        LOG.info((Object)("Time spent to send mail messages for users having personal settings: " + (System.currentTimeMillis() - startTime) + "ms."));
        startTime = System.currentTimeMillis();
        if (defaultConfigPlugins.getDailyPlugins().size() > 0 || defaultConfigPlugins.getWeeklyPlugins().size() > 0) {
            List usersWithDefaultSettings;
            offset = 0;
            while ((usersWithDefaultSettings = this.userService.getDigestDefaultSettingForAllUser(offset, limit)).size() != 0) {
                this.sendDefault(notifContext, usersWithDefaultSettings, defaultConfigPlugins);
                offset += limit;
            }
        }
        this.storage.removeMessageAfterSent(notifContext);
        LOG.info((Object)("Time spent to send mail messages for users having default settings: " + (System.currentTimeMillis() - startTime) + "ms."));
    }

    private void send(NotificationContext context, List<UserSetting> userSettings) {
        boolean stats = this.notificationContextFactory.getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            if (!userSetting.isChannelActive("MAIL_CHANNEL") || !userSetting.isEnabled() || NotificationUtils.isDeletedMember(userSetting.getUserId())) continue;
            this.putMessageToQueue(context, userSetting, stats);
        }
    }

    private void sendDefault(NotificationContext context, List<UserSetting> userSettings, UserSetting defaultConfigPlugins) {
        boolean stats = this.notificationContextFactory.getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            if (!userSetting.isEnabled() || NotificationUtils.isDeletedMember(userSetting.getUserId())) continue;
            userSetting = defaultConfigPlugins.clone().setUserId(userSetting.getUserId()).setLastUpdateTime(userSetting.getLastUpdateTime());
            this.putMessageToQueue(context, userSetting, stats);
        }
    }

    private void putMessageToQueue(NotificationContext context, UserSetting userSetting, boolean stats) {
        MessageInfo messageInfo;
        Map notificationMessageMap = this.storage.getByUser(context, userSetting);
        if (notificationMessageMap.size() > 0 && (messageInfo = this.digestorService.buildMessage(context, notificationMessageMap, userSetting)) != null) {
            try {
                CommonsUtils.getService(QueueMessage.class).put(messageInfo);
                if (stats) {
                    this.notificationContextFactory.getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
                    this.notificationContextFactory.getStatisticsCollector().putQueue(messageInfo.getPluginId());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred while putting message " + messageInfo.getId() + " to user " + messageInfo.getTo() + " in queue"), (Throwable)e);
            }
        }
    }

    private UserSetting getDefaultUserSetting(List<String> activatedPluginsByAdminSetting) {
        UserSetting setting = UserSetting.getInstance();
        UserSetting defaultSetting = this.userService.getDefaultSettings();
        for (String string : activatedPluginsByAdminSetting) {
            if (defaultSetting.isInWeekly(string)) {
                setting.addPlugin(string, UserSetting.FREQUENCY.WEEKLY);
                continue;
            }
            if (!defaultSetting.isInDaily(string)) continue;
            setting.addPlugin(string, UserSetting.FREQUENCY.DAILY);
        }
        return setting;
    }
}

