/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/v1/features")
@Api(value="/v1/features", description="Manages product experimental features")
public class ExoFeatureRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ExoFeatureRest.class);
    private ExoFeatureService featureService;

    public ExoFeatureRest(ExoFeatureService featureService) {
        this.featureService = featureService;
    }

    @Path(value="{featureName}")
    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Check if a feature is enabled for a user.", httpMethod="GET", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response isFeatureActiveForUser(@ApiParam(value="Feature name identifier", required=true) @PathParam(value="featureName") String featureName) {
        if (StringUtils.isBlank((String)featureName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Feature name must not be null or blank").build();
        }
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            boolean isFeatureActive = this.featureService.isFeatureActiveForUser(featureName, username);
            return Response.ok().entity((Object)String.valueOf(isFeatureActive)).type("text/plain").build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving feature status with name '{}'", new Object[]{featureName, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

