/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.storage;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.notification.BaseNotificationTestCase;
import org.exoplatform.component.test.BaseGateInTest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;

public class WebStorageMultiThreadTest
extends BaseNotificationTestCase {
    private static final Log LOG = ExoLogger.getLogger(WebStorageMultiThreadTest.class);
    private OrganizationService organizationService;
    private ExecutorService executor;
    private int NUMBER_THREAD = 5;
    private int NUMBER_USER = 10;
    private int HCR_save = 0;
    private int HCT_get_time = 0;
    private long HCT_time = 0L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.organizationService = (OrganizationService)this.getService(OrganizationService.class);
        this.create(this.NUMBER_USER, false);
        this.create(this.NUMBER_USER, true);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, "User thread");
            }
        };
        int threads = this.NUMBER_THREAD > this.NUMBER_USER * 2 ? this.NUMBER_THREAD : this.NUMBER_USER * 2;
        this.executor = Executors.newFixedThreadPool(threads + 5, threadFactory);
        this.HCR_save = 0;
    }

    protected void tearDown() throws Exception {
        for (String string : this.userIds) {
            this.organizationService.getUserHandler().removeUser(string, false);
        }
        this.executor.shutdownNow();
        super.tearDown();
    }

    private void create(int number, boolean isSameFirst) throws Exception {
        UserSettingService userSettingService = (UserSettingService)this.getService(UserSettingService.class);
        for (int i = 0; i < number; ++i) {
            String first = isSameFirst ? "" : String.valueOf(new Random().nextInt(1000));
            String userId = first + "user" + i + String.valueOf(WebStorageMultiThreadTest.generate()).hashCode();
            UserImpl user = new UserImpl(userId);
            this.organizationService.getUserHandler().createUser((User)user, true);
            UserSetting userSetting = userSettingService.getDefaultSettings().setUserId(userId);
            userSetting.setLastReadDate(System.currentTimeMillis());
            userSettingService.save(userSetting);
            this.userIds.add(userId);
            ((UserSettingService)this.getService(UserSettingService.class)).get(userId);
        }
        LOG.info((Object)("\nDone to create " + number + " users"));
    }

    public void testWebDatastorage() throws Exception {
        LOG.info((Object)("\nThread: " + this.NUMBER_THREAD + "\nUsers: " + this.userIds.size()));
        CountDownLatch latch = new CountDownLatch(this.NUMBER_THREAD * this.NUMBER_USER * 2);
        for (final String userId : this.userIds) {
            for (int i = 0; i < this.NUMBER_THREAD; ++i) {
                this.executor.execute(new Processor(latch){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process() {
                        long t = System.currentTimeMillis();
                        ExoContainerContext.setCurrentContainer((ExoContainer)WebStorageMultiThreadTest.this.getContainer());
                        RequestLifeCycle.begin((ExoContainer)WebStorageMultiThreadTest.this.getContainer());
                        try {
                            WebStorageMultiThreadTest.this.storage.save(WebStorageMultiThreadTest.this.makeWebNotificationInfo(userId));
                            ++WebStorageMultiThreadTest.this.HCR_save;
                        }
                        catch (Exception e) {
                            BaseGateInTest.fail((Throwable)e);
                            LOG.error((Object)e);
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            RequestLifeCycle.end();
                            WebStorageMultiThreadTest.this.HCT_time += System.currentTimeMillis() - t;
                        }
                    }
                });
            }
        }
        this.waitCompletionFinished(latch);
        LOG.info((Object)("\nTotal number of notifications saved: " + this.HCR_save + " total time: " + this.HCT_time + " ms"));
        latch = new CountDownLatch(this.NUMBER_USER * 2);
        for (final String userId : this.userIds) {
            this.executor.execute(new Processor(latch){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process() {
                    long t = System.currentTimeMillis();
                    ExoContainerContext.setCurrentContainer((ExoContainer)WebStorageMultiThreadTest.this.getContainer());
                    RequestLifeCycle.begin((ExoContainer)WebStorageMultiThreadTest.this.getContainer());
                    try {
                        WebNotificationFilter filter = new WebNotificationFilter(userId);
                        WebStorageMultiThreadTest.this.storage.get(filter, 0, 20);
                    }
                    catch (Exception e) {
                        BaseGateInTest.fail((Throwable)e);
                        LOG.error((Object)e);
                    }
                    finally {
                        RequestLifeCycle.end();
                        WebStorageMultiThreadTest.this.HCT_get_time = (int)((long)WebStorageMultiThreadTest.this.HCT_get_time + (System.currentTimeMillis() - t));
                    }
                }
            });
        }
        this.waitCompletionFinished(latch);
        Thread.sleep(1000L);
        LOG.info((Object)("\nTotal time get notifications: " + this.HCT_get_time + " ms"));
    }

    public void waitCompletionFinished(CountDownLatch latch) throws InterruptedException {
        try {
            while (latch.getCount() > 0L) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public abstract class Processor
    implements Runnable {
        protected CountDownLatch latch;

        public Processor(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.process();
            }
            finally {
                this.latch.countDown();
            }
        }

        protected abstract void process();
    }
}

