/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.thumbnail;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.services.thumbnail.ImageResizeServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageResizeServiceImplTest {
    private ImageResizeService imageResizeService;
    private byte[] testImageContent;
    private byte[] testVerticalImageContent;

    @Before
    public void setUp() throws Exception {
        this.imageResizeService = new ImageResizeServiceImpl();
        File file = new File(this.getClass().getClassLoader().getResource("images/testresize.jpg").getFile());
        this.testImageContent = Files.readAllBytes(file.toPath());
        File fileVertical = new File(this.getClass().getClassLoader().getResource("images/testVerticalresize.jpg").getFile());
        this.testVerticalImageContent = Files.readAllBytes(fileVertical.toPath());
    }

    @Test
    public void scaleHorizontaleImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 0, 0, false, false);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)427L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)640L, (long)bufferedImage.getWidth());
        resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 15, 15, false, false);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)15L, (long)bufferedImage.getHeight());
        Assert.assertNotEquals((long)15L, (long)bufferedImage.getWidth());
        Assert.assertTrue((bufferedImage.getWidth() > bufferedImage.getHeight() ? 1 : 0) != 0);
        resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 15, 15, true, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)15L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)15L, (long)bufferedImage.getWidth());
        resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 0, 15, true, false);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)15L, (long)bufferedImage.getHeight());
        Assert.assertNotEquals((long)15L, (long)bufferedImage.getWidth());
        resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 15, 0, true, false);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)15L, (long)bufferedImage.getWidth());
        Assert.assertNotEquals((long)15L, (long)bufferedImage.getHeight());
        resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 15, 0, true, false);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)15L, (long)bufferedImage.getWidth());
        Assert.assertNotEquals((long)15L, (long)bufferedImage.getHeight());
    }

    @Test
    public void scaleLandscapeToLandscapeSizeImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 150, 80, false, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertNotEquals((long)80L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)150L, (long)bufferedImage.getWidth());
    }

    @Test
    public void scaleLandscapeToPortraitSizeImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 10, 50, false, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)50L, (long)bufferedImage.getHeight());
        Assert.assertNotEquals((long)10L, (long)bufferedImage.getWidth());
    }

    @Test
    public void scalePortraitToLandscapeSizeImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testVerticalImageContent, 150, 80, false, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertNotEquals((long)80L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)150L, (long)bufferedImage.getWidth());
    }

    @Test
    public void scalePortraitToPortraitSizeImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testVerticalImageContent, 10, 50, false, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)50L, (long)bufferedImage.getHeight());
        Assert.assertNotEquals((long)10L, (long)bufferedImage.getWidth());
    }

    @Test
    public void testShouldNotIncreaseSizeImage() throws Exception {
        byte[] resizedImage = this.imageResizeService.scaleImage(this.testImageContent, 2000, 1000, false, true);
        Assert.assertTrue((resizedImage.length > 0 ? 1 : 0) != 0);
        BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
        Assert.assertEquals((long)resizedImage.length, (long)this.testImageContent.length);
        Assert.assertEquals((long)427L, (long)bufferedImage.getHeight());
        Assert.assertEquals((long)640L, (long)bufferedImage.getWidth());
    }

    private BufferedImage toBufferedImage(byte[] content) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        return ImageIO.read(bis);
    }

    @Test
    public void testShouldReturnOriginalImageIfImageTypeNotSupported() {
        try {
            File fileWebPImage = new File(this.getClass().getClassLoader().getResource("images/meeds.webp").getFile());
            byte[] testFileWebPImage = Files.readAllBytes(fileWebPImage.toPath());
            byte[] resizedImage = this.imageResizeService.scaleImage(testFileWebPImage, 2000, 1000, false, true);
            Assert.assertEquals((long)resizedImage.length, (long)testFileWebPImage.length);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testShouldReturnOriginalImageIfImageHaveError() {
        try {
            File fileImage = new File(this.getClass().getClassLoader().getResource("images/image-with-error.png").getFile());
            byte[] testFileImage = Files.readAllBytes(fileImage.toPath());
            byte[] resizedImage = this.imageResizeService.scaleImage(testFileImage, 2000, 1000, false, true);
            Assert.assertEquals((long)resizedImage.length, (long)testFileImage.length);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testShouldFitHeight() {
        try {
            File fileImage = new File(this.getClass().getClassLoader().getResource("images/large-banner.png").getFile());
            byte[] testFileImage = Files.readAllBytes(fileImage.toPath());
            byte[] resizedImage = this.imageResizeService.scaleImage(testFileImage, 250, 150, false, true);
            BufferedImage bufferedImage = this.toBufferedImage(resizedImage);
            Assert.assertEquals((long)150L, (long)bufferedImage.getHeight());
            Assert.assertTrue((bufferedImage.getWidth() > 250 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testResizeJpegWithNotSupportedMetadata() throws Exception {
        File fileImage = new File(this.getClass().getClassLoader().getResource("images/illustration_with_non_supported_metadata.jpeg").getFile());
        byte[] testFileImage = Files.readAllBytes(fileImage.toPath());
        try {
            byte[] resizedImage = this.imageResizeService.scaleImage(testFileImage, 250, 150, false, true);
            Assert.assertEquals((long)resizedImage.length, (long)testFileImage.length);
        }
        catch (Exception e) {
            Assert.fail((String)"ScaleImage throws an error, and we do not catch it");
        }
    }
}

