/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import jakarta.persistence.TransactionRequiredException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.Task;
import org.exoplatform.commons.persistence.impl.TaskDao;
import org.exoplatform.commons.persistence.impl.TaskService;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.jpa.BaseTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/storage-test-configuration.xml")})
public class ExoTransactionalAnnotationTest
extends BaseTest {
    @Override
    public void setUp() {
        this.getContainer();
    }

    @Override
    public void tearDown() {
    }

    @Test
    public void testCreateDaoMethodIsTransactional() {
        TaskDao dao = new TaskDao();
        long id = ((Task)dao.create(new Task())).getId();
        ExoTransactionalAnnotationTest.assertNotNull((Object)dao.find(Long.valueOf(id)));
    }

    @Test
    public void testCreateServiceMethodIsTransactional() {
        TaskService service = new TaskService();
        long id = service.create(new Task()).getId();
        ExoTransactionalAnnotationTest.assertNotNull((Object)service.find(id));
    }

    @Test
    public void testDeleteDaoMethodIsTransactional() {
        TaskService service = new TaskService();
        Task task = service.create(new Task());
        service.delete(task);
        ExoTransactionalAnnotationTest.assertNull((Object)service.find(task.getId()));
    }

    @Test
    public void testNonTransactionalMethodDoesNotCommit() {
        TaskService service = new TaskService();
        TaskDao dao = new TaskDao();
        service.create(new Task());
        try {
            dao.nonTransactionalDeleteAll();
            ExoTransactionalAnnotationTest.fail((String)"deleteAll must throw an exception");
        }
        catch (TransactionRequiredException transactionRequiredException) {
            // empty catch block
        }
    }

    @Test
    public void testManualRollback() {
        TaskDao dao = new TaskDao();
        dao.createWithRollback(new Task());
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testManualCommit() {
        TaskDao dao = new TaskDao();
        dao.createWithCommit(new Task());
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testCommitFailed() {
        EntityManagerService service = (EntityManagerService)PortalContainer.getInstance().getComponentInstanceOfType(EntityManagerService.class);
        ExoTransactionalAnnotationTest.assertNull((Object)service.getEntityManager());
        TaskDao dao = new TaskDao();
        Task task = new Task();
        task.setId(1L);
        try {
            dao.create(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExoTransactionalAnnotationTest.assertNull((Object)service.getEntityManager());
    }

    @Test
    public void testMultipleTransactions() {
        PortalContainer container = this.getContainer();
        EntityManagerService entityManagerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        entityManagerService.startRequest((ExoContainer)container);
        TaskDao dao = new TaskDao();
        int initialSize = dao.findAll().size();
        try {
            Task task1 = new Task();
            task1.setName("task");
            dao.create(task1);
        }
        catch (Exception e) {
            ExoTransactionalAnnotationTest.fail((String)e.getMessage());
        }
        try {
            Task task2 = new Task();
            task2.setName("task");
            dao.create(task2);
        }
        catch (Exception task2) {
            // empty catch block
        }
        try {
            Task task3 = new Task();
            task3.setName("other task");
            dao.create(task3);
        }
        catch (Exception e) {
            ExoTransactionalAnnotationTest.fail((String)e.getMessage());
        }
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)(initialSize + 2)));
        entityManagerService.endRequest((ExoContainer)container);
    }

    @Test
    public void testMultiThreading() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ArrayList<Future<Boolean>> list = new ArrayList<Future<Boolean>>();
        MyCallable callable = new MyCallable();
        for (int i = 0; i < 10; ++i) {
            Future<Boolean> future = executor.submit(callable);
            list.add(future);
        }
        for (Future future : list) {
            ExoTransactionalAnnotationTest.assertTrue((boolean)((Boolean)future.get()));
        }
        executor.shutdown();
    }

    @Test
    public void testRequestLifeCycle() {
        PortalContainer container = this.getContainer();
        EntityManagerService service = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        service.startRequest((ExoContainer)container);
        TaskDao dao = new TaskDao();
        int initialSize = dao.findAll().size();
        dao.create(new Task());
        service.endRequest((ExoContainer)container);
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)(initialSize + 1)));
    }

    @Before
    public void deleteAllTask() {
        this.begin();
        new TaskDao().deleteAll();
        this.end();
    }

    @Test
    public void test_ifRollbackOnlyTrue_transactionRollbackWithNoError() {
        TaskDao dao = new TaskDao();
        dao.createWithSetRollbackOnly(new Task());
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void test_ifRollbackPreviousTransaction_noErrorToCommitNextTransaction() {
        PortalContainer container = this.getContainer();
        EntityManagerService service = (EntityManagerService)container.getComponentInstanceOfType(EntityManagerService.class);
        service.startRequest((ExoContainer)container);
        TaskDao dao = new TaskDao();
        int initialSize = dao.findAll().size();
        dao.createWithSetRollbackOnly(new Task());
        dao.create(new Task());
        service.endRequest((ExoContainer)container);
        Assert.assertThat((Object)dao.findAll().size(), (Matcher)Is.is((Object)(initialSize + 1)));
    }

    private class MyCallable
    implements Callable<Boolean> {
        private MyCallable() {
        }

        @Override
        public Boolean call() throws Exception {
            PortalContainer.getInstance();
            TaskDao dao = new TaskDao();
            long id = ((Task)dao.create(new Task())).getId();
            return dao.find(Long.valueOf(id)) != null;
        }
    }
}

