/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.commons.notification.NotificationUtils;

public class NotificationUtilsTest
extends TestCase {
    public void testGetLocale() {
        String language = null;
        Locale actual = NotificationUtils.getLocale(language);
        NotificationUtilsTest.assertEquals((Object)Locale.ENGLISH, (Object)actual);
        language = "";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)Locale.ENGLISH, (Object)actual);
        language = "fr";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)Locale.FRENCH, (Object)actual);
        language = "pt_BR";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)new Locale("pt", "BR"), (Object)actual);
        language = "pt_BR_BR";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)new Locale("pt", "BR", "BR"), (Object)actual);
    }

    public void testIsValidNotificationSenderName() {
        String senderName = "";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "    ";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "    test123456";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test12, 34 56; test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912, 34 56; test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912@test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912>test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912#test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912$test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test\u00e9\u00e912-_test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123456";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123 test 456";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123 45 6";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test123456";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test12 34 56-test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test  test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
    }

    public void testIsValidEmailAddresses() {
        String emails = "";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "#%^&test@test.com";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.787";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "no reply aaa@xyz.com, demo+aaa@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test.ABC@demo.COM";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test.ABC.def@demo2test.vn";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com.vn";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com, demo@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com ,  demo@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test+test@test.com, demo+aaa@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "Justin Dickey<justin.dickey@apprentice.university>";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "eXo Admin<team-cwi@exoplatform.com>";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
    }

    public void testProcessLinkInActivityTitle() {
        String title = "<a href=\"www.yahoo.com\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\">Hotmail Site</a>";
        title = NotificationUtils.processLinkTitle((String)title);
        NotificationUtilsTest.assertEquals((String)"<a href=\"www.yahoo.com\" style=\"color: #2f5e92; text-decoration: none;\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\" style=\"color: #2f5e92; text-decoration: none;\">Hotmail Site</a>", (String)title);
    }
}

