/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import jakarta.persistence.EntityManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;

public class TestEntityManagerService
extends CommonsDAOJPAImplTest {
    private EntityManagerService service;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.service = (EntityManagerService)PortalContainer.getInstance().getComponentInstanceOfType(EntityManagerService.class);
    }

    public void testServiceInitialize() {
        TestEntityManagerService.assertNotNull((Object)this.service);
        EntityManager em1 = this.service.getEntityManager();
        TestEntityManagerService.assertNotNull((Object)em1);
    }

    public void testStartLifecycleTwice() {
        EntityManager em1 = this.service.getEntityManager();
        TestEntityManagerService.assertNotNull((Object)em1);
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.service);
        EntityManager em2 = this.service.getEntityManager();
        TestEntityManagerService.assertSame((Object)em2, (Object)em1);
        RequestLifeCycle.end();
        EntityManager em3 = this.service.getEntityManager();
        TestEntityManagerService.assertNotNull((Object)em3);
        TestEntityManagerService.assertSame((Object)em3, (Object)em1);
    }

    public void testEntityManagerOutsideDefaultLifecycle() {
        EntityManager em1 = this.service.getEntityManager();
        TestEntityManagerService.assertNotNull((Object)em1);
        A a = new A(em1);
        a.run();
        TestEntityManagerService.assertTrue((boolean)a.succeed);
        TestEntityManagerService.assertTrue((boolean)a.sameEntity);
        a = new A(em1);
        Thread t = new Thread(a);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            TestEntityManagerService.fail((String)"Thread is interrupted");
        }
        TestEntityManagerService.assertTrue((boolean)a.succeed);
        TestEntityManagerService.assertFalse((boolean)a.sameEntity);
    }

    class A
    implements Runnable {
        private EntityManager em1;
        private boolean succeed;
        private boolean sameEntity;

        public A(EntityManager em) {
            this.em1 = em;
        }

        @Override
        public void run() {
            RequestLifeCycle.begin((ComponentRequestLifecycle)TestEntityManagerService.this.service);
            EntityManager em2 = TestEntityManagerService.this.service.getEntityManager();
            if (em2 != null && em2.isOpen()) {
                this.succeed = true;
            }
            this.sameEntity = em2 == this.em1;
            RequestLifeCycle.end();
        }
    }
}

