/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.info;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ProductInformations
implements Startable {
    public static final String PRODUCT_GROUP_ID = "product.groupId";
    public static final String PRODUCT_REVISION = "product.revision";
    public static final String PRODUCT_BUILD_NUMBER = "product.buildNumber";
    public static final String PRODUCT_VERSIONS_DECLARATION_FILE = "product.versions.declaration.file";
    public static final String PROCEED_UPGRADE_FIRST_TIME_KEY = "proceedUpgradeFirstTime";
    public static final String WORKING_WORSPACE_NAME = "working.worspace.name";
    public static final String EXO_APPLICATIONS_DATA_NODE_ALIAS = "exoApplicationDataNode";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String UPGRADE_PRODUCT_SERVICE_NODE_NAME = "ProductInformationsService";
    public static final String PRODUCT_VERSION_DECLARATION_NODE_NAME = "productVersionDeclarationNode";
    private static final Log LOG = ExoLogger.getLogger(ProductInformations.class);
    private Properties productInformationProperties = new Properties();
    private Properties previousProductInformationProperties = new Properties();
    private String workspaceName = null;
    private String applicationDataRootNodePath = null;
    private String productVersionDeclarationNodePath = null;
    private boolean firstRun = false;
    private RepositoryService repositoryService = null;
    private SessionProviderService sessionProviderService = null;

    public ProductInformations(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, ConfigurationManager cmanager, InitParams initParams) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        if (!initParams.containsKey((Object)PRODUCT_VERSIONS_DECLARATION_FILE)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Couldn't find the init value param: product.versions.declaration.file");
            }
            return;
        }
        String filePath = initParams.getValueParam(PRODUCT_VERSIONS_DECLARATION_FILE).getValue();
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Read products versions from " + filePath));
            }
            InputStream inputStream = cmanager.getInputStream(filePath);
            this.productInformationProperties.load(inputStream);
        }
        catch (IOException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Couldn't parse the file " + filePath), (Throwable)exception);
            }
            return;
        }
        catch (Exception exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error occured while reading the file " + filePath), (Throwable)exception);
            }
            return;
        }
        if (initParams.containsKey((Object)WORKING_WORSPACE_NAME)) {
            this.workspaceName = initParams.getValueParam(WORKING_WORSPACE_NAME).getValue();
        }
        this.applicationDataRootNodePath = nodeHierarchyCreator.getJcrPath(EXO_APPLICATIONS_DATA_NODE_ALIAS);
        if (this.applicationDataRootNodePath == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"exoApplicationDataNode wasn't found as 'NodeHierarchyCreator' alias");
            }
            return;
        }
        if (this.applicationDataRootNodePath.indexOf("/") == 0) {
            this.applicationDataRootNodePath = this.applicationDataRootNodePath.replaceFirst("/", "");
        }
        this.productVersionDeclarationNodePath = "/" + this.applicationDataRootNodePath + "/" + UPGRADE_PRODUCT_SERVICE_NODE_NAME + "/" + PRODUCT_VERSION_DECLARATION_NODE_NAME;
    }

    public String getVersion() throws MissingProductInformationException {
        return this.getVersion(this.getCurrentProductGroupId());
    }

    public String getVersion(String productGroupId) throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(productGroupId)) {
            throw new MissingProductInformationException(productGroupId);
        }
        return this.productInformationProperties.getProperty(productGroupId);
    }

    public String getBuildNumber() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_BUILD_NUMBER)) {
            throw new MissingProductInformationException(PRODUCT_BUILD_NUMBER);
        }
        return this.productInformationProperties.getProperty(PRODUCT_BUILD_NUMBER);
    }

    public String getRevision() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_REVISION)) {
            throw new MissingProductInformationException(PRODUCT_REVISION);
        }
        return this.productInformationProperties.getProperty(PRODUCT_REVISION);
    }

    public String getCurrentProductGroupId() throws MissingProductInformationException {
        if (!this.productInformationProperties.containsKey(PRODUCT_GROUP_ID)) {
            throw new MissingProductInformationException(PRODUCT_GROUP_ID);
        }
        return this.productInformationProperties.getProperty(PRODUCT_GROUP_ID);
    }

    public String getPreviousVersion() throws MissingProductInformationException {
        return this.getPreviousVersion(this.getCurrentProductGroupId());
    }

    public String getPreviousVersion(String productGroupId) throws MissingProductInformationException {
        if (!this.previousProductInformationProperties.containsKey(productGroupId)) {
            throw new MissingProductInformationException(productGroupId);
        }
        return this.previousProductInformationProperties.getProperty(productGroupId);
    }

    public String getPreviousBuildNumber() throws MissingProductInformationException {
        if (!this.previousProductInformationProperties.containsKey(PRODUCT_BUILD_NUMBER)) {
            throw new MissingProductInformationException(PRODUCT_BUILD_NUMBER);
        }
        return this.previousProductInformationProperties.getProperty(PRODUCT_BUILD_NUMBER);
    }

    public String getPreviousRevision() throws MissingProductInformationException {
        if (!this.previousProductInformationProperties.containsKey(PRODUCT_REVISION)) {
            throw new MissingProductInformationException(PRODUCT_REVISION);
        }
        return this.previousProductInformationProperties.getProperty(PRODUCT_REVISION);
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start method begin");
        }
        if (this.workspaceName == null || this.workspaceName.equals("")) {
            try {
                this.workspaceName = this.repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Workspace wasn't specified, use '" + this.workspaceName + "' as default workspace of this repository."));
                }
            }
            catch (RepositoryException exception) {
                LOG.error((Object)"Error occured while getting default workspace name.", (Throwable)exception);
                return;
            }
            catch (RepositoryConfigurationException exception) {
                LOG.error((Object)"Error occured while getting default workspace name.", (Throwable)exception);
                return;
            }
        }
        Session session = null;
        try {
            session = this.getSession();
            Node applicationDataNode = null;
            if (session.getRootNode().hasNode(this.applicationDataRootNodePath)) {
                applicationDataNode = session.getRootNode().getNode(this.applicationDataRootNodePath);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"'Application Data' doesn't exist, creating it ... ");
                }
                applicationDataNode = session.getRootNode().addNode(this.applicationDataRootNodePath, "nt:unstructured");
                applicationDataNode.addMixin("exo:hiddenable");
            }
            Node productVersionDeclarationNode = null;
            if (applicationDataNode.hasNode(UPGRADE_PRODUCT_SERVICE_NODE_NAME)) {
                productVersionDeclarationNode = applicationDataNode.getNode("ProductInformationsService/productVersionDeclarationNode");
                String previousVersionData = ((Property)session.getItem(productVersionDeclarationNode.getPath() + "/jcr:content/jcr:data")).getString();
                this.previousProductInformationProperties = new Properties();
                this.previousProductInformationProperties.load(new ByteArrayInputStream(previousVersionData.getBytes()));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Product server first run: setup product Version Declaration Node");
                }
                this.firstRun = true;
                Node UpgradeProductServiceNode = applicationDataNode.addNode(UPGRADE_PRODUCT_SERVICE_NODE_NAME, "nt:unstructured");
                productVersionDeclarationNode = UpgradeProductServiceNode.addNode(PRODUCT_VERSION_DECLARATION_NODE_NAME, "nt:file");
                Node productVersionDeclarationNodeContent = productVersionDeclarationNode.addNode("jcr:content", "nt:resource");
                productVersionDeclarationNodeContent.setProperty("jcr:encoding", "UTF-8");
                productVersionDeclarationNodeContent.setProperty("jcr:mimeType", "text/plain");
                productVersionDeclarationNodeContent.setProperty("jcr:data", this.getCurrentProductInformationsAsString());
                productVersionDeclarationNodeContent.setProperty("jcr:lastModified", new Date().getTime());
                if (!productVersionDeclarationNode.isNodeType(MIX_VERSIONABLE)) {
                    productVersionDeclarationNode.addMixin(MIX_VERSIONABLE);
                }
                session.save();
                session.refresh(true);
                this.previousProductInformationProperties = (Properties)this.productInformationProperties.clone();
            }
        }
        catch (LoginException exception) {
            LOG.error((Object)"Can't load product informations from the JCR: Error when getting JCR session.", (Throwable)exception);
            return;
        }
        catch (NoSuchWorkspaceException exception) {
            LOG.error((Object)"Can't load product informations from the JCR: Error when getting JCR session.", (Throwable)exception);
            return;
        }
        catch (RepositoryException exception) {
            LOG.error((Object)"Can't load product informations from the JCR!", (Throwable)exception);
            return;
        }
        catch (IOException exception) {
            LOG.error((Object)"Can't load product informations from the JCR: the data stored in the JCR couldn't be parsed.", (Throwable)exception);
            return;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start method end");
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProductsInformationsInJCR() {
        Session session = null;
        try {
            session = this.getSession();
            Node productVersionDeclarationNode = (Node)session.getItem(this.productVersionDeclarationNodePath);
            Version version = productVersionDeclarationNode.checkin();
            productVersionDeclarationNode.getSession().save();
            productVersionDeclarationNode.getVersionHistory().addVersionLabel(version.getName(), this.getPreviousVersion(), false);
            productVersionDeclarationNode.checkout();
            Node productVersionDeclarationNodeContent = productVersionDeclarationNode.getNode("jcr:content");
            productVersionDeclarationNodeContent.setProperty("jcr:data", this.getCurrentProductInformationsAsString());
            productVersionDeclarationNodeContent.setProperty("jcr:lastModified", new Date().getTime());
            productVersionDeclarationNode.getSession().save();
        }
        catch (LoginException exception) {
            LOG.error((Object)"Can't store informations in the JCR: Error when getting JCR session.", (Throwable)exception);
        }
        catch (NoSuchWorkspaceException exception) {
            LOG.error((Object)"Can't store informations in the JCR: Error when getting JCR session.", (Throwable)exception);
        }
        catch (RepositoryException exception) {
            LOG.error((Object)"Can't store informations in the JCR!", (Throwable)exception);
        }
        catch (MissingProductInformationException exception) {
            LOG.error((Object)"Can't read current product version!", (Throwable)exception);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private String getCurrentProductInformationsAsString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.productInformationProperties.list(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private Session getSession() throws RepositoryException, LoginException, NoSuchWorkspaceException {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        return sessionProvider.getSession(this.workspaceName, repository);
    }

    public String getProductVersionDeclarationNodePath() {
        return this.productVersionDeclarationNodePath;
    }

    public void setPreviousVersionsIfFirstRun(String defaultVersion) {
        if (this.isFirstRun()) {
            this.previousProductInformationProperties = (Properties)this.productInformationProperties.clone();
            Set<Object> keys = this.previousProductInformationProperties.keySet();
            for (Object key : keys) {
                this.previousProductInformationProperties.setProperty((String)key, defaultVersion);
            }
        }
    }
}

