/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class UpgradeProductService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(UpgradeProductService.class);
    private static final String PLUGINS_ORDER = "commons.upgrade.plugins.order";
    private static final String PROCEED_UPGRADE_FIRST_RUN_KEY = "proceedUpgradeWhenFirstRun";
    private static final String PRODUCT_VERSION_ZERO = "0";
    private Set<UpgradeProductPlugin> upgradePlugins = new TreeSet<UpgradeProductPlugin>();
    private ProductInformations productInformations = null;
    private boolean proceedUpgradeFirstRun = false;

    public UpgradeProductService(ProductInformations productInformations, InitParams initParams) {
        this.productInformations = productInformations;
        if (!initParams.containsKey((Object)PROCEED_UPGRADE_FIRST_RUN_KEY)) {
            LOG.warn((Object)("init param 'proceedUpgradeWhenFirstRun' isn't set, use default value (" + this.proceedUpgradeFirstRun + "). Don't proceed upgrade when this service will run for the first time."));
        } else {
            this.proceedUpgradeFirstRun = Boolean.parseBoolean(initParams.getValueParam(PROCEED_UPGRADE_FIRST_RUN_KEY).getValue());
        }
    }

    public void addUpgradePlugin(UpgradeProductPlugin upgradeProductPlugin) {
        LOG.info((Object)("Add Product UpgradePlugin: name = " + upgradeProductPlugin.getName()));
        if (this.upgradePlugins.contains(upgradeProductPlugin)) {
            LOG.warn((Object)(upgradeProductPlugin.getName() + " upgrade plugin is duplicated. One of the duplicated plugins will be ignored!"));
        }
        if (upgradeProductPlugin.isEnabled()) {
            this.upgradePlugins.add(upgradeProductPlugin);
        } else {
            LOG.info((Object)("UpgradePlugin: name = '" + upgradeProductPlugin.getName() + "' will be ignored, because it is not enabled."));
        }
    }

    public void start() {
        block13: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"start method begin");
            }
            if (this.proceedUpgradeFirstRun) {
                this.productInformations.setPreviousVersionsIfFirstRun(PRODUCT_VERSION_ZERO);
            }
            try {
                String currentVersion = this.productInformations.getVersion();
                String previousVersion = this.productInformations.getPreviousVersion();
                if (previousVersion.equals(currentVersion)) break block13;
                LOG.info((Object)("New version has been detected: proceed upgrading from " + previousVersion + " to " + currentVersion));
                String pluginsOrder = PropertyManager.getProperty((String)PLUGINS_ORDER);
                if (pluginsOrder == null) {
                    for (UpgradeProductPlugin upgradeProductPlugin : this.upgradePlugins) {
                        this.doUpgrade(upgradeProductPlugin, upgradeProductPlugin.getPluginExecutionOrder());
                        LOG.info((Object)("Upgrade " + upgradeProductPlugin.getName() + " completed."));
                    }
                } else {
                    String[] upgradePluginNames = pluginsOrder.split(",");
                    block3: for (int i = 0; i < upgradePluginNames.length; ++i) {
                        if (this.upgradePlugins.size() > 0) {
                            Iterator<UpgradeProductPlugin> iterator = this.upgradePlugins.iterator();
                            while (iterator.hasNext()) {
                                UpgradeProductPlugin upgradeProductPlugin = iterator.next();
                                if (!upgradeProductPlugin.getName().equals(upgradePluginNames[i])) continue;
                                this.doUpgrade(upgradeProductPlugin, i);
                                iterator.remove();
                                continue block3;
                            }
                            continue;
                        }
                        LOG.warn((Object)(upgradePluginNames[i] + " will be ignored!. \"" + PLUGINS_ORDER + "\" property contains more elements than it should..."));
                    }
                    if (this.upgradePlugins.size() > 0) {
                        for (UpgradeProductPlugin upgradeProductPlugin : this.upgradePlugins) {
                            this.doUpgrade(upgradeProductPlugin, -1);
                        }
                    }
                }
                this.productInformations.storeProductsInformationsInJCR();
                LOG.info((Object)"Version upgrade completed.");
            }
            catch (MissingProductInformationException missingProductInformationException) {
                LOG.error((Object)"Can't proceed to the upgrade", (Throwable)missingProductInformationException);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start method end");
        }
    }

    private void doUpgrade(UpgradeProductPlugin upgradeProductPlugin, int order) {
        try {
            String currentProductPluginVersion = this.productInformations.getVersion(upgradeProductPlugin.getProductGroupId());
            String previousProductPluginVersion = "";
            try {
                previousProductPluginVersion = this.productInformations.getPreviousVersion(upgradeProductPlugin.getOldProductGroupId());
            }
            catch (Exception e) {
                previousProductPluginVersion = this.productInformations.getPreviousVersion(upgradeProductPlugin.getProductGroupId());
            }
            if (upgradeProductPlugin.shouldProceedToUpgrade(currentProductPluginVersion, previousProductPluginVersion)) {
                LOG.info((Object)("Proceed upgrade plugin: name = " + upgradeProductPlugin.getName() + " from version " + previousProductPluginVersion + " to " + currentProductPluginVersion + " with execution order = " + order));
                upgradeProductPlugin.processUpgrade(previousProductPluginVersion, currentProductPluginVersion);
            } else {
                LOG.info((Object)("'" + upgradeProductPlugin.getName() + "' upgrade plugin execution will be ignored because shouldProceedToUpgrade = false"));
            }
        }
        catch (MissingProductInformationException exception) {
            LOG.error((Object)("The plugin " + upgradeProductPlugin.getName() + " generated an error."), (Throwable)exception);
        }
    }

    public void stop() {
    }
}

