/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.upgrade.UpgradeProductService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.BaseGateInTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.commons.component.upgrade-local-configuration.xml")})
public class UpgradeProductTest
extends BaseCommonsTestCase {
    private static final String OLD_PRODUCT_INFORMATIONS_FILE = "classpath:/conf/data/product_old.properties";
    private static final String NEW_PRODUCT_INFORMATIONS_FILE = "classpath:/conf/data/product_new.properties";
    private static final String NEWER_PRODUCT_INFORMATIONS_FILE = "classpath:/conf/data/product_newer.properties";
    private ProductInformations productInformations;
    private SettingService settingService;
    private UpgradeProductService upgradeService;
    protected ConfigurationManager configurationManager;
    private static ArrayList<String> versions;

    public UpgradeProductTest() {
        this.setForceContainerReload(true);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.upgradeService = (UpgradeProductService)this.getContainer().getComponentInstanceOfType(UpgradeProductService.class);
        this.productInformations = (ProductInformations)this.getService(ProductInformations.class);
        this.settingService = (SettingService)this.getService(SettingService.class);
        this.configurationManager = (ConfigurationManager)this.getService(ConfigurationManager.class);
        versions = new ArrayList();
    }

    public void testProcessUpgrade() throws MissingProductInformationException {
        PropertyManager.setProperty((String)"commons.upgrade.portalPlugin.enable", (String)"true");
        PropertyManager.setProperty((String)"commons.upgrade.dummyPlugin.enable", (String)"false");
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.portal");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("1");
        params.addParameter((Parameter)param);
        UpgradePluginFromVersionZERO upgradePortalPlugin = new UpgradePluginFromVersionZERO(params);
        upgradePortalPlugin.setName("portalUpgrade");
        params = new InitParams();
        param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        UpgradePluginFromVersionX upgradeSocialPlugin = new UpgradePluginFromVersionX(params);
        upgradeSocialPlugin.setName("socialUpgrade");
        UpgradeProductPlugin dummyPlugin = new UpgradeProductPlugin(params){

            public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
                return true;
            }

            public void processUpgrade(String oldVersion, String newVersion) {
            }
        };
        dummyPlugin.setName("dummyPlugin");
        UpgradeProductTest.assertTrue((boolean)upgradePortalPlugin.isEnabled());
        UpgradeProductTest.assertTrue((boolean)upgradeSocialPlugin.isEnabled());
        UpgradeProductTest.assertFalse((boolean)dummyPlugin.isEnabled());
        this.productInformations.start();
        this.upgradeService.start();
        String portalVersion = this.productInformations.getVersion("org.gatein.portal");
        String portalPrevVersion = this.productInformations.getPreviousVersion("org.gatein.portal");
        String socialVersion = this.productInformations.getVersion("org.exoplatform.social");
        String socialPrevVersion = this.productInformations.getPreviousVersion("org.exoplatform.social");
        UpgradeProductTest.assertEquals((boolean)portalPrevVersion.equals("0"), (boolean)versions.contains(portalVersion + "-ZERO-Version"));
        UpgradeProductTest.assertEquals((boolean)socialPrevVersion.equals("0"), (boolean)versions.contains(socialVersion + "-X-Version"));
    }

    public void testProcessDevelopmentVersionUpgrade() throws Exception {
        PropertyManager.setProperty((String)"commons.upgrade.developmentUpgrade.enable", (String)"true");
        this.upgradeService.start();
        this.restartTransaction();
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.meeds");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("1");
        params.addParameter((Parameter)param);
        UpgradePluginExecutedOnce developmentUpgradePlugin = new UpgradePluginExecutedOnce(params);
        developmentUpgradePlugin.setName("developmentUpgrade");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)developmentUpgradePlugin);
        UpgradeProductTest.assertTrue((boolean)developmentUpgradePlugin.isEnabled());
        UpgradePluginExecutedOnce.PROCESSED = false;
        this.upgradeService.start();
        UpgradeProductTest.assertTrue((boolean)UpgradePluginExecutedOnce.PROCESSED);
        this.restartTransaction();
        this.resetPreviousProductInformation(NEW_PRODUCT_INFORMATIONS_FILE);
        UpgradePluginExecutedOnce.PROCESSED = false;
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)UpgradePluginExecutedOnce.PROCESSED);
        this.updateNewProductionInformations(NEWER_PRODUCT_INFORMATIONS_FILE);
        this.upgradeService.start();
        UpgradeProductTest.assertTrue((boolean)UpgradePluginExecutedOnce.PROCESSED);
    }

    public void testUpgradeWithDisabledPlugin() {
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.portal");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("1");
        params.addParameter((Parameter)param);
        UpgradePluginFromVersionX upgradePortalPlugin = new UpgradePluginFromVersionX(params);
        upgradePortalPlugin.setName("portalUpgrade");
        params = new InitParams();
        param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        UpgradeProductPlugin dummyPlugin = new UpgradeProductPlugin(params){

            public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
                return true;
            }

            public void processUpgrade(String oldVersion, String newVersion) {
            }
        };
        dummyPlugin.setName("dummyPlugin");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradePortalPlugin);
        this.upgradeService.addUpgradePlugin(dummyPlugin);
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)dummyPlugin.isEnabled());
        UpgradeProductTest.assertTrue((boolean)upgradePortalPlugin.isEnabled());
    }

    public void testUpgradeWithTargetVersion() {
        this.productInformations.setFirstRun(false);
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.upgrade.target.version");
        param.setValue("1.0-M3");
        params.addParameter((Parameter)param);
        UpgradePluginWithTargetVersion upgradeProductPlugin = new UpgradePluginWithTargetVersion(params);
        upgradeProductPlugin.setName("UpgradePluginWithTargetVersion");
        UpgradeProductTest.assertEquals((String)"1.0-M3", (String)upgradeProductPlugin.getTargetVersion());
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradeProductPlugin);
        try {
            this.resetPreviousProductInformation(OLD_PRODUCT_INFORMATIONS_FILE);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertEquals((long)1L, (long)UpgradePluginWithTargetVersion.COUNT.get());
        UpgradeProductTest.assertTrue((boolean)UpgradePluginWithTargetVersion.PROCESSED);
        UpgradePluginWithTargetVersion.PROCESSED = false;
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)UpgradePluginWithTargetVersion.PROCESSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpgradeAsynchronous() {
        this.productInformations.setFirstRun(false);
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        UpgradePluginAsynchronous upgradeProductPlugin = new UpgradePluginAsynchronous(params);
        UpgradeProductTest.assertFalse((boolean)upgradeProductPlugin.isAsyncUpgradeExecution());
        param = new ValueParam();
        param.setName("plugin.upgrade.async.execution");
        param.setValue("true");
        params.addParameter((Parameter)param);
        upgradeProductPlugin = new UpgradePluginAsynchronous(params);
        UpgradeProductTest.assertTrue((boolean)upgradeProductPlugin.isAsyncUpgradeExecution());
        upgradeProductPlugin.setName("UpgradePluginAsynchronous");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradeProductPlugin);
        try {
            this.resetPreviousProductInformation(OLD_PRODUCT_INFORMATIONS_FILE);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        upgradeProductPlugin.executeParentThread.lock();
        upgradeProductPlugin.executePluginLock.lock();
        try {
            this.productInformations.start();
            this.upgradeService.start();
            UpgradeProductTest.assertFalse((boolean)UpgradePluginAsynchronous.PROCESSED);
        }
        finally {
            upgradeProductPlugin.executePluginLock.unlock();
        }
        upgradeProductPlugin.executeParentThread.lock();
        upgradeProductPlugin.executeParentThread.unlock();
        UpgradeProductTest.assertEquals((long)1L, (long)UpgradePluginAsynchronous.COUNT.get());
        UpgradeProductTest.assertTrue((boolean)UpgradePluginAsynchronous.PROCESSED);
        UpgradePluginAsynchronous.PROCESSED = false;
        this.updateNewProductionInformations(NEWER_PRODUCT_INFORMATIONS_FILE);
        upgradeProductPlugin.executeParentThread.lock();
        upgradeProductPlugin.executePluginLock.lock();
        try {
            this.productInformations.start();
            this.upgradeService.start();
        }
        finally {
            upgradeProductPlugin.executePluginLock.unlock();
        }
        upgradeProductPlugin.executeParentThread.lock();
        upgradeProductPlugin.executeParentThread.unlock();
        UpgradeProductTest.assertEquals((long)2L, (long)UpgradePluginAsynchronous.COUNT.get());
        UpgradeProductTest.assertTrue((boolean)UpgradePluginAsynchronous.PROCESSED);
    }

    public void testUpgradeExecutedOnce() {
        this.productInformations.setFirstRun(false);
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        UpgradePluginExecutedOnce upgradeProductPlugin = new UpgradePluginExecutedOnce(params);
        UpgradeProductTest.assertFalse((boolean)upgradeProductPlugin.isExecuteOnlyOnce());
        param = new ValueParam();
        param.setName("plugin.upgrade.execute.once");
        param.setValue("true");
        params.addParameter((Parameter)param);
        upgradeProductPlugin = new UpgradePluginExecutedOnce(params);
        UpgradeProductTest.assertTrue((boolean)upgradeProductPlugin.isExecuteOnlyOnce());
        upgradeProductPlugin.setName("UpgradePluginExecutedOnce");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradeProductPlugin);
        try {
            this.resetPreviousProductInformation(OLD_PRODUCT_INFORMATIONS_FILE);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertTrue((boolean)UpgradePluginExecutedOnce.PROCESSED);
        UpgradePluginExecutedOnce.PROCESSED = false;
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)UpgradePluginExecutedOnce.PROCESSED);
    }

    public void testUpgradeErrorFirstCallWithTargetVersion() {
        this.productInformations.setFirstRun(false);
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.upgrade.execute.once");
        param.setValue("true");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.upgrade.target.version");
        param.setValue("1.0-M5");
        params.addParameter((Parameter)param);
        UpgradePluginErrorFirstCall.PROCESSED = false;
        UpgradePluginErrorFirstCall.COUNT = new AtomicLong(0L);
        UpgradePluginErrorFirstCall upgradeProductPlugin = new UpgradePluginErrorFirstCall(params);
        upgradeProductPlugin.setName("UpgradePluginErrorFirstCallWithTargetVersion");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradeProductPlugin);
        try {
            this.resetPreviousProductInformation(OLD_PRODUCT_INFORMATIONS_FILE);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)UpgradePluginErrorFirstCall.PROCESSED);
        UpgradeProductTest.assertEquals((long)1L, (long)UpgradePluginErrorFirstCall.COUNT.get());
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertEquals((long)2L, (long)UpgradePluginErrorFirstCall.COUNT.get());
        UpgradeProductTest.assertTrue((boolean)UpgradePluginErrorFirstCall.PROCESSED);
    }

    public void testUpgradeErrorFirstCall() {
        this.productInformations.setFirstRun(false);
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.social");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("2");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.upgrade.execute.once");
        param.setValue("true");
        params.addParameter((Parameter)param);
        UpgradePluginErrorFirstCall.PROCESSED = false;
        UpgradePluginErrorFirstCall.COUNT = new AtomicLong(0L);
        UpgradePluginErrorFirstCall upgradeProductPlugin = new UpgradePluginErrorFirstCall(params);
        upgradeProductPlugin.setName("UpgradePluginErrorFirstCall");
        this.upgradeService.addUpgradePlugin((UpgradeProductPlugin)upgradeProductPlugin);
        try {
            this.resetPreviousProductInformation(OLD_PRODUCT_INFORMATIONS_FILE);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertFalse((boolean)UpgradePluginErrorFirstCall.PROCESSED);
        UpgradeProductTest.assertEquals((long)1L, (long)UpgradePluginErrorFirstCall.COUNT.get());
        this.productInformations.start();
        this.upgradeService.start();
        UpgradeProductTest.assertEquals((long)2L, (long)UpgradePluginErrorFirstCall.COUNT.get());
        UpgradeProductTest.assertTrue((boolean)UpgradePluginErrorFirstCall.PROCESSED);
    }

    public void testUpgradeStatus() {
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.portal");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("plugin.execution.order");
        param.setValue("1");
        params.addParameter((Parameter)param);
        UpgradePluginFromVersionZERO upgradePortalPlugin = new UpgradePluginFromVersionZERO(params);
        upgradePortalPlugin.setName("portalUpgrade");
        params = new InitParams();
        param = new ValueParam();
        param.setName("product.group.id");
        param.setValue("org.exoplatform.platform");
        params.addParameter((Parameter)param);
        SettingService settingService = (SettingService)this.container.getComponentInstanceOfType(SettingService.class);
        UpgradeProductTest.assertNotNull((String)"SettingService is not configured", (Object)settingService);
        UpgradePluginStatus upgradeStatus = new UpgradePluginStatus(settingService, params);
        upgradeStatus.setName("statusUpgrade");
        UpgradeProductTest.assertTrue((String)"Status should be != COMPLETED", (boolean)upgradeStatus.shouldProceedToUpgrade("", ""));
        upgradeStatus.processUpgrade("", "");
        UpgradeProductTest.assertTrue((String)"Status should be != COMPLETED even after upgrade completion AND UpdateStatusAfterUpgrade = false", (boolean)upgradeStatus.shouldProceedToUpgrade("", ""));
        upgradeStatus.setUpdateStatusAfterUpgrade(true);
        upgradeStatus.processUpgrade("", "");
        UpgradeProductTest.assertFalse((String)"Status should be == COMPLETED after upgrade completion AND UpdateStatusAfterUpgrade = true", (boolean)upgradeStatus.shouldProceedToUpgrade("", ""));
    }

    public void tearDown() throws Exception {
        this.upgradeService.getUpgradePlugins().clear();
        try {
            this.updateNewProductionInformations(NEW_PRODUCT_INFORMATIONS_FILE);
            this.settingService.remove(UpgradeProductService.UPGRADE_PRODUCT_CONTEXT);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
        super.tearDown();
    }

    private void resetPreviousProductInformation(String filePath) throws Exception {
        InputStream oldVersionsContentIS = this.configurationManager.getInputStream(filePath);
        Properties properties = new Properties();
        properties.load(oldVersionsContentIS);
        this.productInformations.initProductInformation(properties);
        this.productInformations.storeProductInformation(this.productInformations.getProductInformation());
    }

    private void updateNewProductionInformations(String filePath) {
        try {
            InputStream newVersionsContentIS = this.configurationManager.getInputStream(filePath);
            byte[] binaries = new byte[newVersionsContentIS.available()];
            newVersionsContentIS.read(binaries);
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(binaries));
            this.productInformations.setProductInformationProperties(properties);
        }
        catch (Exception e) {
            UpgradeProductTest.fail((Throwable)e);
        }
    }

    public static class UpgradePluginFromVersionZERO
    extends UpgradeProductPlugin {
        public UpgradePluginFromVersionZERO(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            versions.add(newVersion + "-ZERO-Version");
        }

        public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
            return previousVersion.equals("0");
        }
    }

    public static class UpgradePluginFromVersionX
    extends UpgradeProductPlugin {
        public UpgradePluginFromVersionX(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            versions.add(newVersion + "-X-Version");
        }

        public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
            return !previousVersion.equals("0");
        }
    }

    public static class UpgradePluginExecutedOnce
    extends UpgradeProductPlugin {
        public static boolean PROCESSED;

        public UpgradePluginExecutedOnce(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            PROCESSED = true;
        }
    }

    public static class UpgradePluginWithTargetVersion
    extends UpgradeProductPlugin {
        public static final AtomicLong COUNT = new AtomicLong(0L);
        public static boolean PROCESSED;

        public UpgradePluginWithTargetVersion(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            PROCESSED = true;
            COUNT.incrementAndGet();
        }
    }

    public static class UpgradePluginAsynchronous
    extends UpgradeProductPlugin {
        public static AtomicLong COUNT = new AtomicLong(0L);
        public static boolean PROCESSED;
        public Lock executeParentThread = new Lock();
        public Lock executePluginLock = new Lock();

        public UpgradePluginAsynchronous(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            this.executePluginLock.lock();
            try {
                PROCESSED = true;
                COUNT.incrementAndGet();
            }
            finally {
                this.executePluginLock.unlock();
                this.executeParentThread.unlock();
            }
        }
    }

    public static class Lock {
        private boolean locked = false;

        public synchronized void lock() {
            try {
                while (this.locked) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Wait was interrupted unexpectly", e);
            }
            this.locked = true;
        }

        public synchronized void unlock() {
            this.locked = false;
            this.notify();
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    public static class UpgradePluginErrorFirstCall
    extends UpgradeProductPlugin {
        public static AtomicLong COUNT = new AtomicLong(0L);
        public static boolean PROCESSED;

        public UpgradePluginErrorFirstCall(InitParams initParams) {
            super(initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            if (COUNT.incrementAndGet() == 1L) {
                throw new RuntimeException("EXPECTED EXCEPTION");
            }
            PROCESSED = true;
        }
    }

    public static class UpgradePluginStatus
    extends UpgradeProductPlugin {
        private static final String MIGRATION_STATUS_COMPLETED = "COMPLETED";
        private static final String MIGRATION_STATUS = "Migration_STATUS";
        boolean updateStatusAfterUpgrade = false;

        public UpgradePluginStatus(SettingService settingService, InitParams initParams) {
            super(settingService, initParams);
        }

        public void processUpgrade(String oldVersion, String newVersion) {
            try {
                if (this.updateStatusAfterUpgrade) {
                    this.storeValueForPlugin(MIGRATION_STATUS, MIGRATION_STATUS_COMPLETED);
                }
            }
            catch (Exception e) {
                BaseGateInTest.fail((Throwable)e);
            }
        }

        public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
            String migrationstatus = this.getValue(MIGRATION_STATUS);
            return StringUtils.isBlank((String)migrationstatus) || !MIGRATION_STATUS_COMPLETED.equals(migrationstatus);
        }

        public void setUpdateStatusAfterUpgrade(boolean updateStatusAfterUpgrade) {
            this.updateStatusAfterUpgrade = updateStatusAfterUpgrade;
        }

        public boolean isUpdateStatusAfterUpgrade() {
            return this.updateStatusAfterUpgrade;
        }
    }
}

