/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.job;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.OrphanFile;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.job.FileStorageCronJob;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class FileStorageCleanJob
implements Job {
    private static Log Log = ExoLogger.getLogger(FileStorageCleanJob.class);
    private static int defaultRetention = 30;
    private static AtomicBoolean enabled = new AtomicBoolean(true);
    private static AtomicBoolean started = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Log.info((Object)"Start to clean old FileStorage...");
        if (!enabled.get()) {
            Log.info((Object)"Job disabled");
            return;
        }
        try {
            DataStorage dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
            BinaryProvider binaryProvider = (BinaryProvider)CommonsUtils.getService(BinaryProvider.class);
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            int retention = defaultRetention;
            if (jdatamap != null) {
                String valueParam = jdatamap.getString(FileStorageCronJob.RETENTION_PARAM);
                try {
                    retention = Integer.parseInt(valueParam);
                }
                catch (NumberFormatException ex) {
                    Log.warn("Invalid param retention-time value={}", new Object[]{valueParam});
                }
                if (retention == -1) {
                    return;
                }
                valueParam = jdatamap.getString(FileStorageCronJob.ENABLED_PARAM);
                try {
                    enabled.set(Boolean.valueOf(valueParam));
                }
                catch (Exception ex) {
                    Log.warn("Invalid param enabled value={}", new Object[]{valueParam});
                }
            }
            started.set(true);
            List<OrphanFile> noParent = dataStorage.getAllOrphanFile(FileStorageCleanJob.daysAgo(retention));
            if (noParent.size() > 0) {
                Log.info("Remove Orphan files size={}", new Object[]{noParent.size()});
            }
            for (OrphanFile file : noParent) {
                try {
                    Log.info("remove File path={}", new Object[]{binaryProvider.getFilePath(file.getChecksum())});
                    if (dataStorage.sharedChecksum(file.getChecksum()) == 0) {
                        binaryProvider.remove(file.getChecksum());
                    }
                    dataStorage.deleteOrphanFile(file.getId());
                }
                catch (IOException e) {
                    Log.warn("Unable to remove file name {}", new Object[]{e.getMessage()});
                }
            }
            List<FileInfo> list = dataStorage.getAllDeletedFiles(FileStorageCleanJob.daysAgo(retention));
            if (list.size() > 0) {
                Log.info("Remove deleted files size={}", new Object[]{list.size()});
            }
            for (FileInfo file : list) {
                try {
                    Log.info("remove File path={}", new Object[]{binaryProvider.getFilePath(file)});
                    if (dataStorage.sharedChecksum(file.getChecksum()) == 1) {
                        binaryProvider.remove(file.getChecksum());
                    }
                    dataStorage.deleteFileInfo(file.getId());
                }
                catch (IOException e) {
                    Log.warn("Unable to remove file name {}", new Object[]{e.getMessage()});
                }
            }
            Log.info((Object)"End to clean old FileStorage...");
        }
        finally {
            started.set(false);
        }
    }

    private static Date daysAgo(int days) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.add(5, -days);
        return gc.getTime();
    }

    public static AtomicBoolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(Boolean enabled) {
        FileStorageCleanJob.enabled.getAndSet(enabled);
    }

    public static AtomicBoolean isStarted() {
        return started;
    }
}

