/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage.entity;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;

@Entity(name="NameSpaceEntity")
@ExoEntity
@Table(name="FILES_NAMESPACES")
@NamedQueries(value={@NamedQuery(name="nameSpace.getNameSpaceByName", query="SELECT t FROM NameSpaceEntity t WHERE t.name = :name")})
public class NameSpaceEntity {
    @Id
    @Column(name="NAMESPACE_ID")
    @SequenceGenerator(name="SEQ_FILES_NS_NAMESPACE_ID", sequenceName="SEQ_FILES_NS_NAMESPACE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FILES_NS_NAMESPACE_ID")
    private long id;
    @Column(name="NAME")
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @OneToMany(mappedBy="nameSpaceEntity", fetch=FetchType.LAZY)
    private List<FileInfoEntity> filesInfo;

    public NameSpaceEntity() {
    }

    public NameSpaceEntity(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public NameSpaceEntity(long id, String name, String description) {
        this(name, description);
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FileInfoEntity> getFilesInfo() {
        return this.filesInfo;
    }

    public void setFilesInfo(List<FileInfoEntity> filesInfo) {
        this.filesInfo = filesInfo;
    }
}

