/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.util.HashMap;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ElasticContentRequestBuilder {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticContentRequestBuilder.class);

    public String getCreateIndexRequestContent(ElasticIndexingServiceConnector connector) {
        HashMap<String, String> indexProperties = new HashMap<String, String>();
        indexProperties.put("number_of_shards", String.valueOf(connector.getShards()));
        indexProperties.put("number_of_replicas", String.valueOf(connector.getReplicas()));
        JSONObject indexSettings = new JSONObject();
        for (String setting : indexProperties.keySet()) {
            indexSettings.put((Object)setting, indexProperties.get(setting));
        }
        JSONArray filters = new JSONArray();
        filters.add((Object)"standard");
        filters.add((Object)"lowercase");
        filters.add((Object)"asciifolding");
        JSONObject defaultAnalyzer = new JSONObject();
        defaultAnalyzer.put((Object)"filter", (Object)filters);
        defaultAnalyzer.put((Object)"tokenizer", (Object)"standard");
        JSONObject analyzer = new JSONObject();
        analyzer.put((Object)"default", (Object)defaultAnalyzer);
        JSONObject analysis = new JSONObject();
        analysis.put((Object)"analyzer", (Object)analyzer);
        indexSettings.put((Object)"analysis", (Object)analysis);
        JSONObject indexJSON = new JSONObject();
        indexJSON.put((Object)"settings", (Object)indexSettings);
        String request = indexJSON.toJSONString();
        LOG.debug((Object)("Create index request to ES: \n " + request));
        return request;
    }

    public String getDeleteDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject cudHeaderRequest = this.createCUDHeaderRequestContent(connector, id);
        JSONObject deleteRequest = new JSONObject();
        deleteRequest.put((Object)"delete", (Object)cudHeaderRequest);
        String request = deleteRequest.toJSONString() + "\n";
        LOG.debug((Object)("Delete request to ES: \n " + request));
        return request;
    }

    public String getCreateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.create(id);
        if (document == null) {
            throw new ElasticClientException("Document generated by connector " + connector.getName() + " for the creation of entity [" + id + "] is null");
        }
        JSONObject createRequest = new JSONObject();
        createRequest.put((Object)"create", (Object)ElasticInformation);
        String request = createRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        LOG.debug((Object)("Create request to ES: \n " + request));
        return request;
    }

    public String getUpdateDocumentRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject ElasticInformation = this.createCUDHeaderRequestContent(connector, id);
        Document document = connector.update(id);
        JSONObject updateRequest = new JSONObject();
        updateRequest.put((Object)"index", (Object)ElasticInformation);
        String request = updateRequest.toJSONString() + "\n" + document.toJSON() + "\n";
        LOG.debug((Object)("Update request to ES: \n " + request));
        return request;
    }

    private JSONObject createCUDHeaderRequestContent(ElasticIndexingServiceConnector connector, String id) {
        JSONObject CUDHeader = new JSONObject();
        CUDHeader.put((Object)"_index", (Object)connector.getIndex());
        CUDHeader.put((Object)"_type", (Object)connector.getType());
        CUDHeader.put((Object)"_id", (Object)id);
        return CUDHeader;
    }
}

