/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticIndexingClient;
import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.search.index.impl.ElasticIndexingOperationProcessor$AjcClosure1;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ElasticIndexingOperationProcessor
extends IndexingOperationProcessor
implements Startable {
    private static final Log LOG;
    private static final String BATCH_NUMBER_PROPERTY_NAME = "exo.es.indexing.batch.number";
    private static final Integer BATCH_NUMBER_DEFAULT;
    private static final String REQUEST_SIZE_LIMIT_PROPERTY_NAME = "exo.es.indexing.request.size.limit";
    private static final Integer REQUEST_SIZE_LIMIT_DEFAULT;
    private static final String REINDEXING_BATCH_SIZE_PROPERTY_NAME = "exo.es.reindex.batch.size";
    private static final int REINDEXING_BATCH_SIZE_DEFAULT_VALUE = 100;
    private final IndexingOperationDAO indexingOperationDAO;
    private final ElasticIndexingClient elasticIndexingClient;
    private final ElasticContentRequestBuilder elasticContentRequestBuilder;
    private final ElasticIndexingAuditTrail auditTrail;
    private final EntityManagerService entityManagerService;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private Integer requestSizeLimit = REQUEST_SIZE_LIMIT_DEFAULT;
    private int reindexBatchSize = 100;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ElasticIndexingOperationProcessor(IndexingOperationDAO indexingOperationDAO, ElasticIndexingClient elasticIndexingClient, ElasticContentRequestBuilder elasticContentRequestBuilder, ElasticIndexingAuditTrail auditTrail, EntityManagerService entityManagerService, DataInitializer dataInitializer) {
        this.indexingOperationDAO = indexingOperationDAO;
        this.auditTrail = auditTrail;
        this.entityManagerService = entityManagerService;
        this.elasticIndexingClient = elasticIndexingClient;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME))) {
            this.batchNumber = Integer.valueOf(PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME))) {
            this.requestSizeLimit = Integer.valueOf(PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME))) {
            this.reindexBatchSize = Integer.valueOf(PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME));
        }
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.getConnectors().containsKey(indexingServiceConnector.getType()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getType()});
        } else {
            this.getConnectors().put(indexingServiceConnector.getType(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getType()});
        }
    }

    @Override
    public void process() {
        int processedOperations;
        while ((processedOperations = this.processBulk()) >= this.batchNumber) {
        }
    }

    private int processBulk() {
        HashMap<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted = new HashMap<OperationType, Map<String, List<IndexingOperation>>>();
        long maxIndexingOperationId = 0L;
        List<IndexingOperation> indexingOperations = this.indexingOperationDAO.findAllFirst(this.batchNumber);
        for (IndexingOperation indexingOperation : indexingOperations) {
            this.putIndexingOperationInMemoryQueue(indexingOperation, indexingQueueSorted);
            if (maxIndexingOperationId >= indexingOperation.getId()) continue;
            maxIndexingOperationId = indexingOperation.getId();
        }
        this.processInit(indexingQueueSorted);
        this.processDeleteAll(indexingQueueSorted);
        this.processReindexAll(indexingQueueSorted);
        this.processCUD(indexingQueueSorted);
        this.indexingOperationDAO.deleteAllIndexingOperationsHavingIdLessThanOrEqual(maxIndexingOperationId);
        this.entityManagerService.getEntityManager().clear();
        return indexingOperations.size();
    }

    private void putIndexingOperationInMemoryQueue(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (!indexingQueueSorted.containsKey((Object)indexingOperation.getOperation())) {
            indexingQueueSorted.put(indexingOperation.getOperation(), new HashMap());
        }
        if (!indexingQueueSorted.get((Object)indexingOperation.getOperation()).containsKey(indexingOperation.getEntityType())) {
            indexingQueueSorted.get((Object)indexingOperation.getOperation()).put(indexingOperation.getEntityType(), new ArrayList());
        }
        indexingQueueSorted.get((Object)indexingOperation.getOperation()).get(indexingOperation.getEntityType()).add(indexingOperation);
    }

    private void processCUD(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        String bulkRequest = "";
        if (indexingQueueSorted.containsKey((Object)OperationType.DELETE)) {
            Map<String, List<IndexingOperation>> deleteIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.DELETE);
            for (String entityType : deleteIndexingOperationsMap.keySet()) {
                List<IndexingOperation> deleteIndexingOperationsList = deleteIndexingOperationsMap.get(entityType);
                if (deleteIndexingOperationsList == null || deleteIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> deleteIndexingOperationsIterator = deleteIndexingOperationsList.iterator();
                while (deleteIndexingOperationsIterator.hasNext()) {
                    IndexingOperation deleteIndexQueue = deleteIndexingOperationsIterator.next();
                    try {
                        bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(deleteIndexQueue.getEntityType()), deleteIndexQueue.getEntityId());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while *deleting* index entry of entity, type = " + entityType + ", id =" + (deleteIndexQueue == null ? null : deleteIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                    }
                    deleteIndexingOperationsIterator.remove();
                    this.deleteOperationsByEntityIdForTypesBefore(new OperationType[]{OperationType.CREATE}, indexingQueueSorted, deleteIndexQueue);
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, deleteIndexQueue);
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.DELETE);
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.CREATE)) {
            Map<String, List<IndexingOperation>> createIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.CREATE);
            for (String entityType : createIndexingOperationsMap.keySet()) {
                List<IndexingOperation> createIndexingOperationsList = createIndexingOperationsMap.get(entityType);
                if (createIndexingOperationsList == null || createIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> createIndexingOperationsIterator = createIndexingOperationsList.iterator();
                while (createIndexingOperationsIterator.hasNext()) {
                    IndexingOperation createIndexQueue = createIndexingOperationsIterator.next();
                    try {
                        bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getCreateDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(createIndexQueue.getEntityType()), createIndexQueue.getEntityId());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while *creating* index entry of entity, type = " + entityType + ", id =" + (createIndexQueue == null ? null : createIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                    }
                    createIndexingOperationsIterator.remove();
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.CREATE);
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.UPDATE)) {
            Map<String, List<IndexingOperation>> updateIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.UPDATE);
            for (String entityType : updateIndexingOperationsMap.keySet()) {
                List<IndexingOperation> updateIndexingOperationsList = updateIndexingOperationsMap.get(entityType);
                if (updateIndexingOperationsList == null || updateIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> updateIndexingOperationsIterator = updateIndexingOperationsList.iterator();
                while (updateIndexingOperationsIterator.hasNext()) {
                    IndexingOperation updateIndexQueue = updateIndexingOperationsIterator.next();
                    try {
                        bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getUpdateDocumentRequestContent((ElasticIndexingServiceConnector)this.getConnectors().get(updateIndexQueue.getEntityType()), updateIndexQueue.getEntityId());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while *updating* index entry of entity, type = " + entityType + ", id =" + (updateIndexQueue == null ? null : updateIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                    }
                    updateIndexingOperationsIterator.remove();
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.UPDATE);
        }
        if (StringUtils.isNotBlank((String)bulkRequest)) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
        }
    }

    private void processInit(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.INIT)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.INIT).keySet()) {
                this.sendInitRequests(this.getConnectors().get(entityType));
            }
            indexingQueueSorted.remove((Object)OperationType.INIT);
        }
    }

    private void processDeleteAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.DELETE_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).keySet()) {
                if (!indexingQueueSorted.get((Object)OperationType.DELETE_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).get(entityType)) {
                    this.processDeleteAll(indexingOperation, indexingQueueSorted);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.DELETE_ALL);
        }
    }

    private void processDeleteAll(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)this.getConnectors().get(indexingOperation.getEntityType());
        this.auditTrail.audit("delete_all", null, null, connector.getType(), null, null, 0L);
        this.elasticIndexingClient.sendDeleteAllDocsOfTypeRequest(connector.getIndex(), connector.getType());
        this.deleteOperationsForTypesBefore(new OperationType[]{OperationType.CREATE, OperationType.UPDATE, OperationType.DELETE}, indexingQueueSorted, indexingOperation);
    }

    private void processReindexAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.REINDEX_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).keySet()) {
                if (!indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).get(entityType)) {
                    this.reindexAllByEntityType(indexingOperation.getEntityType());
                    this.entityManagerService.getEntityManager().clear();
                }
            }
            indexingQueueSorted.remove((Object)OperationType.REINDEX_ALL);
        }
    }

    @ExoTransactional
    private void reindexAllByEntityType(String entityType) {
        String string = entityType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ElasticIndexingOperationProcessor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void deleteOperationsForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation refIindexOperation) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(refIindexOperation.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(refIindexOperation.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (refIindexOperation.getId() <= indexingOperation.getId()) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (indexQueue.getId() <= indexingOperation.getId() || !indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypes(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (!indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void sendInitRequests(IndexingServiceConnector IndexingServiceConnector2) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)IndexingServiceConnector2;
        this.elasticIndexingClient.sendCreateIndexRequest(connector.getIndex(), this.elasticContentRequestBuilder.getCreateIndexRequestContent(connector));
        this.elasticIndexingClient.sendCreateTypeRequest(connector.getIndex(), connector.getType(), connector.getMapping());
    }

    private String checkBulkRequestSizeReachedLimitation(String bulkRequest) {
        if (bulkRequest.getBytes().length >= this.requestSizeLimit) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
            return "";
        }
        return bulkRequest;
    }

    private void addInitOperation(String connector) {
        IndexingOperation indexingOperation = new IndexingOperation();
        indexingOperation.setEntityType(connector);
        indexingOperation.setOperation(OperationType.INIT);
        this.indexingOperationDAO.create(indexingOperation);
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getRequestSizeLimit() {
        return this.requestSizeLimit;
    }

    public void setRequestSizeLimit(Integer requestSizeLimit) {
        this.requestSizeLimit = requestSizeLimit;
    }

    public int getReindexBatchSize() {
        return this.reindexBatchSize;
    }

    public void setReindexBatchSize(int reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
    }

    public void start() {
        this.initConnectors();
    }

    public void stop() {
    }

    private void initConnectors() {
        for (Map.Entry<String, IndexingServiceConnector> entry : this.getConnectors().entrySet()) {
            this.addInitOperation(entry.getValue().getType());
        }
    }

    static {
        ElasticIndexingOperationProcessor.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ElasticIndexingOperationProcessor.class);
        BATCH_NUMBER_DEFAULT = 1000;
        REQUEST_SIZE_LIMIT_DEFAULT = 0xA00000;
    }

    static /* synthetic */ void reindexAllByEntityType_aroundBody0(ElasticIndexingOperationProcessor ajc$this, String entityType, JoinPoint joinPoint) {
        int numberIndexed;
        long startTime = System.currentTimeMillis();
        ajc$this.indexingOperationDAO.create(new IndexingOperation(null, entityType, OperationType.DELETE_ALL));
        IndexingServiceConnector connector = ajc$this.getConnectors().get(entityType);
        int offset = 0;
        do {
            List<String> ids;
            if ((ids = connector.getAllIds(offset, ajc$this.reindexBatchSize)) == null) {
                numberIndexed = 0;
                continue;
            }
            ArrayList<IndexingOperation> operations = new ArrayList<IndexingOperation>(ids.size());
            for (String id : ids) {
                operations.add(new IndexingOperation(id, entityType, OperationType.CREATE));
            }
            ajc$this.indexingOperationDAO.createAll(operations);
            numberIndexed = ids.size();
            offset += ajc$this.reindexBatchSize;
        } while (numberIndexed == ajc$this.reindexBatchSize);
        ajc$this.auditTrail.audit("reindex_all", null, null, entityType, null, null, System.currentTimeMillis() - startTime);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ElasticIndexingOperationProcessor.java", ElasticIndexingOperationProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reindexAllByEntityType", "org.exoplatform.commons.search.index.impl.ElasticIndexingOperationProcessor", "java.lang.String", "entityType", "", "void"), 372);
    }
}

