/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticIndexingClient;
import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.search.index.impl.ElasticIndexingOperationProcessor$AjcClosure1;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ElasticIndexingOperationProcessor
extends IndexingOperationProcessor
implements Startable {
    private static final Log LOG;
    private static final String BATCH_NUMBER_PROPERTY_NAME = "exo.es.indexing.batch.number";
    private static final Integer BATCH_NUMBER_DEFAULT;
    private static final String REQUEST_SIZE_LIMIT_PROPERTY_NAME = "exo.es.indexing.request.size.limit";
    private static final Integer REQUEST_SIZE_LIMIT_DEFAULT;
    private static final String REINDEXING_BATCH_SIZE_PROPERTY_NAME = "exo.es.reindex.batch.size";
    private static final int REINDEXING_BATCH_SIZE_DEFAULT_VALUE = 100;
    private final IndexingOperationDAO indexingOperationDAO;
    private final ElasticIndexingClient elasticIndexingClient;
    private final ElasticContentRequestBuilder elasticContentRequestBuilder;
    private final ElasticIndexingAuditTrail auditTrail;
    private final EntityManagerService entityManagerService;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private Integer requestSizeLimit = REQUEST_SIZE_LIMIT_DEFAULT;
    private int reindexBatchSize = 100;
    private Map<String, Set<String>> typesOrIndexUpgrading = new HashMap<String, Set<String>>();
    private ExecutorService executors = Executors.newCachedThreadPool();
    private String esVersion;
    private boolean interrupted = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ElasticIndexingOperationProcessor(IndexingOperationDAO indexingOperationDAO, ElasticIndexingClient elasticIndexingClient, ElasticContentRequestBuilder elasticContentRequestBuilder, ElasticIndexingAuditTrail auditTrail, EntityManagerService entityManagerService, DataInitializer dataInitializer, InitParams initParams) {
        this.indexingOperationDAO = indexingOperationDAO;
        this.auditTrail = auditTrail;
        this.entityManagerService = entityManagerService;
        this.elasticIndexingClient = elasticIndexingClient;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME))) {
            this.batchNumber = Integer.valueOf(PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME))) {
            this.requestSizeLimit = Integer.valueOf(PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME))) {
            this.reindexBatchSize = Integer.valueOf(PropertyManager.getProperty((String)REINDEXING_BATCH_SIZE_PROPERTY_NAME));
        }
        if (initParams == null || !initParams.containsKey((Object)"es.version")) {
            throw new IllegalStateException("es.version parameter is mandatory");
        }
        this.esVersion = initParams.getValueParam("es.version").getValue();
        LOG.info("Use ES Version {}", new Object[]{this.esVersion});
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.getConnectors().containsKey(indexingServiceConnector.getType()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getType()});
        } else {
            this.getConnectors().put(indexingServiceConnector.getType(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getType()});
        }
    }

    @Override
    public synchronized void process() {
        this.interrupted = false;
        try {
            int processedOperations;
            while ((processedOperations = this.processBulk()) >= this.batchNumber) {
            }
        }
        finally {
            if (this.interrupted) {
                LOG.info((Object)"Indexing queue processing interruption done");
            }
        }
    }

    @Override
    public void interrupt() {
        LOG.info((Object)"Indexing queue processing has been interrupted. Please wait until the service exists cleanly...");
        this.interrupted = true;
    }

    private boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            LOG.info((Object)"Thread running indexing queue processing has been interrupted. Please wait until the service exists cleanly...");
            this.interrupted = true;
        }
        return this.interrupted;
    }

    private boolean isUpgradeInProgress() {
        return !this.typesOrIndexUpgrading.isEmpty();
    }

    private int processBulk() {
        if (this.isUpgradeInProgress()) {
            LOG.info((Object)"Migration of indexes is in progress, indexation is suspended until migration finishes");
            return 0;
        }
        HashMap<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted = new HashMap<OperationType, Map<String, List<IndexingOperation>>>();
        long maxIndexingOperationId = 0L;
        List<IndexingOperation> indexingOperations = this.indexingOperationDAO.findAllFirst(this.batchNumber);
        for (IndexingOperation indexingOperation : indexingOperations) {
            this.putIndexingOperationInMemoryQueue(indexingOperation, indexingQueueSorted);
            if (maxIndexingOperationId >= indexingOperation.getId()) continue;
            maxIndexingOperationId = indexingOperation.getId();
        }
        this.processInit(indexingQueueSorted);
        this.processDeleteAll(indexingQueueSorted);
        this.processReindexAll(indexingQueueSorted);
        this.processCUD(indexingQueueSorted);
        if (this.isInterrupted()) {
            throw new RuntimeException("Indexing queue processing interrupted");
        }
        this.indexingOperationDAO.deleteAllIndexingOperationsHavingIdLessThanOrEqual(maxIndexingOperationId);
        this.entityManagerService.getEntityManager().clear();
        return indexingOperations.size();
    }

    private void putIndexingOperationInMemoryQueue(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (!indexingQueueSorted.containsKey((Object)indexingOperation.getOperation())) {
            indexingQueueSorted.put(indexingOperation.getOperation(), new HashMap());
        }
        if (!indexingQueueSorted.get((Object)indexingOperation.getOperation()).containsKey(indexingOperation.getEntityType())) {
            indexingQueueSorted.get((Object)indexingOperation.getOperation()).put(indexingOperation.getEntityType(), new ArrayList());
        }
        indexingQueueSorted.get((Object)indexingOperation.getOperation()).get(indexingOperation.getEntityType()).add(indexingOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCUD(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        String singleRequestOperation;
        ElasticIndexingServiceConnector connector;
        String bulkRequest;
        block32: {
            bulkRequest = "";
            if (indexingQueueSorted.containsKey((Object)OperationType.DELETE)) {
                Map<String, List<IndexingOperation>> deleteIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.DELETE);
                for (String entityType : deleteIndexingOperationsMap.keySet()) {
                    connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityType);
                    List<IndexingOperation> deleteIndexingOperationsList = deleteIndexingOperationsMap.get(entityType);
                    if (deleteIndexingOperationsList == null || deleteIndexingOperationsList.isEmpty()) continue;
                    Iterator<IndexingOperation> deleteIndexingOperationsIterator = deleteIndexingOperationsList.iterator();
                    while (deleteIndexingOperationsIterator.hasNext()) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        IndexingOperation deleteIndexQueue = deleteIndexingOperationsIterator.next();
                        try {
                            bulkRequest = bulkRequest + this.elasticContentRequestBuilder.getDeleteDocumentRequestContent(connector, deleteIndexQueue.getEntityId());
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Error while *deleting* index entry of entity, type = " + entityType + ", id =" + (deleteIndexQueue == null ? null : deleteIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                        }
                        finally {
                            indexingQueueSorted.remove((Object)OperationType.DELETE, deleteIndexQueue.getEntityId());
                        }
                        deleteIndexingOperationsIterator.remove();
                        this.deleteOperationsByEntityIdForTypesBefore(new OperationType[]{OperationType.CREATE}, indexingQueueSorted, deleteIndexQueue);
                        this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, deleteIndexQueue);
                        bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                    }
                }
            }
            if (!indexingQueueSorted.containsKey((Object)OperationType.CREATE)) break block32;
            Map<String, List<IndexingOperation>> createIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.CREATE);
            for (String entityType : createIndexingOperationsMap.keySet()) {
                connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityType);
                List<IndexingOperation> createIndexingOperationsList = createIndexingOperationsMap.get(entityType);
                if (createIndexingOperationsList == null || createIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> createIndexingOperationsIterator = createIndexingOperationsList.iterator();
                while (createIndexingOperationsIterator.hasNext()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    IndexingOperation createIndexQueue = createIndexingOperationsIterator.next();
                    try {
                        if (connector.isNeedIngestPipeline()) {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreatePipelineDocumentRequestContent(connector, createIndexQueue.getEntityId());
                            this.elasticIndexingClient.sendCreateDocOnPipeline(connector.getIndex(), connector.getType(), createIndexQueue.getEntityId(), connector.getPipelineName(), singleRequestOperation);
                            indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                            indexingQueueSorted.remove((Object)OperationType.UPDATE, createIndexQueue.getEntityId());
                        } else {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreateDocumentRequestContent(connector, createIndexQueue.getEntityId());
                            bulkRequest = bulkRequest + singleRequestOperation;
                        }
                        createIndexingOperationsIterator.remove();
                    }
                    catch (Exception e) {
                        try {
                            LOG.warn((Object)("Error while *creating* index entry of entity, type = " + entityType + ", id =" + (createIndexQueue == null ? null : createIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                            createIndexingOperationsIterator.remove();
                        }
                        catch (Throwable throwable) {
                            createIndexingOperationsIterator.remove();
                            this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                            indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                            throw throwable;
                        }
                        this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                        indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                    }
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                    indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.UPDATE)) {
            Map<String, List<IndexingOperation>> updateIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.UPDATE);
            for (String entityType : updateIndexingOperationsMap.keySet()) {
                connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityType);
                List<IndexingOperation> updateIndexingOperationsList = updateIndexingOperationsMap.get(entityType);
                if (updateIndexingOperationsList == null || updateIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> updateIndexingOperationsIterator = updateIndexingOperationsList.iterator();
                while (updateIndexingOperationsIterator.hasNext()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    IndexingOperation updateIndexQueue = updateIndexingOperationsIterator.next();
                    try {
                        if (connector.isNeedIngestPipeline()) {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreatePipelineDocumentRequestContent(connector, updateIndexQueue.getEntityId());
                            this.elasticIndexingClient.sendCreateDocOnPipeline(connector.getIndex(), connector.getType(), updateIndexQueue.getEntityId(), connector.getPipelineName(), singleRequestOperation);
                        } else {
                            singleRequestOperation = this.elasticContentRequestBuilder.getUpdateDocumentRequestContent(connector, updateIndexQueue.getEntityId());
                            bulkRequest = bulkRequest + singleRequestOperation;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while *updating* index entry of entity, type = " + entityType + ", id =" + (updateIndexQueue == null ? null : updateIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                    }
                    finally {
                        indexingQueueSorted.remove((Object)OperationType.UPDATE, updateIndexQueue.getEntityId());
                    }
                    updateIndexingOperationsIterator.remove();
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
        }
        if (StringUtils.isNotBlank((String)bulkRequest) && !this.isInterrupted()) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
        }
    }

    private void processInit(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.INIT)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.INIT).keySet()) {
                if (this.isInterrupted()) {
                    return;
                }
                this.sendInitRequests(this.getConnectors().get(entityType));
            }
            indexingQueueSorted.remove((Object)OperationType.INIT);
        }
    }

    private void processDeleteAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.DELETE_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).keySet()) {
                if (this.isInterrupted()) {
                    return;
                }
                if (!indexingQueueSorted.get((Object)OperationType.DELETE_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.DELETE_ALL).get(entityType)) {
                    this.processDeleteAll(indexingOperation, indexingQueueSorted);
                }
            }
            indexingQueueSorted.remove((Object)OperationType.DELETE_ALL);
        }
    }

    private void processDeleteAll(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)this.getConnectors().get(indexingOperation.getEntityType());
        this.auditTrail.audit("delete_all", null, null, connector.getType(), null, null, 0L);
        this.elasticIndexingClient.sendDeleteAllDocsOfTypeRequest(connector.getIndex(), connector.getType());
        this.deleteOperationsForTypesBefore(new OperationType[]{OperationType.CREATE, OperationType.UPDATE, OperationType.DELETE}, indexingQueueSorted, indexingOperation);
    }

    private void processReindexAll(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.REINDEX_ALL)) {
            for (String entityType : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).keySet()) {
                if (!indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).containsKey(entityType)) continue;
                for (IndexingOperation indexingOperation : indexingQueueSorted.get((Object)OperationType.REINDEX_ALL).get(entityType)) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.reindexAllByEntityType(indexingOperation.getEntityType());
                    this.entityManagerService.getEntityManager().clear();
                }
            }
            indexingQueueSorted.remove((Object)OperationType.REINDEX_ALL);
        }
    }

    @ExoTransactional
    private void reindexAllByEntityType(String entityType) {
        String string = entityType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ElasticIndexingOperationProcessor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void deleteOperationsForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation refIindexOperation) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(refIindexOperation.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(refIindexOperation.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (refIindexOperation.getId() <= indexingOperation.getId()) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (indexQueue.getId() <= indexingOperation.getId() || !indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypes(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityType())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityType()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (!indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void sendInitRequests(IndexingServiceConnector IndexingServiceConnector2) {
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)IndexingServiceConnector2;
        String indexAlias = connector.getIndex();
        String previousIndex = connector.getPreviousIndex();
        String index = connector.getCurrentIndex();
        String type = connector.getType();
        if (this.typesOrIndexUpgrading.containsKey(indexAlias) && this.typesOrIndexUpgrading.get(indexAlias).contains(type)) {
            boolean newIndexExists = this.elasticIndexingClient.sendIsIndexExistsRequest(index);
            boolean aliasExistsOnPreviousIndex = this.elasticIndexingClient.sendGetIndexAliasesRequest(previousIndex).contains(indexAlias);
            if (!aliasExistsOnPreviousIndex) {
                boolean aliasExistsOnCurrentIndex = newIndexExists && this.elasticIndexingClient.sendGetIndexAliasesRequest(index).contains(indexAlias);
                this.elasticIndexingClient.sendCreateIndexAliasRequest(previousIndex, aliasExistsOnCurrentIndex ? index : null, indexAlias);
            }
            if (newIndexExists) {
                boolean newTypeExists = this.elasticIndexingClient.sendIsTypeExistsRequest(index, type);
                if (newTypeExists) {
                    LOG.warn("ES index upgrade '{}' was interrupted, the new index/type {}/{} will be recreated", new Object[]{previousIndex, index, type});
                    this.elasticIndexingClient.sendDeleteAllDocsOfTypeRequest(index, type);
                }
                this.elasticIndexingClient.sendCreateTypeRequest(index, connector.getType(), connector.getMapping());
            } else {
                this.elasticIndexingClient.sendCreateIndexRequest(index, this.elasticContentRequestBuilder.getCreateIndexRequestContent(connector));
                this.elasticIndexingClient.sendCreateTypeRequest(index, connector.getType(), connector.getMapping());
                if (connector.isNeedIngestPipeline()) {
                    this.elasticIndexingClient.sendCreateAttachmentPipelineRequest(index, connector.getType(), connector.getPipelineName(), connector.getAttachmentProcessor());
                }
            }
            this.executors.submit(new ReindexESType(ExoContainerContext.getCurrentContainer(), connector));
        } else {
            boolean newlyCreated;
            boolean useAlias = true;
            if (index == null) {
                index = indexAlias;
                useAlias = false;
            }
            if ((newlyCreated = this.elasticIndexingClient.sendCreateIndexRequest(index, this.elasticContentRequestBuilder.getCreateIndexRequestContent(connector))) && useAlias) {
                this.elasticIndexingClient.sendCreateIndexAliasRequest(index, null, indexAlias);
            }
            this.elasticIndexingClient.sendCreateTypeRequest(index, connector.getType(), connector.getMapping());
            if (connector.isNeedIngestPipeline()) {
                this.elasticIndexingClient.sendCreateAttachmentPipelineRequest(index, connector.getType(), connector.getPipelineName(), connector.getAttachmentProcessor());
            }
        }
        connector.setPreviousIndex(null);
    }

    private String checkBulkRequestSizeReachedLimitation(String bulkRequest) {
        if (bulkRequest.getBytes().length >= this.requestSizeLimit) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest);
            return "";
        }
        return bulkRequest;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getRequestSizeLimit() {
        return this.requestSizeLimit;
    }

    public void setRequestSizeLimit(Integer requestSizeLimit) {
        this.requestSizeLimit = requestSizeLimit;
    }

    public int getReindexBatchSize() {
        return this.reindexBatchSize;
    }

    public void setReindexBatchSize(int reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
    }

    public void start() {
        String esVersion = this.elasticIndexingClient.sendGetESVersion();
        if (esVersion == null || !esVersion.startsWith(this.esVersion + ".")) {
            LOG.error((Object)("Expected Version of ES version is " + this.esVersion + " but was " + esVersion + ". If this is a compatible version, you can configure 'exo.es.version.minor' to delete this error message."));
        }
        this.initConnectors();
    }

    public void stop() {
        this.executors.shutdownNow();
    }

    private void initConnectors() {
        for (Map.Entry<String, IndexingServiceConnector> entry : this.getConnectors().entrySet()) {
            ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)entry.getValue();
            String previousIndex = connector.getPreviousIndex();
            String index = connector.getCurrentIndex();
            String indexAlias = connector.getIndex();
            boolean needsUpgrade = false;
            if (previousIndex != null) {
                boolean bl = needsUpgrade = this.elasticIndexingClient.sendIsIndexExistsRequest(previousIndex) && (!this.elasticIndexingClient.sendIsIndexExistsRequest(index) || !this.elasticIndexingClient.sendGetIndexAliasesRequest(index).contains(indexAlias));
            }
            if (!needsUpgrade) continue;
            if (!this.typesOrIndexUpgrading.containsKey(indexAlias)) {
                this.typesOrIndexUpgrading.put(indexAlias, new HashSet());
            }
            this.typesOrIndexUpgrading.get(indexAlias).add(entry.getKey());
        }
        for (Map.Entry<String, IndexingServiceConnector> entry : this.getConnectors().entrySet()) {
            this.sendInitRequests(entry.getValue());
        }
    }

    static {
        ElasticIndexingOperationProcessor.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ElasticIndexingOperationProcessor.class);
        BATCH_NUMBER_DEFAULT = 1000;
        REQUEST_SIZE_LIMIT_DEFAULT = 0xA00000;
    }

    static /* synthetic */ void reindexAllByEntityType_aroundBody0(ElasticIndexingOperationProcessor ajc$this, String entityType, JoinPoint joinPoint) {
        int numberIndexed;
        long startTime = System.currentTimeMillis();
        ajc$this.indexingOperationDAO.create(new IndexingOperation(null, entityType, OperationType.DELETE_ALL));
        IndexingServiceConnector connector = ajc$this.getConnectors().get(entityType);
        int offset = 0;
        do {
            if (ajc$this.isInterrupted()) {
                return;
            }
            List<String> ids = connector.getAllIds(offset, ajc$this.reindexBatchSize);
            if (ids == null) {
                numberIndexed = 0;
                continue;
            }
            ArrayList<IndexingOperation> operations = new ArrayList<IndexingOperation>(ids.size());
            for (String id : ids) {
                operations.add(new IndexingOperation(id, entityType, OperationType.CREATE));
            }
            ajc$this.indexingOperationDAO.createAll(operations);
            numberIndexed = ids.size();
            offset += ajc$this.reindexBatchSize;
        } while (numberIndexed == ajc$this.reindexBatchSize);
        ajc$this.auditTrail.audit("reindex_all", null, null, entityType, null, null, System.currentTimeMillis() - startTime);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ElasticIndexingOperationProcessor.java", ElasticIndexingOperationProcessor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reindexAllByEntityType", "org.exoplatform.commons.search.index.impl.ElasticIndexingOperationProcessor", "java.lang.String", "entityType", "", "void"), 490);
    }

    public class ReindexESType
    implements Runnable {
        private String index;
        private String previousIndex;
        private String indexAlias;
        private String type;
        private String pipeline;
        private boolean reindexFromDB;
        private ExoContainer exoContainer;

        public ReindexESType(ExoContainer exoContainer, ElasticIndexingServiceConnector connector) {
            this.exoContainer = exoContainer;
            this.index = connector.getCurrentIndex();
            this.previousIndex = connector.getPreviousIndex();
            this.indexAlias = connector.getIndex();
            this.type = connector.getType();
            this.pipeline = connector.getPipelineName();
            this.reindexFromDB = connector.isReindexOnUpgrade();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.reindexFromDB) {
                    ExoContainerContext.setCurrentContainer((ExoContainer)this.exoContainer);
                    ElasticIndexingOperationProcessor.this.reindexAllByEntityType(this.type);
                } else {
                    LOG.info("Reindexing index alias {} from old index {} to new index {}, for type {}", new Object[]{this.indexAlias, this.previousIndex, this.index, this.type});
                    ElasticIndexingOperationProcessor.this.elasticIndexingClient.sendReindexTypeRequest(this.index, this.previousIndex, this.type, this.pipeline);
                    LOG.info("Reindexation finished for index alias {} from old index {} to new index {}, for type {}", new Object[]{this.indexAlias, this.previousIndex, this.index, this.type});
                }
                Map map = ElasticIndexingOperationProcessor.this.typesOrIndexUpgrading;
                synchronized (map) {
                    boolean indexMigrationInProgress;
                    boolean bl = indexMigrationInProgress = ((Set)ElasticIndexingOperationProcessor.this.typesOrIndexUpgrading.get(this.indexAlias)).size() > 1;
                    if (indexMigrationInProgress) {
                        LOG.info("The index {} has some types not completely migrated yet, the old index will be deleted after migration is finished", new Object[]{this.previousIndex});
                        ((Set)ElasticIndexingOperationProcessor.this.typesOrIndexUpgrading.get(this.indexAlias)).remove(this.type);
                    } else {
                        LOG.info("Switching index alias {} from old index {} to new index {}", new Object[]{this.indexAlias, this.previousIndex, this.index});
                        ElasticIndexingOperationProcessor.this.elasticIndexingClient.sendCreateIndexAliasRequest(this.index, this.previousIndex, this.indexAlias);
                        ElasticIndexingOperationProcessor.this.typesOrIndexUpgrading.remove(this.indexAlias);
                        LOG.info("Remove old index {}", new Object[]{this.previousIndex});
                        ElasticIndexingOperationProcessor.this.elasticIndexingClient.sendDeleteIndexRequest(this.previousIndex);
                        if (ElasticIndexingOperationProcessor.this.typesOrIndexUpgrading.isEmpty()) {
                            LOG.info((Object)"ES indexes migration finished (except indexes that will be reindexed from DB)");
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred while upgrading index " + this.previousIndex + " type " + this.type), (Throwable)e);
            }
        }
    }
}

