/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.json.simple.JSONObject;

public abstract class ElasticIndexingServiceConnector
extends IndexingServiceConnector {
    private static final Integer REPLICAS_NUMBER_DEFAULT = 0;
    private static final String REPLICAS_NUMBER_PROPERTY_NAME = "exo.es.indexing.replica.number.default";
    private static final Integer SHARDS_NUMBER_DEFAULT = 5;
    private static final String SHARDS_PROPERTY_NAME = "exo.es.indexing.shard.number.default";
    protected String indexAlias;
    protected String currentIndex;
    protected String previousIndex;
    protected boolean reindexOnUpgrade;
    protected Integer shards = SHARDS_NUMBER_DEFAULT;
    protected Integer replicas = REPLICAS_NUMBER_DEFAULT;

    public ElasticIndexingServiceConnector(InitParams initParams) {
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        String reindexOnUpgradeString = param.getProperty("reindexOnUpgrade");
        this.reindexOnUpgrade = StringUtils.isNotBlank((String)reindexOnUpgradeString) && reindexOnUpgradeString.trim().equalsIgnoreCase("true");
        this.indexAlias = param.getProperty("index_alias");
        this.currentIndex = param.getProperty("index_current");
        this.previousIndex = param.getProperty("index_previous");
        this.setType(param.getProperty("type"));
        if (StringUtils.isNotBlank((String)param.getProperty("replica.number"))) {
            this.replicas = Integer.valueOf(param.getProperty("replica.number"));
        } else if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REPLICAS_NUMBER_PROPERTY_NAME))) {
            this.replicas = Integer.valueOf(PropertyManager.getProperty((String)REPLICAS_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)param.getProperty("shard.number"))) {
            this.shards = Integer.valueOf(param.getProperty("shard.number"));
        } else if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)SHARDS_PROPERTY_NAME))) {
            this.shards = Integer.valueOf(PropertyManager.getProperty((String)SHARDS_PROPERTY_NAME));
        }
    }

    public String getMapping() {
        JSONObject notAnalyzedField = new JSONObject();
        notAnalyzedField.put((Object)"type", (Object)"text");
        notAnalyzedField.put((Object)"index", (Object)false);
        JSONObject keywordMapping = new JSONObject();
        keywordMapping.put((Object)"type", (Object)"keyword");
        JSONObject properties = new JSONObject();
        properties.put((Object)"permissions", (Object)keywordMapping);
        properties.put((Object)"sites", (Object)keywordMapping);
        properties.put((Object)"url", (Object)notAnalyzedField);
        JSONObject mappingProperties = new JSONObject();
        mappingProperties.put((Object)"properties", (Object)properties);
        JSONObject mappingJSON = new JSONObject();
        mappingJSON.put((Object)this.getType(), (Object)mappingProperties);
        return mappingJSON.toJSONString();
    }

    public String getIndex() {
        return this.indexAlias;
    }

    public void setIndex(String index) {
        this.indexAlias = index;
    }

    public String getCurrentIndex() {
        return this.currentIndex;
    }

    public String getPreviousIndex() {
        return this.previousIndex;
    }

    public void setPreviousIndex(String previousIndex) {
        this.previousIndex = previousIndex;
    }

    public boolean isReindexOnUpgrade() {
        return this.reindexOnUpgrade;
    }

    public Integer getShards() {
        return this.shards;
    }

    public void setShards(Integer shards) {
        this.shards = shards;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @Override
    public String delete(String id) {
        return id;
    }

    public boolean isNeedIngestPipeline() {
        return false;
    }

    public String getPipelineName() {
        return null;
    }

    public String getAttachmentProcessor() {
        return null;
    }
}

