/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.domain;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Document {
    private String type;
    private String id;
    private String url;
    private Date lastUpdatedDate;
    private Set<String> permissions;
    private Map<String, String> fields;
    private String[] sites;

    public Document() {
    }

    @Deprecated
    public Document(String type, String id, String url, Date lastUpdatedDate, String[] permissions, Map<String, String> fields) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.lastUpdatedDate = lastUpdatedDate;
        this.permissions = new HashSet<String>(Arrays.asList(permissions));
        this.fields = fields;
        this.sites = null;
    }

    @Deprecated
    public Document(String type, String id, String url, Date lastUpdatedDate, String[] permissions, Map<String, String> fields, String[] sites) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.lastUpdatedDate = lastUpdatedDate;
        this.permissions = new HashSet<String>(Arrays.asList(permissions));
        this.fields = fields;
        this.sites = sites;
    }

    public Document(String type, String id, String url, Date lastUpdatedDate, Set<String> permissions, Map<String, String> fields) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.lastUpdatedDate = lastUpdatedDate;
        this.permissions = permissions;
        this.fields = fields;
        this.sites = null;
    }

    public Document(String type, String id, String url, Date lastUpdatedDate, Set<String> permissions, Map<String, String> fields, String[] sites) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.lastUpdatedDate = lastUpdatedDate;
        this.permissions = permissions;
        this.fields = fields;
        this.sites = sites;
    }

    public Document(String type, String id, Date lastUpdatedDate) {
        this.type = type;
        this.id = id;
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public void setPermissions(String[] permissions) {
        this.permissions = new HashSet<String>(Arrays.asList(permissions));
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public String[] getSites() {
        return this.sites;
    }

    public void setSites(String[] sites) {
        this.sites = sites;
    }

    public String toJSON() {
        JSONObject obj = new JSONObject();
        if (this.getPermissions() != null) {
            JSONArray permissionsJSON = new JSONArray();
            permissionsJSON.addAll(this.getPermissions());
            obj.put((Object)"permissions", (Object)permissionsJSON);
        }
        if (this.getSites() != null) {
            JSONArray sitesJSON = new JSONArray();
            sitesJSON.addAll(Arrays.asList(this.getSites()));
            obj.put((Object)"sites", (Object)sitesJSON);
        }
        if (this.getUrl() != null) {
            obj.put((Object)"url", (Object)this.getUrl());
        }
        if (this.getLastUpdatedDate() != null) {
            obj.put((Object)"lastUpdatedDate", (Object)this.getLastUpdatedDate().getTime());
        }
        if (this.getFields() != null) {
            for (String fieldName : this.getFields().keySet()) {
                obj.put((Object)fieldName, (Object)this.getFields().get(fieldName));
            }
        }
        String json = obj.toJSONString();
        return json;
    }

    public Document addField(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key is null");
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, String>();
        }
        this.fields.put(key, value);
        return this;
    }

    public Document addField(String key, byte[] value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key is null");
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, String>();
        }
        this.fields.put(key, new String(Base64.encodeBase64((byte[])value)));
        return this;
    }
}

