/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.search.index.impl.QueueIndexingService;
import org.exoplatform.commons.search.rest.resource.CollectionResource;
import org.exoplatform.commons.search.rest.resource.CollectionSizeResource;
import org.exoplatform.commons.search.rest.resource.ConnectorResource;
import org.exoplatform.commons.search.rest.resource.OperationResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

@Path(value="/v1/indexingManagement")
@RolesAllowed(value={"administrators"})
@Api(value="/v1/indexingManagement", description="Entry point for Indexing Management resources", basePath="/v1/indexingManagement")
public class IndexingManagementRestServiceV1
implements ResourceContainer {
    public static final String BASE_VERSION_URI = "/v1";
    public static final String INDEXING_MANAGEMENT_URI = "/indexingManagement";
    public static final String CONNECTORS_URI = "/connectors";
    public static final String OPERATIONS_URI = "/operations";
    public static final String ERRORS_URI = "/errors";
    private static final Log LOG = ExoLogger.getLogger(IndexingManagementRestServiceV1.class);
    private QueueIndexingService indexingService;
    private IndexingOperationProcessor indexingOperationProcessor;

    public IndexingManagementRestServiceV1(IndexingService indexingService, IndexingOperationProcessor indexingOperationProcessor) {
        this.indexingService = (QueueIndexingService)indexingService;
        this.indexingOperationProcessor = indexingOperationProcessor;
    }

    @GET
    @Path(value="/connectors")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Return all Indexing Connectors")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all Indexing Connectors"), @ApiResponse(code=500, message="Can't generate JSON file")})
    public Response getConnectors(@ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="Tell the service if it must return the size of the collection in the store", required=false) @QueryParam(value="returnSize") boolean returnSize) {
        Response.ResponseBuilder response;
        CollectionResource<IndexingServiceConnector> connectorData;
        ArrayList<IndexingServiceConnector> connectors = new ArrayList<IndexingServiceConnector>(this.indexingOperationProcessor.getConnectors().values());
        if (returnSize) {
            int connectorNb = this.indexingOperationProcessor.getConnectors().size();
            connectorData = new CollectionSizeResource<IndexingServiceConnector>(connectors, connectorNb);
        } else {
            connectorData = new CollectionResource<IndexingServiceConnector>(connectors);
        }
        if (StringUtils.isNotBlank((String)jsonp)) {
            try {
                response = this.buildJsonCallBack(connectorData, jsonp);
            }
            catch (JsonException e) {
                LOG.error((Object)e);
                response = Response.status((int)500);
            }
        } else {
            response = Response.ok(connectorData, (String)"application/json");
        }
        return response.build();
    }

    @GET
    @Path(value="/connectors/{connectorType}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Return the Indexing Connectors with the specified Connector Type")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the Indexing Connector"), @ApiResponse(code=404, message="Indexing Connector with specified type Not Found"), @ApiResponse(code=500, message="Can't generate JSON file")})
    public Response getConnector(@ApiParam(value="Type of the Indexing Connector to retrieve", required=true) @PathParam(value="connectorType") String connectorType, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp) {
        Response.ResponseBuilder response;
        IndexingServiceConnector connector = this.indexingOperationProcessor.getConnectors().get(connectorType);
        if (connector == null) {
            return Response.status((int)404).build();
        }
        if (StringUtils.isNotBlank((String)jsonp)) {
            try {
                response = this.buildJsonCallBack(connector, jsonp);
            }
            catch (JsonException e) {
                LOG.error((Object)e);
                response = Response.status((int)500);
            }
        } else {
            response = Response.ok((Object)connector, (String)"application/json");
        }
        return response.build();
    }

    @PUT
    @Path(value="/connectors/{connectorType}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Update an Indexing Connector to enable / disable it")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful update of the Indexing Connector"), @ApiResponse(code=404, message="Indexing Connector with specified type Not Found")})
    public Response updateConnector(@ApiParam(value="Type of the Indexing Connector to update", required=true) @PathParam(value="connectorType") String connectorType, @ApiParam(value="An Indexing Connector Resource", required=true) ConnectorResource connectorResource) {
        if (this.indexingOperationProcessor.getConnectors().get(connectorType) == null) {
            return Response.status((int)404).build();
        }
        this.indexingOperationProcessor.getConnectors().get(connectorType).setEnable(connectorResource.isEnable());
        return Response.ok().build();
    }

    @GET
    @Path(value="/operations")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Return all Indexing Operations")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all Indexing Operations"), @ApiResponse(code=500, message="Can't generate JSON file")})
    public Response getOperations(@ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp, @ApiParam(value="The starting point when paging through a list of entities", required=false) @QueryParam(value="offset") int offset, @ApiParam(value="The maximum number of results when paging through a list of entities. If not specified or exceed the *query_limit* configuration of Indexing Management rest service, it will use the *query_limit*", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Tell the service if it must return the size of the collection in the store", required=false) @QueryParam(value="returnSize") boolean returnSize) {
        Response.ResponseBuilder response;
        CollectionResource<IndexingOperation> operationData;
        offset = this.parseOffset(offset);
        limit = this.parseLimit(limit);
        ArrayList<IndexingOperation> operations = new ArrayList<IndexingOperation>(this.indexingService.getOperations(offset, limit));
        if (returnSize) {
            int operationNb = this.indexingService.getNumberOperations().intValue();
            operationData = new CollectionSizeResource<IndexingOperation>(operations, operationNb);
        } else {
            operationData = new CollectionResource<IndexingOperation>(operations);
        }
        operationData.setLimit(limit);
        operationData.setOffset(offset);
        if (StringUtils.isNotBlank((String)jsonp)) {
            try {
                response = this.buildJsonCallBack(operationData, jsonp);
            }
            catch (JsonException e) {
                LOG.error((Object)e);
                response = Response.status((int)500);
            }
        } else {
            response = Response.ok(operationData, (String)"application/json");
        }
        return response.build();
    }

    @POST
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Add an Indexing Operation to the queue")
    @ApiResponses(value={@ApiResponse(code=201, message="Indexing Operation successfully added"), @ApiResponse(code=400, message="The specified Indexing Operation is unknown")})
    public Response addOperation(@ApiParam(value="An Indexing Operation Resource", required=true) OperationResource operationResource) {
        switch (operationResource.getOperation()) {
            case "init": {
                this.indexingService.init(operationResource.getEntityType());
                break;
            }
            case "index": {
                this.indexingService.index(operationResource.getEntityType(), operationResource.getEntityId());
                break;
            }
            case "reindex": {
                this.indexingService.reindex(operationResource.getEntityType(), operationResource.getEntityId());
                break;
            }
            case "unindex": {
                this.indexingService.unindex(operationResource.getEntityType(), operationResource.getEntityId());
                break;
            }
            case "reindexAll": {
                this.indexingService.reindexAll(operationResource.getEntityType());
                break;
            }
            case "unindexAll": {
                this.indexingService.unindexAll(operationResource.getEntityType());
                break;
            }
            default: {
                return this.getBadRequestResponse().build();
            }
        }
        return Response.status((int)201).build();
    }

    @DELETE
    @Path(value="/operations")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Delete all Indexing Operation")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful deletion of all Indexing Operations")})
    public Response deleteOperations() {
        this.indexingService.deleteAllOperations();
        return Response.ok().build();
    }

    @GET
    @Path(value="/operations/{operationId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Return the Indexing Operation with the specified Opertion Id")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of the Indexing Operation"), @ApiResponse(code=404, message="Indexing Operation with specified Id Not Found"), @ApiResponse(code=500, message="Can't generate JSON file")})
    public Response getOperation(@ApiParam(value="Id of the Indexing Operation to retrieve", required=true) @PathParam(value="operationId") String operationId, @ApiParam(value="The name of a JavaScript function to be used as the JSONP callback", required=false) @QueryParam(value="jsonp") String jsonp) {
        Response.ResponseBuilder response;
        IndexingOperation operation = this.indexingService.getOperation(operationId);
        if (operation == null) {
            return Response.status((int)404).build();
        }
        if (StringUtils.isNotBlank((String)jsonp)) {
            try {
                response = this.buildJsonCallBack(operation, jsonp);
            }
            catch (JsonException e) {
                LOG.error((Object)e);
                response = Response.status((int)500);
            }
        } else {
            response = Response.ok((Object)operation, (String)"application/json");
        }
        return response.build();
    }

    @DELETE
    @Path(value="/operations/{operationId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Delete a specified Indexing Operation")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful deletion of the Indexing Operations"), @ApiResponse(code=404, message="Indexing Operation with specified Id Not Found")})
    public Response DeleteOperation(@ApiParam(value="Id of the Indexing Operation to delete", required=true) @PathParam(value="operationId") String operationId) {
        IndexingOperation operation = this.indexingService.getOperation(operationId);
        if (operation == null) {
            return Response.status((int)404).build();
        }
        this.indexingService.deleteOperation(operation);
        return Response.ok().build();
    }

    private Response.ResponseBuilder buildJsonCallBack(Serializable resource, String jsonp) throws JsonException {
        JsonValue value = new JsonGeneratorImpl().createJsonObject((Object)resource);
        StringBuilder sb = new StringBuilder(jsonp);
        sb.append("(").append(value).append(");");
        return Response.ok((Object)sb.toString(), (MediaType)new MediaType("text", "javascript"));
    }

    private int parseLimit(int limit) {
        return limit <= 0 || limit > 100 ? 100 : limit;
    }

    private int parseOffset(int offset) {
        return offset <= 0 ? 0 : offset;
    }

    private Response.ResponseBuilder getBadRequestResponse() {
        Calendar today = Calendar.getInstance();
        if (today.get(5) == 1 && today.get(2) == 3) {
            return Response.status((int)418);
        }
        return Response.status((int)400);
    }
}

