/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.index.IndexingService;

public class QueueIndexingService
implements IndexingService {
    private final IndexingOperationDAO indexingOperationDAO;

    public QueueIndexingService(IndexingOperationDAO indexingOperationDAO) {
        this.indexingOperationDAO = indexingOperationDAO;
    }

    @Override
    public void init(String connectorName) {
        this.addToIndexingQueue(connectorName, null, OperationType.INIT);
    }

    @Override
    public void index(String connectorName, String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        this.addToIndexingQueue(connectorName, id, OperationType.CREATE);
    }

    @Override
    public void reindex(String connectorName, String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        this.addToIndexingQueue(connectorName, id, OperationType.UPDATE);
    }

    @Override
    public void unindex(String connectorName, String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        this.addToIndexingQueue(connectorName, id, OperationType.DELETE);
    }

    private void addToIndexingQueue(String connectorName, String entityId, OperationType operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        switch (operation) {
            case INIT: {
                this.indexingOperationDAO.create(this.getIndexingOperation(connectorName, OperationType.INIT, entityId));
                break;
            }
            case CREATE: {
                this.indexingOperationDAO.create(this.getIndexingOperation(connectorName, OperationType.CREATE, entityId));
                break;
            }
            case UPDATE: {
                this.indexingOperationDAO.create(this.getIndexingOperation(connectorName, OperationType.UPDATE, entityId));
                break;
            }
            case DELETE: {
                this.indexingOperationDAO.create(this.getIndexingOperation(connectorName, OperationType.DELETE, entityId));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)operation) + " is not an accepted operation for the Indexing Queue");
            }
        }
    }

    private IndexingOperation getIndexingOperation(String connector, OperationType operation, String entityId) {
        IndexingOperation indexingOperation = new IndexingOperation();
        indexingOperation.setEntityIndex(connector);
        indexingOperation.setOperation(operation);
        if (entityId != null) {
            indexingOperation.setEntityId(entityId);
        }
        return indexingOperation;
    }

    public void clearIndexingQueue() {
        this.indexingOperationDAO.deleteAll();
    }

    public long getNumberOperations() {
        return this.indexingOperationDAO.count();
    }

    public List<IndexingOperation> getOperations(int offset, int limit) {
        return this.indexingOperationDAO.findAll(offset, limit);
    }

    public IndexingOperation getOperation(String operationId) {
        return (IndexingOperation)this.indexingOperationDAO.find(Long.getLong(operationId));
    }

    public void deleteAllOperations() {
        this.indexingOperationDAO.deleteAll();
    }

    public void deleteOperation(IndexingOperation indexingOperation) {
        this.indexingOperationDAO.delete(indexingOperation);
    }
}

