/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ContainerBuilder {
    private static final Log LOG = ExoLogger.getLogger(ContainerBuilder.class);
    private final ThreadLocal<String> bootedPortalName = new ThreadLocal();
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private List<URL> rootConfigURLs = new ArrayList<URL>();
    private LinkedHashMap<String, List<URL>> portalConfigURLs = new LinkedHashMap();

    public ContainerBuilder withRoot(String configPath) {
        this.rootConfigURLs.addAll(this.urls(configPath));
        return this;
    }

    public ContainerBuilder withRoot(URL configURL) {
        this.rootConfigURLs.add(configURL);
        return this;
    }

    public ContainerBuilder withPortal(String configPath) {
        return this.withPortal("portal", configPath);
    }

    public ContainerBuilder withPortal(String portalName, String configPath) {
        for (URL configURL : this.urls(configPath)) {
            this.withPortal(portalName, configURL);
        }
        return this;
    }

    public ContainerBuilder withPortal(URL configURL) {
        return this.withPortal("portal", configURL);
    }

    public ContainerBuilder withPortal(String portalName, URL configURL) {
        List<URL> urls = this.portalConfigURLs.get(portalName);
        if (urls == null) {
            urls = new ArrayList<URL>();
            this.portalConfigURLs.put(portalName, urls);
        }
        urls.add(configURL);
        return this;
    }

    public ContainerBuilder withLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    private List<URL> urls(String path) {
        try {
            return Collections.list(this.loader.getResources(path));
        }
        catch (IOException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
    }

    public RootContainer build() {
        try {
            return this._build();
        }
        catch (SecurityException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
        catch (IllegalArgumentException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
        catch (NoSuchFieldException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
        catch (IllegalAccessException e) {
            AssertionFailedError err = new AssertionFailedError();
            err.initCause((Throwable)e);
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootContainer _build() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        RootContainer root;
        if (this.rootConfigURLs.size() == 0) {
            throw new IllegalStateException("Must provide at least one URL for building the root container");
        }
        Field topContainerField = ExoContainerContext.class.getDeclaredField("topContainer");
        topContainerField.setAccessible(true);
        topContainerField.set(null, null);
        Field singletonField = RootContainer.class.getDeclaredField("singleton_");
        singletonField.setAccessible(true);
        singletonField.set(null, null);
        RootContainer.setInstance(null);
        if (ExoContainerContext.getCurrentContainerIfPresent() != null) {
            PortalContainer.setInstance(null);
        }
        ClassLoader rootCL = new ClassLoader(this.loader){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration<URL> resources;
                if ("conf/configuration.xml".equals(name)) {
                    resources = Collections.enumeration(ContainerBuilder.this.rootConfigURLs);
                } else if ("conf/portal/configuration.xml".equals(name)) {
                    String portalName = ContainerBuilder.this.bootedPortalName.get();
                    resources = Collections.enumeration((Collection)ContainerBuilder.this.portalConfigURLs.get(portalName));
                } else {
                    resources = "conf/portal/test-configuration.xml".equals(name) ? new Vector().elements() : super.getResources(name);
                }
                if (resources != null && resources.hasMoreElements()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Loaded " + name));
                    }
                } else if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No resource found " + name));
                }
                return resources;
            }
        };
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(rootCL);
            root = RootContainer.getInstance();
            for (String portalName : this.portalConfigURLs.keySet()) {
                try {
                    this.bootedPortalName.set(portalName);
                    root.getPortalContainer(portalName);
                }
                finally {
                    this.bootedPortalName.set(null);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return root;
    }

    public static RootContainer bootstrap(URL configurationURL, String ... profiles) {
        ContainerBuilder builder = new ContainerBuilder();
        builder.withRoot(configurationURL);
        return builder.build();
    }
}

