/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.bench;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.bench.LoremIpsum4J;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataInjector
extends BaseComponentPlugin {
    private List<String> users = Arrays.asList("root", "demo", "mary", "john");
    private Random rand = new Random();
    private LoremIpsum4J textGen = new LoremIpsum4J();
    public static final String ARRAY_SPLIT = ",";
    private String restId;

    public String getRestId() {
        return this.restId;
    }

    public void setRestId(String restId) {
        this.restId = restId;
    }

    public abstract Log getLog();

    public abstract Object execute(HashMap<String, String> var1) throws Exception;

    public abstract void inject(HashMap<String, String> var1) throws Exception;

    public abstract void reject(HashMap<String, String> var1) throws Exception;

    public final String words(int amount) {
        return this.textGen.getWords(amount);
    }

    public final String paragraphs(int amount) {
        return this.textGen.getParagraphs(amount);
    }

    public final String randomUser() {
        return this.users.get(this.rand.nextInt(4));
    }

    public final String randomWords(int i) {
        int wordCount = this.rand.nextInt(i + 1) + 1;
        String words = this.textGen.getWords(wordCount);
        return words;
    }

    public final String randomParagraphs(int i) {
        int paragraphCount = this.rand.nextInt(i + 1) + 1;
        String paragraphs = this.textGen.getParagraphs(paragraphCount);
        return paragraphs.replaceAll("\\n\\n", "<br/><br/>");
    }

    public String createTextResource(int size) {
        int sizeInByte = size * 1024;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sizeInByte; ++i) {
            sb.append("A");
        }
        return sb.toString();
    }

    public List<String> readGroupsIfExist(HashMap<String, String> queryParams) {
        LinkedList<String> groups = new LinkedList<String>();
        String value = queryParams.get("groups");
        if (value != null) {
            String[] groupsString;
            for (String s : groupsString = value.split(ARRAY_SPLIT)) {
                if (s.length() <= 0) continue;
                groups.add(s.trim());
            }
        }
        return groups;
    }

    public List<String> readUsersIfExist(HashMap<String, String> queryParams) {
        LinkedList<String> users = new LinkedList<String>();
        String value = queryParams.get("users");
        if (value != null) {
            String[] groupsString;
            for (String s : groupsString = value.split(ARRAY_SPLIT)) {
                if (s.length() <= 0) continue;
                users.add(s.trim());
            }
        }
        return users;
    }

    public List<String> readMembershipIfExist(HashMap<String, String> queryParams) {
        LinkedList<String> memberships = new LinkedList<String>();
        String value = queryParams.get("memship");
        if (value != null) {
            String[] memshipsString;
            for (String s : memshipsString = value.split(ARRAY_SPLIT)) {
                if (s.length() <= 0) continue;
                memberships.add(s.trim());
            }
        }
        return memberships;
    }
}

