/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.bench;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/bench")
public class DataInjectorService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(DataInjectorService.class);
    private static CacheControl cc = new CacheControl();
    private List<DataInjector> listOfInjectors = new LinkedList<DataInjector>();

    private HashMap<String, String> convertToHashMap(MultivaluedMap<String, String> paramsMap) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry entry : paramsMap.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            String value = values.size() > 0 ? (String)values.get(0) : null;
            parameters.put(key, value);
        }
        return parameters;
    }

    private DataInjector getDataInjector(String injectorId) {
        for (DataInjector di : this.listOfInjectors) {
            if (!injectorId.equals(di.getName())) continue;
            return di;
        }
        return null;
    }

    public void addInjector(DataInjector dataInjector) {
        this.listOfInjectors.add(dataInjector);
    }

    @GET
    @Path(value="/execute/{injectorId}")
    @RolesAllowed(value={"administrators"})
    public Response execute(@PathParam(value="injectorId") String type, @Context UriInfo info) {
        DataInjector injector = this.getDataInjector(type);
        if (injector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Injector id is incorrect!").cacheControl(cc).build();
        }
        HashMap<String, String> params = this.convertToHashMap((MultivaluedMap<String, String>)info.getQueryParameters());
        try {
            this.beginPrintInfo(params, Actions.EXECUTE);
            Object response = injector.execute(params);
            return Response.ok((Object)response, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            this.errorPrintInfo(injector, Actions.EXECUTE, e);
            return Response.serverError().entity((Object)String.format("%1$s executed failed due to %2$s", injector.getName(), e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/inject/{injectorId}")
    @RolesAllowed(value={"administrators"})
    public Response inject(@PathParam(value="injectorId") String type, @Context UriInfo info) {
        DataInjector injector = this.getDataInjector(type);
        if (injector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Injector id is incorrect!").cacheControl(cc).build();
        }
        HashMap<String, String> params = this.convertToHashMap((MultivaluedMap<String, String>)info.getQueryParameters());
        try {
            this.beginPrintInfo(params, Actions.INJECT);
            injector.inject(params);
        }
        catch (Exception e) {
            this.errorPrintInfo(injector, Actions.INJECT, e);
            return Response.serverError().entity((Object)String.format("%1$s injected failed due to %2$s", injector.getName(), e.getMessage())).build();
        }
        this.endPrintInfo(Actions.INJECT);
        return Response.ok((Object)String.format("%s injected successfully!!!", injector.getName()), (String)"text/plain").cacheControl(cc).build();
    }

    @GET
    @Path(value="/reject/{injectorId}")
    @RolesAllowed(value={"administrators"})
    public Response reject(@PathParam(value="injectorId") String type, @Context UriInfo info) {
        DataInjector injector = this.getDataInjector(type);
        if (injector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Injector id is incorrect").cacheControl(cc).build();
        }
        HashMap<String, String> params = this.convertToHashMap((MultivaluedMap<String, String>)info.getQueryParameters());
        try {
            this.beginPrintInfo(params, Actions.REJECT);
            injector.reject(params);
        }
        catch (Exception e) {
            this.errorPrintInfo(injector, Actions.REJECT, e);
            return Response.serverError().entity((Object)String.format("%1$s rejected failed due to %2$s", injector.getName(), e.getMessage())).build();
        }
        this.endPrintInfo(Actions.REJECT);
        return Response.ok((Object)String.format("%s rejected successfully!!!", injector.getName()), (String)"text/plain").cacheControl(cc).build();
    }

    private void beginPrintInfo(HashMap<String, String> params, Actions action) {
        log.info((Object)String.format("Start to %s............... ", action.toString().toLowerCase()));
        StringBuilder sb = new StringBuilder();
        sb.append("PARAMS: \n");
        for (String key : params.keySet()) {
            sb.append(String.format("%1$10s    :    %2$10s \n", key, params.get(key)));
        }
        log.info((Object)sb.toString());
    }

    private void endPrintInfo(Actions action) {
        log.info((Object)String.format("%sing data has been done successfully!", action.toString().toLowerCase()));
    }

    private void errorPrintInfo(DataInjector injector, Actions action, Exception ex) {
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("%s %sed failed", injector.getName(), action.toString().toLowerCase()), (Throwable)ex);
        }
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Actions {
        INJECT,
        REJECT,
        EXECUTE;

    }
}

