/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.commons;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/webui/commons/UIDocumentSelector.gtmpl", events={@EventConfig(listeners={SelectFileActionListener.class}), @EventConfig(listeners={SelectFolderActionListener.class})})
public class UIDocumentSelector
extends UIContainer {
    protected static final Log logger = ExoLogger.getLogger(UIDocumentSelector.class);
    protected static final String SELECTFILE = "SelectFile";
    protected static final String SELECTFOLDER = "SelectFolder";
    protected static final String EMPTYCOMPONENT = "EmptyComponent";
    protected static final String RESTPREFIX = "/managedocument";
    protected static final String GETFOLDERSANDFILES = "/managedocument/getFoldersAndFiles";
    protected static final String DELETEFOLDERORFILE = "/managedocument/deleteFolderOrFile";
    protected static final String CREATEFOLDER = "/managedocument/createFolder";
    protected static final String PARAM_WORKSPACE = "workspaceName";
    protected static final String PARAM_NODEPATH = "nodePath";
    protected static final String PARAM_PARENTPATH = "parentPath";
    protected static final String PARAM_ISFOLDERONLY = "isFolderOnly";
    protected static final String PARAM_FOLDERNAME = "folderName";
    protected String currentWorkspaceName = "";
    protected String rootPath = "/";
    protected String seletedFile = "";
    protected String seletedFolder = "";
    private boolean allowAddFolder = false;
    private boolean allowDeleteItem = false;

    public UIDocumentSelector() {
        try {
            RepositoryService jcrService_ = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
            ManageableRepository currentRepo = jcrService_.getCurrentRepository();
            this.currentWorkspaceName = currentRepo.getConfiguration().getDefaultWorkspaceName();
            this.addChild(UIContainer.class, null, EMPTYCOMPONENT);
        }
        catch (Exception e) {
            logger.debug((Object)("Can't init ui component UIDocumentSelector :  " + e.getMessage()));
        }
    }

    public String getSeletedFile() {
        return this.seletedFile;
    }

    public void setSeletedFile(String seletedFile) {
        this.seletedFile = seletedFile;
    }

    public String getSeletedFolder() {
        return this.seletedFolder;
    }

    public void setSeletedFolder(String seletedFolder) {
        this.seletedFolder = seletedFolder;
    }

    protected String getRestContext() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (!(context instanceof PortalRequestContext)) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        String requestURL = ((PortalRequestContext)context).getRequest().getRequestURL().toString();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        StringBuilder sb = new StringBuilder();
        sb.append(requestURL.substring(0, requestURL.indexOf(portalName))).append(portalName).append("/").append(restContextName);
        return sb.toString();
    }

    public boolean isAllowAddFolder() {
        return this.allowAddFolder;
    }

    public void setAllowAddFolder(boolean allowAddFolder) {
        this.allowAddFolder = allowAddFolder;
    }

    public boolean isAllowDeleteItem() {
        return this.allowDeleteItem;
    }

    public void setAllowDeleteItem(boolean allowDeleteItem) {
        this.allowDeleteItem = allowDeleteItem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectFolderActionListener
    extends EventListener<UIDocumentSelector> {
        public void execute(Event<UIDocumentSelector> event) throws Exception {
            UIDocumentSelector component = (UIDocumentSelector)((Object)event.getSource());
            component.seletedFolder = event.getRequestContext().getRequestParameter("objectId");
            event.getRequestContext().addUIComponentToUpdateByAjax(component.getChildById(UIDocumentSelector.EMPTYCOMPONENT));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectFileActionListener
    extends EventListener<UIDocumentSelector> {
        public void execute(Event<UIDocumentSelector> event) throws Exception {
            UIDocumentSelector component = (UIDocumentSelector)((Object)event.getSource());
            component.seletedFile = event.getRequestContext().getRequestParameter("objectId");
            event.getRequestContext().addUIComponentToUpdateByAjax(component.getChildById(UIDocumentSelector.EMPTYCOMPONENT));
        }
    }
}

