# cp-naftogaz
Customer extension for Naftogaz

# Activating the MS Active Directory connector


## 1 Server environment configuration

###  exo.properties

The properties are changed in the file [\ gatein \ conf \ exo.properties]
This file must have a specific syntax, in case of doubt you can consult the doc. Java: 
https://docs.oracle.com/javase/8/docs/api/java/util/Properties.html

#### Deactivation of the following types of activities:
- exo.activity-type.SPACE_ACTIVITY.enabled=false
- exo.activity-type.USER_PROFILE_ACTIVITY.enabled=false
- exo.activity-type.exosocial\:relationship.enabled=false
- exo.activity-type.USER_ACTIVITIES_FOR_RELATIONSHIP.enabled=false
- exo.activity-type.USER_COMMENTS_ACTIVITY_FOR_RELATIONSHIP.enabled=false

#### People directory sort field configuration :
- exo.social.identity.firstChar.field=lastname

The properties of LDAP modules are as follows:
* **naftogaz.ad.providerurl**  This variable must contain the address of the LDAP provider.
Exemple :  
`naftogaz.ad.providerurl=naftogaz.com`  

* **naftogaz.ad.admindn.username**  Allows you to define the user name used to connect to LDAP. /!\ The `\ ` must be escaped: `\ ` => `\\`  
Exemple :   
`naftogaz.ad.admindn.username=portal-exo-svc`

* **naftogaz.ad.admindn.password**  
Exemple :  
`naftogaz.ad.admindn.password=`
  
* **naftogaz.ad.ctxDN01**  This variable is used to define root DNs.
For exemple :
```  
naftogaz.ad.ctxDN01=DC=naftogaz,DC=com  
```  
* **naftogaz.ad.entrySearchFilter**  This variable is only used for MSAD.It allows you to define a search filter in LDAP format with a little subtlety. It must at least contain the field corresponding to the "username" (`sAMAccountName` for MSAD) followed by` = {0} `. `sAMAccountName = {0}` is required in the query, sometimes `{0}` is replaced by `*` to get the list of people, but then `{0}` is replaced by the name of this person.

For exemple :  
`naftogaz.ad.entrySearchFilter=(&(sAMAccountName={0})(objectClass=User))`  

  
* **naftogaz.ad.name.displayName**  Name displayed  
Exemple:  
`naftogaz.ad.name.displayName=displayName`  

* **naftogaz.ad.name.email**  Email 
Exemple:  
`naftogaz.ad.name.email=mail`  

* **naftogaz.ad.name.lastName**  Surname 
Exemple:  
`naftogaz.ad.name.lastName=sn`  

* **naftogaz.ad.name.firstName**  First name  
Exemple:  
`naftogaz.ad.name.firstName=givenName`  

* **naftogaz.ad.name.jobtitle**  Title / Profession  
Exemple:  
`naftogaz.ad.name.jobtitle=title`  

* **naftogaz.ad.name.telephone.intcode**  Short internal telephone number  
Exemple:  
`naftogaz.ad.name.telephone.intcode=physicalDeliveryOfficeName`  

* **naftogaz.ad.name.mobile.number**  Mobile phone number  
Exemple:  
`naftogaz.ad.name.mobile.number=mobile` 

* **naftogaz.ad.name.idAttributeName**  ID active Directory  
Exemple:  
`naftogaz.ad.name.idAttributeName=sAMAccountName`  
 
* **naftogaz.ad.groups.ctxDN01**  This variable is used to define root DNs. 
For exemple :  
```  
naftogaz.ad.groups.ctxDN01=DC=naftogaz,DC=com 
``` 
* **naftogaz.ad.groups.entrySearchFilter**  This variable is only used for MSAD. It allows you to define a search filter in LDAP format with a little subtlety.It must at least contain the field corresponding to the "username" (`sAMAccountName` for MSAD) followed by` = {0} `.`sAMAccountName = {0}` is required in the query, sometimes `{0}` is replaced by `*` to get the list of people, but then `{0}` is replaced by the name of this person.
For example :  
`naftogaz.ad.groups.entrySearchFilter=(&(cn={0})(objectClass=group))` 

* **naftogaz.ad.groups.idAttributeName**  ID active Directory 
Exemple:  
`naftogaz.ad.groups.idAttributeName=cn`  

* **naftogaz.ad.groups.description**  Description of the group 
Exemple:  
`naftogaz.ad.groups.description=description`  

* **naftogaz.ad.groups.label**  Group label  
Exemple:  
`naftogaz.ad.groups.label=cn`  

* **naftogaz.ad.groups.parentMembershipAttributeName**  attribute which contains the group allocation list (member, memberOf, ...)  
Exemple:  
`naftogaz.ad.groups.parentMembershipAttributeName=memberOf`  


* **naftogaz.ad.groups.groupTypeMappingsMSAD**   


* **Read-only fields in AD / field mapping**
All fields are read-only and are configured in:
    - [picketlink-idm-msad-readonly-config.xml](./war/src/main/webapp/WEB-INF/conf/ad-ext/picketlink-idm-msad-readonly-config.xml) (mapping MSAD des champs côté Exo)  
    - [idm-configuration.xml](./war/src/main/webapp/WEB-INF/conf/ad-ext/idm-configuration.xml)   

#### To disable synchronizing all users, and make users get synchronized from AD when they are logged-in 
```
# Disable Cron jobs for synchronizing users
exo.idm.externalStore.import.cronExpression=
exo.idm.externalStore.delete.cronExpression= 
exo.idm.externalStore.queue.processing.cronExpression= 
# Synchronize users when they do a login
exo.idm.update.onlogin=true
```
