/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeCalendarPlugin
extends UpgradeProductPlugin {
    private static final String SHARED_CALENDAR = "sharedCalendars";
    private static final String FEED = "eXoCalendarFeed";
    private static final String SPACE_GROUP_ID = "/spaces";
    private static final String SPACE_CALENDAR_ID_SUFFIX = "_space_calendar";
    private static final Log log = ExoLogger.getLogger(UpgradeCalendarPlugin.class);
    private final RepositoryService repoService_;
    private final NodeHierarchyCreator nodeHierarchy_;
    private final CalendarServiceImpl calendarService_;
    private final SessionProviderService sessionProviderService_;
    private final OrganizationService organizationService_;
    private SocialChromatticLifeCycle socialLifeCycle_;

    public UpgradeCalendarPlugin(InitParams initParams, RepositoryService repoService, NodeHierarchyCreator nodeHierarchy, CalendarService calendarService, SessionProviderService sessionProviderService, OrganizationService organizationService, ChromatticManager chromatticMan) {
        super(initParams);
        this.repoService_ = repoService;
        this.nodeHierarchy_ = nodeHierarchy;
        this.calendarService_ = (CalendarServiceImpl)calendarService;
        this.sessionProviderService_ = sessionProviderService;
        this.organizationService_ = organizationService;
        this.socialLifeCycle_ = (SocialChromatticLifeCycle)chromatticMan.getLifeCycle("soc");
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            this.migrateCalendarRSS();
            this.migrateSpaceCalendars();
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeCalendarPlugin] Exception when migrate data from 2.1.x to 2.2.x for Calendar.", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    private Node getOldRssHome() throws Exception {
        SessionProvider sessionProvider = this.getSystemSessionProvider();
        String oldRssHomePath = this.nodeHierarchy_.getPublicApplicationNode(sessionProvider).getPath() + "/" + Utils.CALENDAR_APP + "/" + SHARED_CALENDAR + "/" + FEED;
        try {
            return (Node)this.getSession(sessionProvider).getItem(oldRssHomePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getRssHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarAppHomeNode(username);
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, Utils.NT_UNSTRUCTURED);
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    private Node getPublicCalendarHome() throws Exception {
        return this.calendarService_.getDataStorage().getPublicCalendarHome();
    }

    private Node getUserCalendarAppHomeNode(String username) throws Exception {
        Node userNode = this.nodeHierarchy_.getUserApplicationNode(this.getSystemSessionProvider(), username);
        try {
            return userNode.getNode(Utils.CALENDAR_APP);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    private SessionProvider getSystemSessionProvider() {
        return this.sessionProviderService_.getSystemSessionProvider(null);
    }

    private void migrateCalendarRSS() throws Exception {
        log.info((Object)"[UpgradeCalendarPlugin] Migrating calendar RSS ...");
        Node oldRssHome = this.getOldRssHome();
        if (oldRssHome != null) {
            NodeIterator iterator = oldRssHome.getNodes();
            while (iterator.hasNext()) {
                Node feedNode = iterator.nextNode();
                String url = feedNode.getProperty(Utils.EXO_BASE_URL).getString();
                String username = url.substring(url.indexOf("/cs/calendar/feed/") + 18);
                username = username.substring(0, username.indexOf("/"));
                Node rssHome = this.getRssHome(username);
                url = url.substring(url.indexOf(":") + 3);
                url = url.substring(url.indexOf("/") + 1);
                url = url.substring(url.indexOf("/"));
                feedNode.setProperty(Utils.EXO_BASE_URL, url);
                feedNode.save();
                Session session = feedNode.getSession();
                session.move(feedNode.getPath(), rssHome.getPath() + "/" + feedNode.getName());
                session.save();
            }
        } else {
            log.info((Object)"[UpgradeCalendarPlugin] There is not any calendar RSS to migrate.");
        }
        log.info((Object)"[UpgradeCalendarPlugin] Finished migrate calendar RSS.");
    }

    private void migrateSpaceCalendars() throws Exception {
        log.info((Object)"[UpgradeCalendarPlugin] Migrating space calendars ...");
        Node publicCalendarHome = this.getPublicCalendarHome();
        NodeIterator iter = this.getSpaceCalendars();
        if (iter.getSize() > 0L) {
            Map<String, String> spaceGroupIds = this.getSpaceGroups();
            while (iter.hasNext()) {
                Node calendarNode = iter.nextNode();
                List<String> spaceGroup = this.valuesToList(calendarNode.getProperty(Utils.EXO_GROUPS).getValues());
                String groupId = this.getGroupId(spaceGroup);
                String newId = groupId + SPACE_CALENDAR_ID_SUFFIX;
                String oldId = calendarNode.getProperty(Utils.EXO_ID).getString();
                this.migrateActivityCalendarId(oldId, newId);
                if (!spaceGroupIds.containsKey(groupId) || newId.equals(calendarNode.getName())) continue;
                calendarNode.setProperty(Utils.EXO_ID, newId);
                calendarNode.setProperty(Utils.EXO_NAME, spaceGroupIds.get(groupId));
                calendarNode.save();
                NodeIterator events = calendarNode.getNodes();
                if (events.getSize() > 0L) {
                    while (events.hasNext()) {
                        Node event = events.nextNode();
                        event.setProperty(Utils.EXO_CALENDAR_ID, newId);
                        event.save();
                    }
                }
                Session session = publicCalendarHome.getSession();
                session.move(calendarNode.getPath(), publicCalendarHome.getPath() + "/" + newId);
                session.save();
            }
        } else {
            log.info((Object)"[UpgradeCalendarPlugin] There is not any space calendars to migrate.");
        }
        log.info((Object)("[UpgradeCalendarPlugin] Finished migrating space calendars. " + iter.getSize() + " calendars are migrated."));
    }

    private void migrateActivityCalendarId(String oldId, String newId) {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            Session jcrSession = this.socialLifeCycle_.getSession().getJCRSession();
            QueryManager qm = jcrSession.getWorkspace().getQueryManager();
            String sql = "select * from soc:activityparam where CalendarID='" + oldId + "'";
            Query q = qm.createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node activityNode = nodeIterator.nextNode();
                activityNode.setProperty("CalendarID", newId);
                activityNode.save();
            }
            jcrSession.save();
            RequestLifeCycle.end();
            log.info((Object)("Succesfully migrated " + nodeIterator.getSize() + " nodes"));
        }
        catch (NullPointerException ne) {
            log.error((Object)"Failed to get social session data !", (Throwable)ne);
        }
        catch (Exception e) {
            log.error((Object)"Failed to migrate Activity CalendarID", (Throwable)e);
        }
    }

    private NodeIterator getSpaceCalendars() throws Exception {
        Node node = this.getPublicCalendarHome();
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        StringBuilder strQuery = new StringBuilder("[jcr:like(@").append(Utils.EXO_ID).append(", 'CalendarInSpace%')]");
        StringBuilder pathQuery = new StringBuilder("/jcr:root").append(node.getPath()).append("//element(*,").append(Utils.EXO_CALENDAR).append(")").append((CharSequence)strQuery).append(" order by @").append(Utils.EXO_ID).append(" descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getSpaceGroups() throws Exception {
        HashMap<String, String> groupIds = new HashMap<String, String>();
        boolean started = false;
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            started = true;
            Group group = this.organizationService_.getGroupHandler().findGroupById(SPACE_GROUP_ID);
            if (group != null) {
                Collection groups = this.organizationService_.getGroupHandler().findGroups(group);
                for (Group gr : groups) {
                    groupIds.put(gr.getGroupName(), gr.getLabel());
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"\nFailed to get all space groups.", (Throwable)e);
        }
        finally {
            if (started) {
                RequestLifeCycle.end();
            }
        }
        return groupIds;
    }

    private String getGroupId(List<String> spaceGroups) throws Exception {
        for (String spaceGroup : spaceGroups) {
            if (spaceGroup.indexOf("/spaces/") < 0 || Utils.isEmpty((String)(spaceGroup = spaceGroup.substring(spaceGroup.lastIndexOf("/") + 1)))) continue;
            return spaceGroup;
        }
        return "";
    }

    private List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (Utils.isEmpty((String)s)) continue;
            list.add(s);
        }
        return list;
    }
}

