/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalendarImportExport
implements CalendarImportExport {
    private static final String PRIVATE_TYPE = "0".intern();
    private static final String SHARED_TYPE = "1".intern();
    private static final String PUBLIC_TYPE = "2".intern();
    private JCRDataStorage storage_;

    public ICalendarImportExport(JCRDataStorage storage) throws Exception {
        this.storage_ = storage;
    }

    @Override
    public OutputStream exportCalendar(SessionProvider sProvider, String username, List<String> calendarIds, String type) throws Exception {
        List<Object> events = new ArrayList();
        if (type.equals(PRIVATE_TYPE)) {
            events = this.storage_.getUserEventByCalendar(sProvider, username, calendarIds);
        } else if (type.equals(SHARED_TYPE)) {
            events = this.storage_.getSharedEventByCalendars(sProvider, username, calendarIds);
        } else if (type.equals(PUBLIC_TYPE)) {
            events = this.storage_.getGroupEventByCalendar(sProvider, calendarIds);
        }
        if (events.isEmpty()) {
            return null;
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        int eventCounter = 0;
        for (CalendarEvent calendarEvent : events) {
            String[] attendees;
            VEvent event;
            ++eventCounter;
            if (!calendarEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) continue;
            long start = calendarEvent.getFromDateTime().getTime();
            long end = calendarEvent.getToDateTime().getTime();
            String summary = calendarEvent.getSummary();
            if (end > 0L) {
                event = new VEvent((Date)new DateTime(start), (Date)new DateTime(end), summary);
                event.getProperties().getProperty("DTEND").getParameters().add((Parameter)Value.DATE_TIME);
            } else {
                event = new VEvent((Date)new DateTime(start), summary);
            }
            event.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
            event.getProperties().add((Property)new Description(calendarEvent.getDescription()));
            event.getProperties().getProperty("DESCRIPTION").getParameters().add((Parameter)Value.TEXT);
            event.getProperties().add((Property)new Location(calendarEvent.getLocation()));
            event.getProperties().getProperty("LOCATION").getParameters().add((Parameter)Value.TEXT);
            if (calendarEvent.getEventCategoryId() != null) {
                event.getProperties().add((Property)new Categories(calendarEvent.getEventCategoryId()));
                event.getProperties().getProperty("CATEGORIES").getParameters().add((Parameter)Value.TEXT);
            }
            if (calendarEvent.getPriority() != null) {
                event.getProperties().add((Property)new Priority(Integer.parseInt(calendarEvent.getPriority())));
                event.getProperties().getProperty("PRIORITY").getParameters().add((Parameter)Value.INTEGER);
            }
            if (calendarEvent.getEventType().equals(CalendarEvent.TYPE_TASK)) {
                long completed = calendarEvent.getCompletedDateTime().getTime();
                event.getProperties().add((Property)new Completed(new DateTime(completed)));
                event.getProperties().getProperty("COMPLETED").getParameters().add((Parameter)Value.DATE_TIME);
                event.getProperties().add((Property)new Due((Date)new DateTime(end)));
                event.getProperties().getProperty("DUE").getParameters().add((Parameter)Value.DATE_TIME);
                event.getProperties().add((Property)new Status(calendarEvent.getStatus()));
                event.getProperties().getProperty("STATUS").getParameters().add((Parameter)Value.TEXT);
            }
            if ((attendees = calendarEvent.getInvitation()) != null && attendees.length > 0) {
                for (int i = 0; i < attendees.length; ++i) {
                    if (attendees[i] == null) continue;
                    event.getProperties().add((Property)new Attendee(attendees[i]));
                }
                event.getProperties().getProperty("ATTENDEE").getParameters().add((Parameter)Value.TEXT);
            }
            Uid id = new Uid(calendarEvent.getId());
            event.getProperties().add((Property)id);
            calendar.getComponents().add((Component)event);
        }
        if (eventCounter == 0) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter calendarOutputter = new CalendarOutputter();
        try {
            calendarOutputter.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            return null;
        }
        return bout;
    }

    @Override
    public OutputStream exportEventCalendar(SessionProvider sProvider, String username, String calendarId, String type, String eventId) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (type.equals(PRIVATE_TYPE)) {
            events.add(this.storage_.getUserEvent(sProvider, username, calendarId, eventId));
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (CalendarEvent exoEvent : events) {
            String[] attendees;
            VEvent event;
            if (!exoEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) continue;
            long start = exoEvent.getFromDateTime().getTime();
            long end = exoEvent.getToDateTime().getTime();
            String summary = exoEvent.getSummary();
            if (end > 0L) {
                event = new VEvent((Date)new DateTime(start), (Date)new DateTime(end), summary);
                event.getProperties().getProperty("DTEND").getParameters().add((Parameter)Value.DATE_TIME);
            } else {
                event = new VEvent((Date)new DateTime(start), summary);
            }
            event.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
            event.getProperties().add((Property)new Description(exoEvent.getDescription()));
            event.getProperties().getProperty("DESCRIPTION").getParameters().add((Parameter)Value.TEXT);
            event.getProperties().add((Property)new Location(exoEvent.getLocation()));
            event.getProperties().getProperty("LOCATION").getParameters().add((Parameter)Value.TEXT);
            if (exoEvent.getEventCategoryId() != null) {
                event.getProperties().add((Property)new Categories(exoEvent.getEventCategoryId()));
                event.getProperties().getProperty("CATEGORIES").getParameters().add((Parameter)Value.TEXT);
            }
            if (exoEvent.getPriority() != null) {
                event.getProperties().add((Property)new Priority(Integer.parseInt(exoEvent.getPriority())));
                event.getProperties().getProperty("PRIORITY").getParameters().add((Parameter)Value.INTEGER);
            }
            if (exoEvent.getEventType().equals(CalendarEvent.TYPE_TASK)) {
                long completed = exoEvent.getCompletedDateTime().getTime();
                event.getProperties().add((Property)new Completed(new DateTime(completed)));
                event.getProperties().getProperty("COMPLETED").getParameters().add((Parameter)Value.DATE_TIME);
                event.getProperties().add((Property)new Due((Date)new DateTime(end)));
                event.getProperties().getProperty("DUE").getParameters().add((Parameter)Value.DATE_TIME);
                event.getProperties().add((Property)new Status(exoEvent.getStatus()));
                event.getProperties().getProperty("STATUS").getParameters().add((Parameter)Value.TEXT);
            }
            if ((attendees = exoEvent.getInvitation()) != null && attendees.length > 0) {
                for (int i = 0; i < attendees.length; ++i) {
                    if (attendees[i] == null) continue;
                    event.getProperties().add((Property)new Attendee(attendees[i]));
                }
                event.getProperties().getProperty("ATTENDEE").getParameters().add((Parameter)Value.TEXT);
            }
            Uid id = new Uid(exoEvent.getId());
            event.getProperties().add((Property)id);
            calendar.getComponents().add((Component)event);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter output = new CalendarOutputter();
        try {
            output.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            return null;
        }
        return bout;
    }

    @Override
    public void importCalendar(SessionProvider sProvider, String username, InputStream icalInputStream, String calendarName) throws Exception {
        String categoryId;
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        GregorianCalendar currentDateTime = new GregorianCalendar();
        NodeIterator iter = this.storage_.getCalendarCategoryHome(sProvider, username).getNodes();
        Node cat = null;
        boolean isExists = false;
        while (iter.hasNext()) {
            cat = iter.nextNode();
            if (!cat.getProperty("exo:name").getString().equals("Imported")) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            CalendarCategory calendarCate = new CalendarCategory();
            currentDateTime = new GregorianCalendar();
            calendarCate.setDescription("Imported icalendar category");
            calendarCate.setName("Imported");
            categoryId = calendarCate.getId();
            this.storage_.saveCalendarCategory(sProvider, username, calendarCate, true);
        } else {
            categoryId = cat.getProperty("exo:id").getString();
        }
        Calendar exoCalendar = new Calendar();
        exoCalendar.setName(calendarName);
        exoCalendar.setDescription(iCalendar.getProductId().getValue());
        exoCalendar.setCategoryId(categoryId);
        exoCalendar.setPublic(true);
        exoCalendar.setCalendarOwner(username);
        this.storage_.saveUserCalendar(sProvider, username, exoCalendar, true);
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            if (!(obj instanceof VEvent)) continue;
            VEvent event = (VEvent)obj;
            String eventCategoryId = null;
            if (event.getProperty("CATEGORIES") != null) {
                currentDateTime = new GregorianCalendar();
                EventCategory evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue());
                evCate.setDescription(event.getProperty("CATEGORIES").getValue());
                try {
                    this.storage_.saveEventCategory(sProvider, username, evCate, null, true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                eventCategoryId = evCate.getName();
            }
            CalendarEvent exoEvent = new CalendarEvent();
            currentDateTime = new GregorianCalendar();
            exoEvent.setCalendarId(exoCalendar.getId());
            exoEvent.setEventCategoryId(eventCategoryId);
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
            }
            if (event.getEndDate() != null) {
                exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(event.getPriority().getValue());
            }
            exoEvent.setPrivate(true);
            currentDateTime = new GregorianCalendar();
            ArrayList<Reminder> reminders = new ArrayList<Reminder>();
            exoEvent.setReminders(reminders);
            PropertyList attendees = event.getProperties("ATTENDEE");
            if (attendees.size() < 1) {
                exoEvent.setInvitation(new String[0]);
            } else {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            this.storage_.saveUserEvent(sProvider, username, exoCalendar.getId(), exoEvent, true);
        }
    }

    @Override
    public List<CalendarEvent> getEventObjects(InputStream icalInputStream) throws Exception {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        ComponentList componentList = iCalendar.getComponents();
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        for (Object obj : componentList) {
            if (!(obj instanceof VEvent)) continue;
            CalendarEvent exoEvent = new CalendarEvent();
            VEvent event = (VEvent)obj;
            if (event.getProperty("UID") != null) {
                exoEvent.setId(event.getProperty("UID").getValue());
            }
            if (event.getProperty("CATEGORIES") != null) {
                exoEvent.setEventCategoryId(event.getProperty("CATEGORIES").getValue());
            }
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
            }
            if (event.getEndDate() != null) {
                exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(event.getPriority().getValue());
            }
            exoEvent.setPrivate(true);
            ArrayList<Reminder> reminders = new ArrayList<Reminder>();
            exoEvent.setReminders(reminders);
            PropertyList attendees = event.getProperties("ATTENDEE");
            if (attendees.size() < 1) {
                exoEvent.setInvitation(new String[0]);
            } else {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            eventList.add(exoEvent);
        }
        return eventList;
    }
}

