/**
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 **/
package org.exoplatform.calendar.service;

import java.util.List;

/**
 * Created by The eXo Platform SARL
 * Author : Hung Nguyen Quang
 *          hung.nguyen@exoplatform.com
 * Jul 11, 2007  
 */
public class GroupCalendarData {
  private String id ;
  private String name ;
  private List<Calendar> calendars ;
  
  public GroupCalendarData(String id, String name, List<Calendar> calendars) throws Exception {
    this.id = id ;
    this.name = name ;
    this.calendars = calendars ;
  }
  public String getId() { return id ; }
  public void setId(String id) { this.id = id ; }
  
  public String getName() { return name ; }
  public void setName(String name) { this.name = name ; }

  public List<Calendar> getCalendars() { return calendars ; }
  public void setCalendars(List<Calendar> calendars) { this.calendars = calendars ; }
  public Calendar getCalendarById(String calendarId) {
    if(calendarId != null && calendars != null && !calendars.isEmpty()) {
      for (Calendar cal : calendars) {
        if(calendarId.equals(cal.getId())) {
          return cal ;
        }
      }
    }
    return null ;
  }
}
