/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    protected CalendarService calendarService_;
    private String defaultCalendarDescription;
    private String defaultLocale;
    private String defaultTimeZone;
    private String[] editPermission;
    private String[] viewPermission;
    private List<String> ignore_groups_;
    public final String ST_GROUP_IGNORE = "ignoredGroups".intern();

    public NewGroupListener(CalendarService calendarService, InitParams params) {
        this.calendarService_ = calendarService;
        if (params.getValueParam("defaultEditPermission") != null) {
            this.editPermission = params.getValueParam("defaultEditPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultViewPermission") != null) {
            this.viewPermission = params.getValueParam("defaultViewPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultCalendarDescription") != null) {
            this.defaultCalendarDescription = params.getValueParam("defaultCalendarDescription").getValue();
        }
        if (params.getValueParam("defaultLocale") != null) {
            this.defaultLocale = params.getValueParam("defaultLocale").getValue();
        }
        if (params.getValueParam("defaultTimeZone") != null) {
            this.defaultTimeZone = params.getValueParam("defaultTimeZone").getValue();
        }
        if (params.getValuesParam(this.ST_GROUP_IGNORE) != null && !params.getValuesParam(this.ST_GROUP_IGNORE).getValues().isEmpty()) {
            this.ignore_groups_ = params.getValuesParam(this.ST_GROUP_IGNORE).getValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        String groupId = group.getId();
        if (this.ignore_groups_ != null && !this.ignore_groups_.isEmpty()) {
            for (String g : this.ignore_groups_) {
                if (!groupId.equalsIgnoreCase(g)) continue;
                return;
            }
        }
        boolean isPublic = true;
        Calendar calendar = new Calendar();
        calendar.setName(group.getGroupName() + " calendar");
        if (this.defaultCalendarDescription != null) {
            calendar.setDescription(this.defaultCalendarDescription);
        }
        calendar.setGroups(new String[]{groupId});
        calendar.setPublic(isPublic);
        if (this.defaultLocale != null) {
            calendar.setLocale(this.defaultLocale);
        }
        if (this.defaultTimeZone != null) {
            calendar.setTimeZone(this.defaultTimeZone);
        }
        calendar.setCalendarColor(Calendar.SEASHELL);
        ArrayList<String> perms = new ArrayList<String>();
        for (String s : this.viewPermission) {
            if (perms.contains(s)) continue;
            perms.add(s);
        }
        calendar.setViewPermission(perms.toArray(new String[perms.size()]));
        perms.clear();
        for (String s : this.editPermission) {
            String groupKey = groupId + "/:" + s;
            if (perms.contains(groupKey)) continue;
            perms.add(groupKey);
        }
        calendar.setEditPermission(perms.toArray(new String[perms.size()]));
        SessionProvider sProvider = this.createSystemProvider();
        try {
            this.calendarService_.savePublicCalendar(calendar, isNew, null);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Group group) throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        try {
            List<GroupCalendarData> gCalData = this.calendarService_.getGroupCalendars(new String[]{group.getId()}, true, null);
            for (GroupCalendarData gc : gCalData) {
                if (gc == null || gc.getCalendars().isEmpty()) continue;
                for (Calendar c : gc.getCalendars()) {
                    this.calendarService_.removePublicCalendar(c.getId());
                }
            }
            super.postDelete(group);
        }
        finally {
            sProvider.close();
        }
    }

    private SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }
}

