/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class AutoGeneratePeriodJobImp
implements Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jContext) throws JobExecutionException {
        PortalContainer container = Utils.getPortalContainer(jContext);
        if (container == null) {
            return;
        }
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        JobDataMap jdatamap = jContext.getJobDetail().getJobDataMap();
        String numberLimited = jdatamap.getString("event_number");
        CalendarService calSvr = (CalendarService)container.getComponentInstanceOfType(CalendarService.class);
        try {
            if (calSvr == null) {
                System.out.println("\n\n Can not get calendar service");
                return;
            }
            List<FeedData> data = calSvr.getFeeds(null);
            Iterator<FeedData> i$ = data.iterator();
            while (i$.hasNext()) {
                SyndFeedInput input = new SyndFeedInput();
                FeedData d = i$.next();
                URL feedUrl = new URL(d.getUrl());
                SyndFeed feed = input.build((Reader)new XmlReader(feedUrl));
                if (feed.getEntries() == null || feed.getEntries().size() == 0) continue;
                SyndEntry entry = (SyndEntry)feed.getEntries().get(0);
                String calId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                calSvr.updateRss(entry.getAuthor(), calId, calSvr.getCalendarImportExports(CalendarService.ICALENDAR), Integer.parseInt(numberLimited));
                calSvr.updateCalDav(entry.getAuthor(), calId, calSvr.getCalendarImportExports(CalendarService.ICALENDAR), Integer.parseInt(numberLimited));
            }
        }
        catch (Exception e) {
        }
        finally {
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

