/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={CloseSearchActionListener.class}), @EventConfig(listeners={ViewDetailActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class})})
public class UIListView
extends UICalendarView {
    private LinkedHashMap<String, CalendarEvent> eventMap_ = new LinkedHashMap();
    private EventPageList pageList_ = null;
    private String selectedEvent_ = null;
    private boolean isShowEventAndTask = true;
    private boolean isSearchResult = false;
    private String lastViewId_ = null;
    private String categoryId_ = null;
    private String keyWords_ = null;

    public UIListView() throws Exception {
        if (this.getEvents().length > 0) {
            this.selectedEvent_ = this.getEvents()[0].getId();
        }
    }

    public String getTemplate() {
        if (this.getViewType().equals(TYPE_TASK)) {
            return "app:/templates/calendar/webui/UIListTask.gtmpl";
        }
        if (this.getViewType().equals(TYPE_EVENT)) {
            return "app:/templates/calendar/webui/UIListEvent.gtmpl";
        }
        return "app:/templates/calendar/webui/UIListView.gtmpl";
    }

    public void refresh() throws Exception {
        UIListContainer uiListContainer;
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = Util.getPortalRequestContext().getRemoteUser();
        EventQuery eventQuery = new EventQuery();
        if (!(CalendarUtils.isEmpty((String)this.categoryId_) || this.categoryId_.toLowerCase().equals("null") || this.categoryId_.toLowerCase().equals("all"))) {
            eventQuery.setCategoryId(new String[]{this.categoryId_});
        }
        Calendar fromcalendar = this.getBeginDay((Calendar)new GregorianCalendar(this.getCurrentYear(), this.getCurrentMonth(), this.getCurrentDay()));
        eventQuery.setFromDate(fromcalendar);
        Calendar tocalendar = this.getEndDay((Calendar)new GregorianCalendar(this.getCurrentYear(), this.getCurrentMonth(), this.getCurrentDay()));
        eventQuery.setToDate(tocalendar);
        if (!this.getViewType().equals(TYPE_BOTH)) {
            eventQuery.setEventType(this.getViewType());
        }
        if ((uiListContainer = (UIListContainer)this.getParent()).isDisplaySearchResult()) {
            this.update(this.pageList_);
        } else {
            this.update(new EventPageList(calendarService.getEvents(this.getSession(), username, eventQuery, this.getPublicCalendars()), 10L));
        }
        UIFormSelectBox uiCategory = this.getUIFormSelectBox(EVENT_CATEGORIES);
        uiCategory.setValue(this.categoryId_);
        uiCategory.setOnChange("Onchange");
        UIListContainer uiContainer = (UIListContainer)this.getParent();
        UIPreview view = (UIPreview)uiContainer.getChild(UIPreview.class);
        if (CalendarUtils.isEmpty((String)this.getSelectedEvent())) {
            if (this.getEvents().length > 0) {
                String eventId = this.getEvents()[0].getId();
                this.setSelectedEvent(eventId);
                this.setLastUpdatedEventId(eventId);
                view.setEvent(this.getEvents()[0]);
            } else {
                this.setSelectedEvent(null);
                view.setEvent(null);
                this.setLastUpdatedEventId(null);
            }
        } else if (this.getEvents().length > 0) {
            for (CalendarEvent cal : this.getEvents()) {
                if (!cal.getId().equals(this.getSelectedEvent())) continue;
                view.setEvent(cal);
                this.setLastUpdatedEventId(this.getSelectedEvent());
                break;
            }
        } else {
            this.setSelectedEvent(null);
            view.setEvent(null);
            this.setLastUpdatedEventId(null);
        }
    }

    public void update(EventPageList pageList) throws Exception {
        this.pageList_ = pageList;
        this.updateCurrentPage(this.pageList_.getCurrentPage());
    }

    protected void updateCurrentPage(long page) throws Exception {
        this.getChildren().clear();
        this.initCategories();
        this.eventMap_.clear();
        if (this.pageList_ != null) {
            for (CalendarEvent calendarEvent : this.pageList_.getPage(page, CalendarUtils.getCurrentUser())) {
                UIFormCheckBoxInput checkbox = new UIFormCheckBoxInput(calendarEvent.getId(), calendarEvent.getId(), (Object)false);
                this.addUIFormInput((UIFormInput)checkbox);
                if (this.getViewType().equals(TYPE_BOTH)) {
                    this.eventMap_.put(calendarEvent.getId(), calendarEvent);
                    continue;
                }
                if (!this.getViewType().equals(calendarEvent.getEventType())) continue;
                this.eventMap_.put(calendarEvent.getId(), calendarEvent);
            }
        }
    }

    public CalendarEvent[] getEvents() throws Exception {
        if (this.eventMap_ == null || this.eventMap_.size() == 0) {
            return new CalendarEvent[0];
        }
        return this.eventMap_.values().toArray(new CalendarEvent[0]);
    }

    public long getAvailablePage() {
        return this.pageList_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.pageList_.getCurrentPage();
    }

    protected boolean isShowEvent() {
        return this.isShowEvent_;
    }

    protected boolean isShowEventAndTask() {
        return this.isShowEventAndTask;
    }

    public void setShowEventAndTask(boolean show) {
        this.isShowEventAndTask = show;
    }

    public boolean isDisplaySearchResult() {
        return this.isSearchResult;
    }

    public void setDisplaySearchResult(boolean show) {
        this.isSearchResult = show;
    }

    public void setSelectedEvent(String selectedEvent) {
        this.selectedEvent_ = selectedEvent;
    }

    public String getSelectedEvent() {
        return this.selectedEvent_;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return this.eventMap_;
    }

    public List<CalendarEvent> getSelectedEvents() {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (CalendarEvent ce : this.eventMap_.values()) {
            UIFormCheckBoxInput checkbox = (UIFormCheckBoxInput)this.getChildById(ce.getId());
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add(ce);
        }
        return events;
    }

    public void setLastViewId(String lastViewId_) {
        this.lastViewId_ = lastViewId_;
    }

    public String getLastViewId() {
        return this.lastViewId_;
    }

    public void setCategoryId(String catetoryId) {
        this.categoryId_ = catetoryId;
        this.setSelectedCategory(catetoryId);
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public CalendarEvent getSelectedEventObj() {
        return (CalendarEvent)this.eventMap_.get(this.selectedEvent_);
    }

    public void setKeyWords(String keyWords) {
        this.keyWords_ = keyWords;
    }

    public String getKeyWords() {
        return this.keyWords_;
    }
}

