/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.popup.UICalDavForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={GenerateActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalDavForm
extends UIFormTabPane
implements UIPopupComponent {
    private static final String URL = "url".intern();
    private static final String DESCRIPTION = "description".intern();
    private static final String COPYRIGHT = "copyright".intern();
    private static final String TITLE = "title".intern();
    private static final String PUBLIC_DATE = "pubDate".intern();
    private static final String INFOR = "info".intern();
    private static final String MESSAGE = "message".intern();
    private static final String DESCRIPTIONS = "descriptions".intern();
    private static final String COPYRIGHTS = "copyrights".intern();

    public UICalDavForm() throws Exception {
        super("UICalDavForm");
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = Util.getPortalRequestContext().getRemoteUser();
        UIFormInputWithActions rssInfo = new UIFormInputWithActions("rssInfo");
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(TITLE, TITLE, "eXoCalendarCalDav").addValidator(MandatoryValidator.class, new Object[0]));
        String url = calendarService.getCalendarSetting(SessionProviderFactory.createSessionProvider(), username).getBaseURL();
        if (CalendarUtils.isEmpty((String)url)) {
            url = CalendarUtils.getServerBaseUrl() + "calendar/iCalRss";
        }
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(URL, URL, url).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, DESCRIPTIONS).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(COPYRIGHT, COPYRIGHT, "Copyright by 2000-2005 eXo Platform SARL").addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormDateTimeInput(PUBLIC_DATE, PUBLIC_DATE, new Date(), false));
        this.setSelectedTab(rssInfo.getId());
        this.addUIFormInput((UIFormInputSet)rssInfo);
        UIFormInputWithActions rssCalendars = new UIFormInputWithActions("rssCalendars");
        rssCalendars.addUIFormInput((UIFormInput)new UIFormInputInfo(INFOR, INFOR, null));
        List calendars = calendarService.getUserCalendars(SessionProviderFactory.createSessionProvider(), username, true);
        for (Calendar calendar : calendars) {
            rssCalendars.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getName(), calendar.getId(), (Object)true));
        }
        this.addUIFormInput((UIFormInputSet)rssCalendars);
    }

    public void init() throws Exception {
        UIFormInputWithActions rssInfo = (UIFormInputWithActions)this.getChildById("rssInfo");
        rssInfo.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)this.getLabel(DESCRIPTIONS));
        rssInfo.getUIStringInput(COPYRIGHT).setValue((Object)this.getLabel(COPYRIGHTS));
        UIFormInputWithActions rssTab = (UIFormInputWithActions)this.getChildById("rssCalendars");
        rssTab.getUIFormInputInfo(INFOR).setValue((Object)this.getLabel(MESSAGE));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getWebDAVServerPrefix() throws Exception {
        String prefixWebDAV = CalendarUtils.getServerBaseUrl() + this.getPortalName() + "/rest/jcr/" + this.getRepository().getConfiguration().getName() + "/" + this.getWorkspaceName();
        return prefixWebDAV;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getWorkspaceName() throws Exception {
        return this.getRepository().getConfiguration().getDefaultWorkspaceName();
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    static /* synthetic */ String access$000() {
        return TITLE;
    }

    static /* synthetic */ String access$100() {
        return URL;
    }

    static /* synthetic */ String access$200() {
        return DESCRIPTION;
    }

    static /* synthetic */ String access$300() {
        return COPYRIGHT;
    }

    static /* synthetic */ String access$400() {
        return PUBLIC_DATE;
    }
}

