/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.webui.popup.UIExportForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIExportForm
extends UIForm
implements UIPopupComponent {
    private static final String NAME = "name".intern();
    private static final String TYPE = "type".intern();
    private String calType = "0";
    private Map<String, String> names_ = new HashMap();

    public UIExportForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null));
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption(CalendarServiceImpl.ICALENDAR, (Object)CalendarServiceImpl.ICALENDAR));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
    }

    public void setCalType(String type) {
        this.calType = type;
    }

    public void update(String type, String selectedCalendarId) throws Exception {
        this.calType = type;
        this.names_.clear();
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            if (iter instanceof UIFormCheckBoxInput) {
                iter.remove();
            }
            iter.next();
        }
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List calendars = new ArrayList();
        if (this.calType.equals("0")) {
            calendars = calendarService.getUserCalendars(SessionProviderFactory.createSessionProvider(), CalendarUtils.getCurrentUser(), true);
        } else if (this.calType.equals("1")) {
            calendars = calendarService.getSharedCalendars(SessionProviderFactory.createSystemProvider(), CalendarUtils.getCurrentUser(), true).getCalendars();
        } else if (this.calType.equals("2")) {
            List groups = calendarService.getGroupCalendars(SessionProviderFactory.createSystemProvider(), CalendarUtils.getUserGroups((String)CalendarUtils.getCurrentUser()), true, CalendarUtils.getCurrentUser());
            for (GroupCalendarData group : groups) {
                calendars.addAll(group.getCalendars());
            }
        }
        this.initCheckBox(calendars, selectedCalendarId);
    }

    public void initCheckBox(List<Calendar> calendars, String selectedCalendarId) {
        for (Calendar calendar : calendars) {
            UIFormCheckBoxInput checkBox = new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)false);
            if (calendar.getId().equals(selectedCalendarId)) {
                checkBox.setChecked(true);
            } else {
                checkBox.setChecked(false);
            }
            this.addUIFormInput((UIFormInput)checkBox);
            this.names_.put(calendar.getId(), calendar.getName());
        }
    }

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            if (this.names_.get(id) != null) {
                return (String)this.names_.get(id);
            }
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ String access$000() {
        return TYPE;
    }

    static /* synthetic */ String access$100() {
        return NAME;
    }

    static /* synthetic */ String access$200(UIExportForm x0) {
        return x0.calType;
    }
}

