/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.Colors;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UICalendars.gtmpl", events={@EventConfig(listeners={AddCalendarActionListener.class}), @EventConfig(listeners={AddEventCategoryActionListener.class}), @EventConfig(listeners={EditGroupActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DeleteGroupActionListener.class}, confirm="UICalendars.msg.confirm-delete-group"), @EventConfig(listeners={ExportCalendarActionListener.class}), @EventConfig(listeners={ExportCalendarsActionListener.class}), @EventConfig(listeners={ImportCalendarActionListener.class}), @EventConfig(listeners={GenerateRssActionListener.class}), @EventConfig(listeners={GenerateCalDavActionListener.class}), @EventConfig(listeners={AddEventActionListener.class}), @EventConfig(listeners={AddTaskActionListener.class}), @EventConfig(listeners={EditCalendarActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveCalendarActionListener.class}), @EventConfig(listeners={AddCalendarCategoryActionListener.class}), @EventConfig(listeners={ShareCalendarActionListener.class}), @EventConfig(listeners={ChangeColorActionListener.class}), @EventConfig(listeners={CalendarSettingActionListener.class})})
public class UICalendars
extends UIForm {
    public static String CALENDARID = "calendarid".intern();
    public static String CALTYPE = "calType".intern();
    public static String CALNAME = "calName".intern();
    public static String CALCOLOR = "calColor".intern();
    public static String CURRENTTIME = "ct".intern();
    public static String TIMEZONE = "tz".intern();
    private boolean isShowTaskList_ = false;
    private String[] publicCalendarIds = new String[0];
    private LinkedHashMap<String, String> colorMap_ = new LinkedHashMap();

    public String getLabel(String key) {
        try {
            return super.getLabel(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    public String[] getPublicCalendarIds() {
        return this.publicCalendarIds;
    }

    public void setShowTaskList(boolean isShowTaskList) {
        this.isShowTaskList_ = isShowTaskList;
    }

    public boolean isShowTaskList() {
        return this.isShowTaskList_;
    }

    public java.util.Calendar getCurrentMiniBeginDate() {
        UIMiniCalendar miniCal = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
        java.util.Calendar temCal = miniCal.getInstanceTempCalendar();
        temCal.setTime(miniCal.getCurrentDate());
        return miniCal.getBeginDay(temCal);
    }

    public java.util.Calendar getCurrentMiniEndDate() {
        UIMiniCalendar miniCal = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
        java.util.Calendar temCal = miniCal.getInstanceTempCalendar();
        temCal.setTime(miniCal.getCurrentDate());
        return miniCal.getEndDay(temCal);
    }

    public String[] getTaskStatus() {
        return CalendarEvent.TASK_STATUS;
    }

    public List<CalendarEvent> getAllTask(java.util.Calendar formDate, java.util.Calendar toDate, String taskStatus) throws Exception {
        ArrayList<CalendarEvent> list = new ArrayList();
        EventQuery eq = new EventQuery();
        if (!CalendarUtils.isEmpty((String)taskStatus)) {
            eq.setState(taskStatus);
        }
        eq.setEventType(CalendarEvent.TYPE_TASK);
        eq.setFromDate(formDate);
        eq.setToDate(toDate);
        list = CalendarUtils.getCalendarService().getEvents(this.getSession(), CalendarUtils.getCurrentUser(), eq, null);
        return list;
    }

    private SessionProvider getSession() {
        return SessionProviderFactory.createSessionProvider();
    }

    private SessionProvider getSystemSession() {
        return SessionProviderFactory.createSystemProvider();
    }

    public void checkAll() {
        for (UIComponent cpm : this.getChildren()) {
            this.getUIFormCheckBoxInput(cpm.getId()).setChecked(true);
        }
    }

    protected List<GroupCalendarData> getPrivateCalendars() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List groupCalendars = calendarService.getCalendarCategories(this.getSession(), username, false);
        for (GroupCalendarData group : groupCalendars) {
            List calendars = group.getCalendars();
            if (calendars == null) continue;
            for (Calendar calendar : calendars) {
                this.colorMap_.put(0 + CalendarUtils.COLON + calendar.getId(), calendar.getCalendarColor());
                if (this.getUIFormCheckBoxInput(calendar.getId()) != null) continue;
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)false).setChecked(true));
            }
        }
        return groupCalendars;
    }

    protected List<GroupCalendarData> getPublicCalendars() throws Exception {
        String username = CalendarUtils.getCurrentUser();
        String[] groups = CalendarUtils.getUserGroups((String)username);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List groupCalendars = calendarService.getGroupCalendars(this.getSystemSession(), groups, false, username);
        HashMap<String, String> map = new HashMap<String, String>();
        for (GroupCalendarData group : groupCalendars) {
            List calendars = group.getCalendars();
            for (Calendar calendar : calendars) {
                map.put(calendar.getId(), calendar.getId());
                this.colorMap_.put(2 + CalendarUtils.COLON + calendar.getId(), calendar.getCalendarColor());
                if (this.getUIFormCheckBoxInput(calendar.getId()) != null) continue;
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)false).setChecked(true));
            }
        }
        this.publicCalendarIds = map.values().toArray(new String[0]);
        return groupCalendars;
    }

    protected GroupCalendarData getSharedCalendars() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        GroupCalendarData groupCalendars = calendarService.getSharedCalendars(this.getSystemSession(), CalendarUtils.getCurrentUser(), false);
        CalendarSetting setting = calendarService.getCalendarSetting(this.getSession(), CalendarUtils.getCurrentUser());
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : setting.getSharedCalendarsColors()) {
            map.put(key.split(CalendarUtils.COLON)[0], key.split(CalendarUtils.COLON)[1]);
        }
        if (groupCalendars != null) {
            List calendars = groupCalendars.getCalendars();
            for (Calendar calendar : calendars) {
                String color = (String)map.get(calendar.getId());
                if (color == null) {
                    color = calendar.getCalendarColor();
                }
                this.colorMap_.put(1 + CalendarUtils.COLON + calendar.getId(), color);
                if (this.getUIFormCheckBoxInput(calendar.getId()) != null) continue;
                this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)false).setChecked(true));
            }
        }
        return groupCalendars;
    }

    public LinkedHashMap<String, String> getColorMap() {
        return this.colorMap_;
    }

    public String[] getColors() {
        return Colors.COLORNAMES;
    }

    private boolean canAddTaskAndEvent(UICalendars uiComponent, String calendarId, String calType) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        Calendar calendar = null;
        String currentUser = CalendarUtils.getCurrentUser();
        if (calType.equals(CalendarUtils.SHARED_TYPE)) {
            calendar = calService.getSharedCalendars(this.getSystemSession(), currentUser, true).getCalendarById(calendarId);
            return calendar.getEditPermission() != null && CalendarUtils.canEdit(null, (String[])calendar.getEditPermission(), (String)currentUser);
        }
        if (calType.equals(CalendarUtils.PUBLIC_TYPE)) {
            calendar = calService.getGroupCalendar(this.getSystemSession(), calendarId);
            return calendar.getEditPermission() != null && CalendarUtils.canEdit((OrganizationService)((OrganizationService)uiComponent.getApplicationComponent(OrganizationService.class)), (String[])calendar.getEditPermission(), (String)currentUser);
        }
        return false;
    }

    public boolean canEdit(String[] savePerms) throws Exception {
        return CalendarUtils.canEdit((OrganizationService)CalendarUtils.getOrganizationService(), (String[])savePerms, (String)CalendarUtils.getCurrentUser());
    }

    static /* synthetic */ SessionProvider access$000(UICalendars x0) {
        return x0.getSession();
    }

    static /* synthetic */ SessionProvider access$100(UICalendars x0) {
        return x0.getSystemSession();
    }

    static /* synthetic */ boolean access$200(UICalendars x0, UICalendars x1, String x2, String x3) throws Exception {
        return x0.canAddTaskAndEvent(x1, x2, x3);
    }
}

