/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.Colors;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.calendar.webui.popup.UIImportForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIImportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ImportActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIImportForm
extends UIForm
implements UIPopupComponent {
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String CATEGORY = "category";
    public static final String SELECT_COLOR = "selectColor";
    public static final String TIMEZONE = "timeZone";
    public static final String LOCALE = "locale";
    public static final String TYPE = "type".intern();
    public static final String FIELD_UPLOAD = "upload".intern();
    public static final String FIELD_TO_CALENDAR = "impotTo".intern();
    public static final String ONCHANGE = "OnChange".intern();
    public static final int UPDATE_EXIST = 1;
    public static final int ADD_NEW = 0;
    protected int flag_ = -1;

    public UIImportForm() throws Exception {
        this.setMultiPart(true);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        for (String type : calendarService.getExportImportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
        this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD));
        UIFormSelectBox privateCal = new UIFormSelectBox(FIELD_TO_CALENDAR, FIELD_TO_CALENDAR, this.getPrivateCalendars());
        this.addUIFormInput((UIFormInput)privateCal);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(CATEGORY, CATEGORY, this.getCategory()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(LOCALE, LOCALE, this.getLocales()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIMEZONE, TIMEZONE, this.getTimeZones()));
        this.addUIFormInput((UIFormInput)new UIFormColorPicker(SELECT_COLOR, SELECT_COLOR, Colors.COLORS));
    }

    public void init(String calId, String calType) {
        if (!CalendarUtils.isEmpty((String)calId) && calType.equalsIgnoreCase(String.valueOf(0))) {
            UIFormSelectBox selectBox = this.getUIFormSelectBox(FIELD_TO_CALENDAR);
            if (selectBox.getOptions() != null && !selectBox.getOptions().isEmpty()) {
                this.switchMode(1);
                selectBox.setValue(calId);
            } else {
                this.switchMode(0);
            }
        } else {
            this.switchMode(0);
        }
    }

    private List<SelectItemOption<String>> getCategory() throws Exception {
        String username = CalendarUtils.getCurrentUser();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List categories = calendarService.getCategories(this.getSession(), username);
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (CalendarCategory category : categories) {
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    private SessionProvider getSession() {
        return SessionProviderFactory.createSessionProvider();
    }

    private SessionProvider getSystemSession() {
        return SessionProviderFactory.createSystemProvider();
    }

    private List<SelectItemOption<String>> getTimeZones() {
        return CalendarUtils.getTimeZoneSelectBoxOptions((String[])TimeZone.getAvailableIDs());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private List<SelectItemOption<String>> getLocales() {
        return CalendarUtils.getLocaleSelectBoxOptions((Locale[])java.util.Calendar.getAvailableLocales());
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<SelectItemOption<String>> getPrivateCalendars() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        try {
            for (Calendar c : CalendarUtils.getCalendarService().getUserCalendars(SessionProviderFactory.createSessionProvider(), CalendarUtils.getCurrentUser(), true)) {
                options.add((SelectItemOption<String>)new SelectItemOption(c.getName(), (Object)c.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public boolean isNew() {
        return this.flag_ == 0;
    }

    protected String getSelectedGroup() {
        return (String)this.getUIFormSelectBox(CATEGORY).getValue();
    }

    protected String getDescription() {
        return (String)this.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    protected String getTimeZone() {
        return (String)this.getUIFormSelectBox(TIMEZONE).getValue();
    }

    protected String getLocale() {
        return (String)this.getUIFormSelectBox(LOCALE).getValue();
    }

    public void switchMode(int flag) {
        this.flag_ = flag;
        if (flag == 1) {
            this.getUIFormSelectBox(FIELD_TO_CALENDAR).setRendered(true);
            this.getUIStringInput(DISPLAY_NAME).setRendered(false);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(false);
            this.getUIFormSelectBox(CATEGORY).setRendered(false);
            this.getUIFormSelectBox(TIMEZONE).setRendered(false);
            this.getUIFormSelectBox(LOCALE).setRendered(false);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(false);
        } else if (flag == 0) {
            this.getUIFormSelectBox(FIELD_TO_CALENDAR).setRendered(false);
            this.getUIStringInput(DISPLAY_NAME).setRendered(true);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(true);
            this.getUIFormSelectBox(CATEGORY).setRendered(true);
            this.getUIFormSelectBox(TIMEZONE).setRendered(true);
            this.getUIFormSelectBox(LOCALE).setRendered(true);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(true);
        } else {
            System.out.println("Wrong flag(" + flag + ") only UPDATE_EXIST(1) or ADD_NEW(0) accept ");
        }
    }
}

