/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIDayView;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIDayView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={SaveEventActionListener.class})})
public class UIDayView
extends UICalendarView {
    private Map<String, CalendarEvent> eventData_ = new HashMap();
    private Map<String, CalendarEvent> allDayEvent_ = new HashMap();

    public void refresh() throws Exception {
        this.eventData_.clear();
        this.allDayEvent_.clear();
        Calendar begin = this.getBeginDay(this.getCurrentCalendar());
        Calendar end = this.getEndDay(this.getCurrentCalendar());
        end.add(14, -1);
        List events = new ArrayList();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(begin);
        eventQuery.setToDate(end);
        events = calendarService.getEvents(this.getSystemSession(), username, eventQuery, this.getPublicCalendars());
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            CalendarEvent ce = (CalendarEvent)iter.next();
            long eventAmount = ce.getToDateTime().getTime() - ce.getFromDateTime().getTime();
            if (!this.isSameDate(ce.getFromDateTime(), this.getCurrentDate()) || !this.isSameDate(ce.getToDateTime(), this.getCurrentDate()) || eventAmount >= 84960000L) continue;
            this.eventData_.put(ce.getId(), ce);
            iter.remove();
        }
        for (CalendarEvent ce : events) {
            this.allDayEvent_.put(ce.getId(), ce);
        }
    }

    protected Map<String, CalendarEvent> getEventData() {
        return this.eventData_;
    }

    protected Map<String, CalendarEvent> getAllDayEvents() {
        return this.allDayEvent_;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        LinkedHashMap<String, CalendarEvent> dataMap = new LinkedHashMap<String, CalendarEvent>();
        dataMap.putAll(this.eventData_);
        dataMap.putAll(this.allDayEvent_);
        return dataMap;
    }

    static /* synthetic */ Map access$000(UIDayView x0) {
        return x0.eventData_;
    }
}

