/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIRssForm;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={GenerateRssActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIRssForm
extends UIFormTabPane
implements UIPopupComponent {
    private static final String URL = "url".intern();
    private static final String DESCRIPTION = "description".intern();
    private static final String LINK = "link".intern();
    private static final String COPYRIGHT = "copyright".intern();
    private static final String TITLE = "title".intern();
    private static final String PUBLIC_DATE = "pubDate".intern();
    private static final String INFOR = "info".intern();
    private static final String MESSAGE = "message".intern();
    private static final String DESCRIPTIONS = "descriptions".intern();
    private static final String COPYRIGHTS = "copyrights".intern();
    private static final String INPUT_RSSINFO = "rssInfo".intern();
    private static final String INPUT_RSSCAL = "rssCalendars".intern();

    public UIRssForm() throws Exception {
        super("UIRssForm");
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        UIFormInputWithActions rssInfo = new UIFormInputWithActions(INPUT_RSSINFO);
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(TITLE, TITLE, "eXoCalendar").addValidator(MandatoryValidator.class, new Object[0]));
        String url = calendarService.getCalendarSetting(SessionProviderFactory.createSessionProvider(), username).getBaseURL();
        if (CalendarUtils.isEmpty((String)url)) {
            url = CalendarUtils.getServerBaseUrl() + "calendar/iCalRss";
        }
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(URL, URL, url).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(COPYRIGHT, COPYRIGHT, null).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(LINK, LINK, null).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormDateTimePicker(PUBLIC_DATE, PUBLIC_DATE, new Date(), false));
        this.setSelectedTab(rssInfo.getId());
        this.addUIFormInput((UIFormInputSet)rssInfo);
        UIFormInputWithActions rssCalendars = new UIFormInputWithActions(INPUT_RSSCAL);
        rssCalendars.addUIFormInput((UIFormInput)new UIFormInputInfo(INFOR, INFOR, null));
        List calendars = calendarService.getUserCalendars(SessionProviderFactory.createSessionProvider(), username, true);
        for (Calendar calendar : calendars) {
            rssCalendars.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getName(), calendar.getId(), (Object)true));
        }
        this.addUIFormInput((UIFormInputSet)rssCalendars);
    }

    public void init() throws Exception {
        UIFormInputWithActions rssInfo = (UIFormInputWithActions)this.getChildById(INPUT_RSSINFO);
        rssInfo.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)this.getLabel(DESCRIPTIONS));
        rssInfo.getUIStringInput(COPYRIGHT).setValue((Object)this.getLabel(COPYRIGHTS));
        rssInfo.getUIStringInput(LINK).setValue((Object)this.getLabel(LINK + "-" + URL));
        UIFormInputWithActions rssTab = (UIFormInputWithActions)this.getChildById(INPUT_RSSCAL);
        rssTab.getUIFormInputInfo(INFOR).setValue((Object)this.getLabel(MESSAGE));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private UIFormDateTimePicker getUIDateTimePicker(String id) {
        UIFormInputWithActions rssInfo = (UIFormInputWithActions)this.getChildById(INPUT_RSSINFO);
        return (UIFormDateTimePicker)rssInfo.getChildById(id);
    }

    static /* synthetic */ String access$000() {
        return INPUT_RSSCAL;
    }

    static /* synthetic */ String access$100() {
        return TITLE;
    }

    static /* synthetic */ String access$200() {
        return INPUT_RSSINFO;
    }

    static /* synthetic */ String access$300() {
        return URL;
    }

    static /* synthetic */ String access$400() {
        return DESCRIPTION;
    }

    static /* synthetic */ String access$500() {
        return COPYRIGHT;
    }

    static /* synthetic */ String access$600() {
        return LINK;
    }

    static /* synthetic */ String access$700() {
        return PUBLIC_DATE;
    }

    static /* synthetic */ UIFormDateTimePicker access$800(UIRssForm x0, String x1) {
        return x0.getUIDateTimePicker(x1);
    }
}

