/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.webui.popup.UIInvitationForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.organization.account.UIGroupSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIInvitationForm.gtmpl", events={@EventConfig(listeners={AddUserParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddGroupParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddContactParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowUserSelectEventForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIInvitationForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_PARTICIPANT = "participant".intern();
    public static final String FIELD_INVITATION_MSG = "invitation-msg".intern();
    public static final String TOOLTIP_CONTACT = "contact-picker".intern();
    public static final String TOOLTIP_USER = "user-picker".intern();
    public static final String TOOLTIP_GROUP = "group-picker".intern();
    protected CalendarEvent event_;

    protected UIForm getParentFrom() {
        return this;
    }

    public UIInvitationForm() throws Exception {
        this.setId("UIInvitationForm");
        String defaul_msg = "default-invitation-msg";
        try {
            defaul_msg = this.getLabel("default-invitation-msg");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_PARTICIPANT, FIELD_PARTICIPANT, null));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_INVITATION_MSG, FIELD_INVITATION_MSG, defaul_msg));
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PUIPopupGroupSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupSelector uiGroup = (UIGroupSelector)this.createUIComponent(UIGroupSelector.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiGroup);
        uiGroup.setId("PGroupSelector");
        ((UITree)uiGroup.getChild(UITree.class)).setId("PTreeGroupSelector");
        ((UIBreadcumbs)uiGroup.getChild(UIBreadcumbs.class)).setId("PBreadcumbsGroupSelector");
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public String appendValue(String oldValue, String newValue) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (!CalendarUtils.isEmpty((String)oldValue)) {
            oldValue = oldValue.replaceAll(CalendarUtils.COMMA, CalendarUtils.BREAK_LINE);
            oldValue = oldValue.replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.BREAK_LINE);
            for (String s : oldValue.split(CalendarUtils.BREAK_LINE)) {
                map.put(s + CalendarUtils.BREAK_LINE, s + CalendarUtils.BREAK_LINE);
            }
        }
        if (newValue.indexOf(CalendarUtils.COMMA) > -1) {
            for (String s : newValue.split(CalendarUtils.COMMA)) {
                map.put(s + CalendarUtils.BREAK_LINE, s + CalendarUtils.BREAK_LINE);
            }
        } else if (newValue.indexOf(CalendarUtils.SEMICOLON) > -1) {
            for (String s : newValue.split(CalendarUtils.SEMICOLON)) {
                map.put(s + CalendarUtils.BREAK_LINE, s + CalendarUtils.BREAK_LINE);
            }
        } else {
            map.put(newValue + CalendarUtils.BREAK_LINE, newValue + CalendarUtils.BREAK_LINE);
        }
        StringBuffer sb = new StringBuffer("");
        for (String s : map.values()) {
            sb.append(s);
        }
        return sb.toString();
    }

    public String getParticipantValue() {
        return (String)this.getUIFormTextAreaInput(FIELD_PARTICIPANT).getValue();
    }

    public void setParticipantValue(String value) {
        this.getUIFormTextAreaInput(FIELD_PARTICIPANT).setValue((Object)value);
    }

    public String getInvitationMsg() {
        return (String)this.getUIFormTextAreaInput(FIELD_INVITATION_MSG).getValue();
    }

    public void setInvitationMsg(String value) {
        this.getUIFormTextAreaInput(FIELD_INVITATION_MSG).setValue((Object)value);
    }

    public String getUserList(String parList) {
        StringBuilder builder = new StringBuilder("");
        ArrayList<String> pars = new ArrayList<String>();
        pars.addAll(Arrays.asList(parList.split(CalendarUtils.BREAK_LINE)));
        for (String par : pars) {
            if ((par = par.trim()).contains("@")) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(par);
        }
        return builder.toString();
    }

    public String getEmailList(String parList) {
        StringBuilder builder = new StringBuilder("");
        ArrayList<String> pars = new ArrayList<String>();
        pars.addAll(Arrays.asList(parList.split(CalendarUtils.BREAK_LINE)));
        for (String par : pars) {
            if (!(par = par.trim()).contains("@")) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(par);
        }
        return builder.toString();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

