/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UIAdvancedSearchForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAdvancedSearchForm
extends UIForm
implements UIPopupComponent {
    private static final String TEXT = "text";
    private static final String TYPE = "type";
    private static final String CALENDAR = "calendar";
    private static final String CATEGORY = "category";
    private static final String PRIORITY = "priority";
    private static final String STATE = "state";
    private static final String FROMDATE = "fromDate";
    private static final String TODATE = "toDate";

    public UIAdvancedSearchForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(TEXT, TEXT, ""));
        ArrayList<SelectItemOption> types = new ArrayList<SelectItemOption>();
        types.add(new SelectItemOption("", (Object)""));
        types.add(new SelectItemOption(CalendarEvent.TYPE_EVENT, (Object)CalendarEvent.TYPE_EVENT));
        types.add(new SelectItemOption(CalendarEvent.TYPE_TASK, (Object)CalendarEvent.TYPE_TASK));
        UIFormSelectBox type = new UIFormSelectBox(TYPE, TYPE, types);
        type.setOnChange("Onchange");
        this.addChild((UIComponent)type);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        String username = CalendarUtils.getCurrentUser();
        CalendarService cservice = CalendarUtils.getCalendarService();
        options.add(new SelectItemOption("", (Object)""));
        for (Calendar cal : cservice.getUserCalendars(username, true)) {
            options.add(new SelectItemOption(cal.getName(), (Object)(0 + CalendarUtils.COLON + cal.getId())));
        }
        List groupCals = cservice.getGroupCalendars(CalendarUtils.getUserGroups((String)username), true, username);
        for (GroupCalendarData groupData : groupCals) {
            if (groupData == null) continue;
            for (Calendar cal : groupData.getCalendars()) {
                options.add(new SelectItemOption(cal.getName(), (Object)(2 + CalendarUtils.COLON + cal.getId())));
            }
        }
        GroupCalendarData sharedData = cservice.getSharedCalendars(CalendarUtils.getCurrentUser(), true);
        if (sharedData != null) {
            for (Calendar cal : sharedData.getCalendars()) {
                String owner = "";
                if (cal.getCalendarOwner() != null) {
                    owner = cal.getCalendarOwner() + "- ";
                }
                options.add(new SelectItemOption(owner + cal.getName(), (Object)(1 + CalendarUtils.COLON + cal.getId())));
            }
        }
        this.addChild((UIComponent)new UIFormSelectBox(CALENDAR, CALENDAR, options));
        options = new ArrayList();
        options.add(new SelectItemOption("", (Object)""));
        for (EventCategory cat : cservice.getEventCategories(CalendarUtils.getCurrentUser())) {
            options.add(new SelectItemOption(cat.getName(), (Object)cat.getId()));
        }
        this.addChild((UIComponent)new UIFormSelectBox(CATEGORY, CATEGORY, options));
        this.addChild(new UIFormSelectBox(STATE, STATE, this.getStatus()).setRendered(false));
        this.addChild((UIComponent)new UIFormSelectBox(PRIORITY, PRIORITY, this.getPriority()));
        this.addChild((UIComponent)new UIFormDateTimePicker(FROMDATE, FROMDATE, null, false));
        this.addChild((UIComponent)new UIFormDateTimePicker(TODATE, TODATE, null, false));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setSearchValue(String searchValue) {
        this.getUIStringInput(TEXT).setValue((Object)searchValue);
    }

    public UIFormDateTimePicker getUIFormDateTimePicker(String id) {
        return (UIFormDateTimePicker)this.findComponentById(id);
    }

    public String getFromDateValue() {
        return (String)this.getUIFormDateTimePicker(FROMDATE).getValue();
    }

    public String getToDateValue() {
        return (String)this.getUIFormDateTimePicker(TODATE).getValue();
    }

    public Date getFromDate() {
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        if (this.getFromDateValue() != null) {
            try {
                return df.parse(this.getFromDateValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Date getToDate() {
        SimpleDateFormat df = new SimpleDateFormat(CalendarUtils.DATEFORMAT);
        df.setCalendar(CalendarUtils.getInstanceTempCalendar());
        if (this.getToDateValue() != null) {
            try {
                return df.parse(this.getToDateValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private List<SelectItemOption<String>> getPriority() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("", (Object)""));
        options.add(new SelectItemOption("normal", (Object)"normal"));
        options.add(new SelectItemOption("high", (Object)"high"));
        options.add(new SelectItemOption("low", (Object)"low"));
        return options;
    }

    private List<SelectItemOption<String>> getStatus() {
        ArrayList<SelectItemOption<String>> status = new ArrayList<SelectItemOption<String>>();
        status.add(new SelectItemOption("", (Object)""));
        for (String taskStatus : CalendarEvent.TASK_STATUS) {
            status.add((SelectItemOption<String>)new SelectItemOption(taskStatus, (Object)taskStatus));
        }
        return status;
    }

    public String[] getPublicCalendars() throws Exception {
        String[] groups = CalendarUtils.getUserGroups((String)CalendarUtils.getCurrentUser());
        CalendarService calendarService = CalendarUtils.getCalendarService();
        HashMap<String, String> map = new HashMap<String, String>();
        for (GroupCalendarData group : calendarService.getGroupCalendars(groups, true, CalendarUtils.getCurrentUser())) {
            for (Calendar calendar : group.getCalendars()) {
                map.put(calendar.getId(), calendar.getId());
            }
        }
        return map.values().toArray(new String[map.values().size()]);
    }

    private SessionProvider getSession() {
        return SessionProviderFactory.createSessionProvider();
    }

    private SessionProvider getSystemSession() {
        return SessionProviderFactory.createSystemProvider();
    }

    public boolean isSearchTask() {
        return ((String)this.getUIFormSelectBox(TYPE).getValue()).equals(CalendarEvent.TYPE_TASK);
    }

    public String getTaskState() {
        return (String)this.getUIFormSelectBox(STATE).getValue();
    }

    public String[] getActions() {
        return new String[]{"Search", "Cancel"};
    }

    public Boolean isValidate() {
        String value = (String)this.getUIStringInput(TEXT).getValue();
        if (value == null) {
            value = "";
        }
        String formData = "";
        formData = formData + value;
        formData = formData + (String)this.getUIFormSelectBox(TYPE).getValue();
        formData = formData + (String)this.getUIFormSelectBox(CALENDAR).getValue();
        formData = formData + (String)this.getUIFormSelectBox(CATEGORY).getValue();
        formData = formData + (String)this.getUIFormSelectBox(PRIORITY).getValue();
        formData = formData + this.getFromDateValue();
        return !CalendarUtils.isEmpty((String)(formData = formData + this.getToDateValue()));
    }
}

