/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.Writer;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.popup.UIEventCategoryForm;
import org.exoplatform.calendar.webui.popup.UIEventCategoryManager;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIEventCategoryManager.msg.confirm-delete")})
public class UIEventCategoryManager
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"name"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};
    public String categoryId_;

    public UIEventCategoryManager() throws Exception {
        this.setName("UIEventCategoryManager");
        UIGrid categoryList = (UIGrid)this.addChild(UIGrid.class, null, "UIEventCategoryList");
        categoryList.configure("id", BEAN_FIELD, ACTION);
        categoryList.getUIPageIterator().setId("EventCategoryIterator");
        this.addChild(UIEventCategoryForm.class, null, null);
        this.updateGrid();
    }

    public long getCurrentPage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage();
    }

    public long getAvailablePage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getAvailablePage();
    }

    public void setCurrentPage(int page) throws Exception {
        ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().setCurrentPage(page);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void resetForm() {
        ((UIEventCategoryForm)this.getChild(UIEventCategoryForm.class)).reset();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<div id=\"UIEventCategoryManager\" class=\"UIEventCategoryManager\">");
        this.renderChildren();
        w.write("</div>");
    }

    public void updateGrid() throws Exception {
        CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
        String username = CalendarUtils.getCurrentUser();
        List categories = calService.getEventCategories(username);
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(categories, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    private SessionProvider getSession() {
        return SessionProviderFactory.createSessionProvider();
    }
}

