/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMiniCalendar.gtmpl", events={@EventConfig(listeners={MoveNextActionListener.class}), @EventConfig(listeners={MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class})})
public class UIMiniCalendar
extends UICalendarView {
    private Map<Integer, String> dataMap = new HashMap();
    private String categoryId_ = null;

    public UIMiniCalendar() throws Exception {
        this.updateMiniCal();
    }

    public void updateMiniCal() throws Exception {
        this.dataMap.clear();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonth());
        eventQuery.setToDate(this.getEndDateOfMonth());
        CalendarService calendarService = CalendarUtils.getCalendarService();
        this.dataMap = calendarService.searchHightLightEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars());
    }

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    private Map<Integer, String> getData() {
        return this.dataMap;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return null;
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(1);
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(1);
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.setFirstDayOfWeek(1);
        temCal.set(5, 1);
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.setFirstDayOfWeek(1);
        temCal.set(5, this.getDaysInMonth());
        return CalendarUtils.getEndDay((Calendar)temCal);
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public void refresh() throws Exception {
        this.dataMap.clear();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonth());
        Calendar cal = this.getEndDateOfMonth();
        cal.add(14, -1);
        eventQuery.setToDate(cal);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        this.dataMap = calendarService.searchHightLightEvent(CalendarUtils.getCurrentUser(), eventQuery, this.getPublicCalendars());
    }
}

