/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.popup.UICalendarSettingDisplayTab;
import org.exoplatform.calendar.webui.popup.UICalendarSettingForm;
import org.exoplatform.calendar.webui.popup.UICalendarSettingTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormTabPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ChangeLocaleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowAllTimeZoneActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalendarSettingForm
extends UIFormTabPane
implements UIPopupComponent {
    private static final String SETTING_CALENDAR_TAB = "setting".intern();
    private static final String DEFAULT_CALENDAR_TAB = "defaultCalendarTab".intern();
    private static final String DEFAULT_CALENDARS = "defaultCalendars".intern();
    private static final String DEFAULT_CALENDARS_NOTE = "note".intern();
    private Map<String, String> names_ = new HashMap();
    public String[] sharedCalendarColors_ = null;

    public UICalendarSettingForm() throws Exception {
        super("UICalendarSettingForm");
        UICalendarSettingTab setting = new UICalendarSettingTab(SETTING_CALENDAR_TAB);
        this.addUIFormInput((UIFormInputSet)setting);
        this.setSelectedTab(setting.getId());
        UICalendarSettingDisplayTab defaultCalendarsTab = new UICalendarSettingDisplayTab(DEFAULT_CALENDAR_TAB);
        this.addUIFormInput((UIFormInputSet)defaultCalendarsTab);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Map<String, String> getChildIds() {
        return this.names_;
    }

    public void init(CalendarSetting calendarSetting, CalendarService cservice) throws Exception {
        List publicCals;
        List sharedCals;
        this.names_.clear();
        String username = CalendarUtils.getCurrentUser();
        if (calendarSetting != null) {
            this.sharedCalendarColors_ = calendarSetting.getSharedCalendarsColors();
            UICalendarSettingTab settingTab = (UICalendarSettingTab)this.getChildById(SETTING_CALENDAR_TAB);
            settingTab.setViewType(calendarSetting.getViewType());
            settingTab.setTimeInterval(String.valueOf(calendarSetting.getTimeInterval()));
            settingTab.setWeekStartOn(calendarSetting.getWeekStartOn());
            settingTab.setDateFormat(calendarSetting.getDateFormat());
            settingTab.setTimeFormat(calendarSetting.getTimeFormat());
            settingTab.getUIFormSelectBox(UICalendarSettingTab.WORKINGTIME_BEGIN).setOptions(CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (int)30));
            settingTab.getUIFormSelectBox(UICalendarSettingTab.WORKINGTIME_END).setOptions(CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (int)30));
            if (calendarSetting.getLocation() == null) {
                calendarSetting.setLocation(Util.getPortalRequestContext().getLocale().getISO3Country());
            }
            settingTab.setLocale(calendarSetting.getLocation());
            settingTab.setTimeZone(calendarSetting.getTimeZone());
            settingTab.setShowWorkingTimes(calendarSetting.isShowWorkingTime());
            if (calendarSetting.isShowWorkingTime()) {
                settingTab.setWorkingBegin(calendarSetting.getWorkingTimeBegin(), CalendarUtils.DATEFORMAT + " " + calendarSetting.getTimeFormat());
                settingTab.setWorkingEnd(calendarSetting.getWorkingTimeEnd(), CalendarUtils.DATEFORMAT + " " + calendarSetting.getTimeFormat());
            }
            settingTab.setSendOption(calendarSetting.getSendOption());
            if (calendarSetting.getBaseURL() == null) {
                calendarSetting.setBaseURL(CalendarUtils.getServerBaseUrl() + "calendar/iCalRss");
            }
        }
        UICalendarSettingDisplayTab defaultCalendarsTab = (UICalendarSettingDisplayTab)this.getChildById(DEFAULT_CALENDAR_TAB);
        ArrayList<String> filteredCalendars = new ArrayList<String>();
        if (calendarSetting != null && calendarSetting.getFilterPrivateCalendars() != null) {
            filteredCalendars.addAll(Arrays.asList(calendarSetting.getFilterPrivateCalendars()));
        }
        if (calendarSetting != null && calendarSetting.getFilterPublicCalendars() != null) {
            filteredCalendars.addAll(Arrays.asList(calendarSetting.getFilterPublicCalendars()));
        }
        if (calendarSetting != null && calendarSetting.getFilterSharedCalendars() != null) {
            filteredCalendars.addAll(Arrays.asList(calendarSetting.getFilterSharedCalendars()));
        }
        List privateCals = this.getPrivateCalendars(cservice, username);
        defaultCalendarsTab.addChild((UIComponent)new UIFormInputInfo(DEFAULT_CALENDARS, DEFAULT_CALENDARS, this.getLabel(DEFAULT_CALENDARS_NOTE)));
        if (privateCals != null && !privateCals.isEmpty()) {
            defaultCalendarsTab.addChild((UIComponent)new UIFormInputInfo(CalendarUtils.PRIVATE_CALENDARS, CalendarUtils.PRIVATE_CALENDARS, null));
            for (Calendar calendar : privateCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                UIFormCheckBoxInput checkBox = (UIFormCheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox == null) {
                    checkBox = new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)true);
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(true);
            }
        }
        if ((sharedCals = this.getSharedCalendars(cservice, username)) != null && !sharedCals.isEmpty()) {
            defaultCalendarsTab.addChild((UIComponent)new UIFormInputInfo(CalendarUtils.SHARED_CALENDARS, CalendarUtils.SHARED_CALENDARS, null));
            for (Calendar calendar : sharedCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                UIFormCheckBoxInput checkBox = (UIFormCheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox == null) {
                    checkBox = new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)true);
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(true);
            }
        }
        if ((publicCals = this.getPublicCalendars(cservice, username)) != null && !publicCals.isEmpty()) {
            defaultCalendarsTab.addChild((UIComponent)new UIFormInputInfo(CalendarUtils.PUBLIC_CALENDARS, CalendarUtils.PUBLIC_CALENDARS, null));
            for (Calendar calendar : publicCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                UIFormCheckBoxInput checkBox = (UIFormCheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox == null) {
                    checkBox = new UIFormCheckBoxInput(calendar.getId(), calendar.getId(), (Object)true);
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(true);
            }
        }
        for (String calId : filteredCalendars) {
            UIFormCheckBoxInput input = (UIFormCheckBoxInput)defaultCalendarsTab.getChildById(calId);
            if (input == null) continue;
            input.setChecked(false);
        }
    }

    protected List<Calendar> getPrivateCalendars(CalendarService calendarService, String username) throws Exception {
        boolean showAll = true;
        List groupCalendars = calendarService.getCalendarCategories(username, showAll);
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        for (GroupCalendarData group : groupCalendars) {
            for (Calendar calendar : group.getCalendars()) {
                if (calendar.getId().equals(Utils.getDefaultCalendarId((String)username)) && calendar.getName().equals("defaultCalendarName")) {
                    String newName = CalendarUtils.getResourceBundle((String)"UICalendars.label.defaultCalendarId");
                    calendar.setName(newName);
                }
                calendars.add(calendar);
            }
        }
        return calendars;
    }

    protected List<Calendar> getPublicCalendars(CalendarService calendarService, String username) throws Exception {
        String[] groups = CalendarUtils.getUserGroups((String)username);
        List groupCalendars = calendarService.getGroupCalendars(groups, true, CalendarUtils.getCurrentUser());
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        for (GroupCalendarData group : groupCalendars) {
            calendars.addAll(group.getCalendars());
        }
        return calendars;
    }

    protected List<Calendar> getSharedCalendars(CalendarService calendarService, String username) throws Exception {
        GroupCalendarData groupCalendars = calendarService.getSharedCalendars(username, true);
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        if (groupCalendars != null) {
            for (Calendar calendar : groupCalendars.getCalendars()) {
                if (calendar.getId().equals(Utils.getDefaultCalendarId((String)calendar.getCalendarOwner())) && calendar.getName().equals("defaultCalendarName")) {
                    String newName = CalendarUtils.getResourceBundle((String)"UICalendars.label.defaultCalendarId");
                    calendar.setName(newName);
                }
                calendars.add(calendar);
            }
        }
        return calendars;
    }

    public String getLabel(ResourceBundle res, String id) {
        if (this.names_.get(id) != null) {
            return (String)this.names_.get(id);
        }
        String label = this.getId() + ".label." + id;
        return res.getString(label);
    }

    public String getLabel(String id) {
        String label = id;
        try {
            label = super.getLabel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return label;
    }

    protected List<String> getUnCheckedList(List<Calendar> calendars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Calendar cal : calendars) {
            UIFormCheckBoxInput input = (UIFormCheckBoxInput)((UIFormInputWithActions)this.getChildById(DEFAULT_CALENDAR_TAB)).getChildById(cal.getId());
            if (input == null || input.isChecked()) continue;
            list.add(input.getId());
        }
        return list;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    static /* synthetic */ String access$000() {
        return SETTING_CALENDAR_TAB;
    }
}

