/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelectComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.calendar.webui.popup.UISharedForm;
import org.exoplatform.calendar.webui.popup.UISharedTab;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.NameValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class})}), @ComponentConfig(id="UIPopupWindowUserSelect", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UISharedForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String[] SPECIALCHARACTER = new String[]{CalendarUtils.SEMICOLON, CalendarUtils.SLASH, CalendarUtils.BACKSLASH, "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*"};
    public static final String SHARED_TAB = "UIInputUserSelect".intern();
    private Map<String, String> permission_ = new HashMap();
    private String calendarId_;
    protected boolean isAddNew_ = true;

    public UISharedForm() throws Exception {
        UISharedTab inputset = new UISharedTab(SHARED_TAB);
        inputset.addChild((UIComponent)new UIFormInputInfo(UISharedTab.FIELD_NAME, UISharedTab.FIELD_NAME, null));
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(UISharedTab.FIELD_USER, UISharedTab.FIELD_USER, null).addValidator(NameValidator.class, new Object[0]));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setCssIconClass("SelectUserIcon");
        selectUserAction.setActionType(0);
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER);
        actions.add(selectUserAction);
        inputset.setActionField(UISharedTab.FIELD_USER, actions);
        inputset.addChild((UIComponent)new UIFormCheckBoxInput(UISharedTab.FIELD_EDIT, UISharedTab.FIELD_EDIT, null));
        this.addChild((UIComponent)inputset);
    }

    public void init(String username, Calendar cal, boolean isAddNew) {
        this.isAddNew_ = isAddNew;
        this.calendarId_ = cal.getId();
        this.setCalendarName(cal.getName());
        boolean canEdit = false;
        if (cal.getEditPermission() != null) {
            canEdit = Arrays.asList(cal.getEditPermission()).contains(username);
        }
        this.setCanEdit(canEdit);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setSelectedCalendarId(String id) {
        this.calendarId_ = id;
    }

    public void setCalendarName(String value) {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        inputset.calendarName_ = value;
        if (!CalendarUtils.isEmpty((String)value) && value.trim().length() > 30) {
            value = value.substring(0, 30) + "...";
        }
        inputset.getUIFormInputInfo(UISharedTab.FIELD_NAME).setValue((Object)value);
    }

    protected void setCanEdit(boolean canEdit) {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        inputset.getUIFormCheckBoxInput(UISharedTab.FIELD_EDIT).setChecked(canEdit);
    }

    protected boolean canEdit() {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        return inputset.getUIFormCheckBoxInput(UISharedTab.FIELD_EDIT).isChecked();
    }

    protected void setSharedUser(String value) {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        inputset.getUIStringInput(UISharedTab.FIELD_USER).setValue((Object)value);
    }

    protected String getSharedUser() {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        return (String)inputset.getUIStringInput(UISharedTab.FIELD_USER).getValue();
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String cleanValue(String values) throws Exception {
        String[] tmpArr = values.split(",");
        List<String> list = Arrays.asList(tmpArr);
        HashSet<String> set = new HashSet<String>(list);
        String[] result = new String[set.size()];
        set.toArray(result);
        String data2 = "";
        for (String s : result) {
            data2 = data2 + "," + s;
        }
        data2 = data2.substring(1);
        return data2;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UISharedTab inputset = (UISharedTab)this.getChildById(SHARED_TAB);
        UIFormStringInput fieldInput = inputset.getUIStringInput(selectField);
        this.permission_.put(value.substring(value.lastIndexOf(":/") + 2), value.substring(value.lastIndexOf(":/") + 2));
        StringBuilder sb = new StringBuilder();
        for (String s : this.permission_.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ String access$000(UISharedForm x0) {
        return x0.calendarId_;
    }

    static /* synthetic */ Map access$100(UISharedForm x0) {
        return x0.permission_;
    }
}

