/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UICalDavForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={GenerateActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalDavForm
extends UIFormTabPane
implements UIPopupComponent {
    private static final String URL = "url".intern();
    private static final String DESCRIPTION = "description".intern();
    private static final String COPYRIGHT = "copyright".intern();
    private static final String TITLE = "title".intern();
    private static final String PUBLIC_DATE = "pubDate".intern();
    private static final String INFOR = "info".intern();
    private static final String MESSAGE = "message".intern();
    private static final String DESCRIPTIONS = "descriptions".intern();
    private static final String COPYRIGHTS = "copyrights".intern();
    private static final String INFO_TAB = "rssInfo".intern();
    private static final String CALENDAR_TAB = "rssCalendars".intern();
    private LinkedHashMap<String, Calendar> userCals_ = new LinkedHashMap();
    private LinkedHashMap<String, Calendar> sharedCals_ = new LinkedHashMap();
    private LinkedHashMap<String, Calendar> publicCals_ = new LinkedHashMap();

    public UICalDavForm() throws Exception {
        super("UICalDavForm");
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        UIFormInputWithActions rssInfo = new UIFormInputWithActions(INFO_TAB);
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(TITLE, TITLE, "eXoCalendarCalDav").addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        String url = calendarService.getCalendarSetting(username).getBaseURL();
        if (CalendarUtils.isEmpty((String)url)) {
            url = CalendarUtils.getServerBaseUrl() + "calendar/iCalRss";
        }
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(URL, URL, url).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormStringInput(COPYRIGHT, COPYRIGHT, null).addValidator(MandatoryValidator.class, new Object[0]));
        rssInfo.addUIFormInput((UIFormInput)new UIFormDateTimePicker(PUBLIC_DATE, PUBLIC_DATE, new Date(), false));
        this.setSelectedTab(rssInfo.getId());
        this.addUIFormInput((UIFormInputSet)rssInfo);
    }

    public void init(List<Calendar> userCals, List<Calendar> sharedCals, List<Calendar> publicCals) throws Exception {
        UIFormInputWithActions rssCalendars = new UIFormInputWithActions(CALENDAR_TAB);
        UIFormInputInfo formInputInfo = new UIFormInputInfo(INFOR, INFOR, null);
        formInputInfo.setValue((Object)this.getLabel(MESSAGE));
        rssCalendars.addUIFormInput((UIFormInput)formInputInfo);
        for (Calendar calendar : userCals) {
            this.userCals_.put(calendar.getId(), calendar);
            rssCalendars.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getName(), calendar.getId(), (Object)true));
        }
        for (Calendar calendar : sharedCals) {
            this.sharedCals_.put(calendar.getId(), calendar);
            rssCalendars.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getCalendarOwner() + "- " + calendar.getName(), calendar.getId(), (Object)true));
        }
        for (Calendar calendar : publicCals) {
            this.publicCals_.put(calendar.getId(), calendar);
            rssCalendars.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(calendar.getName(), calendar.getId(), (Object)true));
        }
        this.addUIFormInput((UIFormInputSet)rssCalendars);
        UIFormInputWithActions rssInfo = (UIFormInputWithActions)this.getChildById(INFO_TAB);
        rssInfo.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)this.getLabel(DESCRIPTIONS));
        rssInfo.getUIStringInput(COPYRIGHT).setValue((Object)this.getLabel(COPYRIGHTS));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getWebDAVServerPrefix() throws Exception {
        String prefixWebDAV = CalendarUtils.getServerBaseUrl() + this.getPortalName() + "/rest/private/jcr/" + this.getRepository().getConfiguration().getName() + "/" + this.getWorkspaceName();
        return prefixWebDAV;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getWorkspaceName() throws Exception {
        return this.getRepository().getConfiguration().getDefaultWorkspaceName();
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    private UIFormDateTimePicker getUIDateTimePicker(String id) {
        UIFormInputWithActions rssInfo = (UIFormInputWithActions)this.getChildById("rssInfo");
        return (UIFormDateTimePicker)rssInfo.getChildById(id);
    }

    public String[] getActions() {
        return new String[]{"Generate", "Cancel"};
    }

    static /* synthetic */ String access$000() {
        return CALENDAR_TAB;
    }

    static /* synthetic */ String access$100() {
        return TITLE;
    }

    static /* synthetic */ String access$200() {
        return URL;
    }

    static /* synthetic */ String access$300() {
        return DESCRIPTION;
    }

    static /* synthetic */ String access$400() {
        return COPYRIGHT;
    }

    static /* synthetic */ String access$500() {
        return PUBLIC_DATE;
    }

    static /* synthetic */ UIFormDateTimePicker access$600(UICalDavForm x0, String x1) {
        return x0.getUIDateTimePicker(x1);
    }

    static /* synthetic */ LinkedHashMap access$700(UICalDavForm x0) {
        return x0.userCals_;
    }

    static /* synthetic */ LinkedHashMap access$800(UICalDavForm x0) {
        return x0.sharedCals_;
    }

    static /* synthetic */ LinkedHashMap access$900(UICalDavForm x0) {
        return x0.publicCals_;
    }
}

