/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.webui.popup.UICalendarCategoryForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalendarCategoryForm
extends UIForm {
    static final String CATEGORY_NAME = "categoryName";
    static final String DESCRIPTION = "description";
    private boolean isAddNew = true;
    private String categoryId = null;

    public UICalendarCategoryForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CATEGORY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
    }

    public void reset() {
        super.reset();
        this.isAddNew = true;
        this.categoryId = null;
    }

    public void init(String categoryId) throws Exception {
        this.setAddNew(false);
        CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
        String username = CalendarUtils.getCurrentUser();
        CalendarCategory category = calService.getCalendarCategory(username, categoryId);
        if (category.getId().equals("defaultCalendarCategoryId") && category.getName().equals("defaultCalendarCategoryName")) {
            String newName = CalendarUtils.getResourceBundle((String)"UICalendars.label.defaultCalendarCategoryId");
            category.setName(newName);
        }
        this.setCategoryId(category.getId());
        this.setCategoryName(category.getName());
        this.setCategoryDescription(category.getDescription());
    }

    protected void setAddNew(boolean isAddNew) {
        this.isAddNew = isAddNew;
    }

    protected boolean isAddNew() {
        return this.isAddNew;
    }

    protected void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    protected String getCategoryId() {
        return this.categoryId;
    }

    protected String getCategoryName() {
        return (String)this.getUIStringInput(CATEGORY_NAME).getValue();
    }

    protected void setCategoryName(String value) {
        this.getUIStringInput(CATEGORY_NAME).setValue((Object)value);
    }

    protected String getCategoryDescription() {
        return (String)this.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected void setCategoryDescription(String value) {
        this.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)value);
    }
}

