/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.HashMap;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.UISearchForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UISearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UISearchForm
extends UIForm {
    private static final String FIELD_SEARCHVALUE = "value";

    public UISearchForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SEARCHVALUE, FIELD_SEARCHVALUE, null).addValidator(SpecialCharacterValidator.class, new Object[0]));
    }

    public String getSearchValue() {
        return (String)this.getUIStringInput(FIELD_SEARCHVALUE).getValue();
    }

    public String[] getPublicCalendars() throws Exception {
        String[] groups = CalendarUtils.getUserGroups((String)CalendarUtils.getCurrentUser());
        CalendarService calendarService = CalendarUtils.getCalendarService();
        HashMap<String, String> map = new HashMap<String, String>();
        for (GroupCalendarData group : calendarService.getGroupCalendars(groups, true, CalendarUtils.getCurrentUser())) {
            for (Calendar calendar : group.getCalendars()) {
                map.put(calendar.getId(), calendar.getId());
            }
        }
        return map.values().toArray(new String[map.values().size()]);
    }
}

