/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.popup.UIEventReminderTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.calendar.webui.popup.UITaskDetailTab;
import org.exoplatform.calendar.webui.popup.UITaskForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.ext.UIFormComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEmailAddressActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowUserSelectTaskForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UITaskForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    public static final Log log = ExoLogger.getLogger(UITaskForm.class);
    public static final String TAB_TASKDETAIL = "eventDetail".intern();
    public static final String TAB_TASKREMINDER = "eventReminder".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    public static final String ACT_SELECTUSER = "SelectUser".intern();
    private boolean isAddNew_ = true;
    private CalendarEvent calendarEvent_ = null;
    private String errorMsg_ = null;
    private String errorValues = null;
    private String calType_ = "0";
    private String oldCalendarId_ = null;
    private String newCalendarId_ = null;
    private Map<String, String> delegators_ = new LinkedHashMap();

    public UITaskForm() throws Exception {
        super("UIEventForm");
        UITaskDetailTab uiTaskDetailTab = new UITaskDetailTab(TAB_TASKDETAIL);
        this.addChild((UIComponent)uiTaskDetailTab);
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_TASKREMINDER);
        this.addChild((UIComponent)eventReminderTab);
        this.setSelectedTab(uiTaskDetailTab.getId());
    }

    public String getLabel(String id) {
        String label = id;
        try {
            label = super.getLabel(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return label;
    }

    public void reset() {
        super.reset();
        this.calendarEvent_ = null;
    }

    public void setSelectedEventState(String value) {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_STATUS).setValue(value);
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar, String formTime) throws Exception {
        this.reset();
        String dateFormat = calSetting.getDateFormat();
        String timeFormat = calSetting.getTimeFormat();
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        ((UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_FROM)).setDateFormatStyle(dateFormat);
        ((UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_TO)).setDateFormatStyle(dateFormat);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        if (eventCalendar != null) {
            this.oldCalendarId_ = eventCalendar.getCalType() + CalendarUtils.COLON + eventCalendar.getCalendarId();
            this.isAddNew_ = false;
            this.calendarEvent_ = eventCalendar;
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime(), dateFormat, timeFormat);
            this.setEventToDate(eventCalendar.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(eventCalendar.getCalendarId());
            String eventCategoryId = eventCalendar.getEventCategoryId();
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox selectBox = taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_CATEGORY);
                boolean hasEventCategory = false;
                for (SelectItemOption o : selectBox.getOptions()) {
                    if (!((String)o.getValue()).equals(eventCalendar.getEventCategoryId())) continue;
                    hasEventCategory = true;
                    break;
                }
                if (!hasEventCategory) {
                    selectBox.getOptions().add(new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCalendar.getEventCategoryId()));
                }
                selectBox.setValue(eventCalendar.getEventCategoryId());
            }
            StringBuilder delegator = new StringBuilder("");
            if (eventCalendar.getTaskDelegator() != null) {
                for (String user : eventCalendar.getTaskDelegator().split(CalendarUtils.COMMA)) {
                    if (CalendarUtils.getOrganizationService().getUserHandler().findUserByName(user) == null) continue;
                    if (delegator.length() > 0) {
                        delegator.append(CalendarUtils.COMMA);
                    }
                    delegator.append(user);
                }
            }
            this.setEventDelegation(delegator.toString());
            this.setSelectedEventPriority(eventCalendar.getPriority());
            this.setEventReminders(eventCalendar.getReminders());
            this.setAttachments(eventCalendar.getAttachment());
            this.setSelectedEventState(eventCalendar.getEventState());
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox uiSelectBox = taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_CATEGORY);
                if (!this.isAddNew_ && !String.valueOf(0).equalsIgnoreCase(this.calType_)) {
                    SelectItemOption item = new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCategoryId);
                    uiSelectBox.getOptions().add(item);
                    uiSelectBox.setValue(eventCategoryId);
                    uiSelectBox.setDisabled(true);
                    taskDetailTab.getUIFormSelectBoxGroup(UITaskDetailTab.FIELD_CALENDAR).setDisabled(true);
                    taskDetailTab.setActionField(UITaskDetailTab.FIELD_CATEGORY, null);
                }
            }
        } else {
            UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
            Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
            try {
                cal.setTimeInMillis(Long.parseLong(formTime));
            }
            catch (Exception e) {
                cal.setTime(miniCalendar.getCurrentCalendar().getTime());
            }
            Long beginMinute = (long)cal.get(12) / calSetting.getTimeInterval() * calSetting.getTimeInterval();
            cal.set(12, beginMinute.intValue());
            this.setEventFromDate(cal.getTime(), dateFormat, timeFormat);
            cal.add(12, (int)calSetting.getTimeInterval() * 2);
            this.setEventToDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventDelegation(CalendarUtils.getCurrentUser());
        }
    }

    public static List<SelectItemOption<String>> getCategory() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List eventCategories = calendarService.getEventCategories(CalendarUtils.getCurrentUser());
        for (EventCategory category : eventCategories) {
            boolean isDefaultEventCategory = false;
            for (int i = 0; i < NewUserListener.defaultEventCategoryIds.length; ++i) {
                if (!category.getId().equals(NewUserListener.defaultEventCategoryIds[i]) || !category.getName().equals(NewUserListener.defaultEventCategoryNames[i])) continue;
                isDefaultEventCategory = true;
                break;
            }
            if (isDefaultEventCategory) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()), (String)category.getId());
                options.add((SelectItemOption<String>)new SelectItemOption(newName, (Object)category.getId()));
                continue;
            }
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_CATEGORY).setOptions(UITaskForm.getCategory());
    }

    protected String getStatus() {
        UITaskDetailTab uiTaskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        return (String)uiTaskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_STATUS).getValue();
    }

    protected void setStatus(String value) {
        UITaskDetailTab uiTaskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        uiTaskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_STATUS).setValue(value);
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
        if (value.lastIndexOf("/") > 0) {
            value = value.substring(value.lastIndexOf("/") + 1);
        }
        this.delegators_.put(value, value);
        StringBuffer sb = new StringBuffer();
        for (String s : this.delegators_.values()) {
            if (sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        this.getUIStringInput(selectField).setValue((Object)sb.toString());
    }

    protected boolean isEventDetailValid(CalendarSetting calendarSetting) {
        String dateFormat = calendarSetting.getDateFormat();
        String timeFormat = calendarSetting.getTimeFormat();
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = this.getId() + ".msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = this.getId() + ".msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventToDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-todate-required";
            return false;
        }
        try {
            from = this.getEventFromDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fail to get event's from-date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fail to get event's to-date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                this.errorValues = "";
                return false;
            }
            if (!CalendarUtils.isValidEmailAddresses((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                this.errorValues = CalendarUtils.invalidEmailAddresses((String)this.getEmailAddress());
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        return (String)taskDetailTab.getUIStringInput(UITaskDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIStringInput(UITaskDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        return (String)taskDetailTab.getUIFormTextAreaInput(UITaskDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIFormTextAreaInput(UITaskDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        String value = (String)taskDetailTab.getUIFormSelectBoxGroup(UITaskDetailTab.FIELD_CALENDAR).getValue();
        if (this.oldCalendarId_ != null) {
            this.newCalendarId_ = value;
        }
        if (value != null && value.trim().length() > 0 && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return null;
    }

    public void setSelectedCalendarId(String value) {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        value = this.calType_ + CalendarUtils.COLON + value;
        taskDetailTab.getUIFormSelectBoxGroup(UITaskDetailTab.FIELD_CALENDAR).setValue(value);
    }

    protected String getEventCategory() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        return (String)taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_CATEGORY).getValue();
    }

    public void setSelectedCategory(String value) {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        UIFormComboBox timeField = taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_FROM_TIME);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_FROM);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
            return CalendarUtils.getBeginDay((Date)df.parse((String)fromField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        return df.parse((String)fromField.getValue() + " " + (String)timeField.getValue());
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date, String dateFormat, String timeFormat) throws Exception {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        ((UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_FROM)).setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_FROM_TIME).setValue((Object)df.format(date));
    }

    protected Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        UIFormComboBox timeField = taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_TO_TIME);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_TO);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.getEventAllDate()) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
            df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
            return CalendarUtils.getEndDay((Date)df.parse((String)toField.getValue())).getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat + " " + timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        return df.parse((String)toField.getValue() + " " + (String)timeField.getValue());
    }

    protected String getEventToDateValue() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected void setEventToDate(Date date, String dateFormat, String timeFormat) throws Exception {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        ((UIFormDateTimePicker)taskDetailTab.getChildById(UITaskDetailTab.FIELD_TO)).setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        taskDetailTab.getUIFormComboBox(UITaskDetailTab.FIELD_TO_TIME).setValue((Object)df.format(date));
    }

    protected boolean getEventAllDate() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        return taskDetailTab.getUIFormCheckBoxInput(UITaskDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIFormCheckBoxInput(UITaskDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventDelegation() throws Exception {
        this.delegators_.clear();
        String values = this.getEventDelegationValue();
        StringBuffer sb = new StringBuffer();
        if (!CalendarUtils.isEmpty((String)values)) {
            for (String s : values.split(CalendarUtils.COMMA)) {
                s = s.trim();
                this.delegators_.put(s.trim(), s.trim());
            }
            for (String s : this.delegators_.values()) {
                if (CalendarUtils.isEmpty((String)s)) continue;
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return null;
    }

    protected String[] getEventDelegationAll() {
        this.delegators_.clear();
        String values = this.getEventDelegationValue();
        if (!CalendarUtils.isEmpty((String)values)) {
            for (String s : values.split(CalendarUtils.COMMA)) {
                s = s.trim();
                this.delegators_.put(s.trim(), s.trim());
            }
            return this.delegators_.values().toArray(new String[this.delegators_.values().size()]);
        }
        return null;
    }

    protected String getEventDelegationValue() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        return (String)taskDetailTab.getUIStringInput(UITaskDetailTab.FIELD_DELEGATION).getValue();
    }

    protected void setEventDelegation(String value) {
        if (!CalendarUtils.isEmpty((String)value)) {
            for (String s : value.split(CalendarUtils.COMMA)) {
                s = s.trim();
                this.delegators_.put(s, s);
            }
        } else {
            this.delegators_.clear();
        }
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        taskDetailTab.getUIStringInput(UITaskDetailTab.FIELD_DELEGATION).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIEventReminderTab taskReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return taskReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    protected void setEmailReminder(boolean isChecked) {
        UIEventReminderTab taskReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        taskReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab taskReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return (String)taskReminderTab.getUIStringInput(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected boolean isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).getValue().toString());
    }

    public void setEmailRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getEmailRepeatInterVal() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        return (String)eventDetailTab.getUIStringInput(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected void setEmailReminderBefore(String value) {
        UIEventReminderTab taskDetailTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        taskDetailTab.getUIStringInput(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue((Object)value);
    }

    protected String getEmailAddress() {
        UIEventReminderTab taskDetailTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return (String)taskDetailTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    public void setEmailAddress(String value) {
        UIEventReminderTab taskDetailTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        taskDetailTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected boolean getPopupReminder() {
        UIEventReminderTab taskDetailTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return taskDetailTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).isChecked();
    }

    protected void setPopupReminder(boolean isChecked) {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        taskDetailTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).setChecked(isChecked);
    }

    protected String getPopupReminderTime() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        return (String)taskDetailTab.getUIStringInput(UIEventReminderTab.POPUP_REMIND_BEFORE).getValue();
    }

    protected Boolean isPopupRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).getValue().toString());
    }

    protected void setPopupRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getPopupRepeatInterVal() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        return (String)eventDetailTab.getUIStringInput(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
    }

    protected void setPopupReminderTime(String value) {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        taskDetailTab.getUIStringInput(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue((Object)value);
    }

    protected long getPopupReminderSnooze() {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        try {
            String time = (String)taskDetailTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
            return Long.parseLong(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected void setPopupReminderSnooze(long value) {
        UIFormInputWithActions taskDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKREMINDER);
        taskDetailTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected List<Attachment> getAttachments(String eventId, boolean isAddNew) {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChild(UITaskDetailTab.class);
        return taskDetailTab.getAttachments();
    }

    protected void setAttachments(List<Attachment> attachment) throws Exception {
        UITaskDetailTab taskDetailTab = (UITaskDetailTab)this.getChild(UITaskDetailTab.class);
        taskDetailTab.setAttachments(attachment);
        taskDetailTab.refreshUploadFileList();
    }

    protected void setEventReminders(List<Reminder> reminders) {
        if (reminders == null) {
            return;
        }
        UIEventReminderTab taskDetailTab = (UIEventReminderTab)this.getChildById(TAB_TASKREMINDER);
        for (Reminder r : reminders) {
            if (Reminder.TYPE_EMAIL.equals(r.getReminderType())) {
                this.setEmailReminder(true);
                this.setEmailAddress(r.getEmailAddress());
                this.setEmailRepeat(Boolean.valueOf(r.isRepeat()));
                this.setEmailReminderBefore(String.valueOf(r.getAlarmBefore()));
                taskDetailTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).setValue(String.valueOf(r.getRepeatInterval()));
                continue;
            }
            if (!Reminder.TYPE_POPUP.equals(r.getReminderType())) continue;
            this.setPopupReminder(true);
            this.setPopupRepeat(Boolean.valueOf(r.isRepeat()));
            taskDetailTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue(String.valueOf(r.getAlarmBefore()));
            taskDetailTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(r.getRepeatInterval()));
        }
    }

    protected List<Reminder> getEventReminders(Date fromDateTime) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            email.setEmailAddress(this.getEmailAddress());
            email.setRepeate(this.isEmailRepeat());
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            reminders.add(email);
        }
        if (this.getPopupReminder()) {
            Reminder popup = new Reminder();
            popup.setReminderType(Reminder.TYPE_POPUP);
            popup.setAlarmBefore(Long.parseLong(this.getPopupReminderTime()));
            popup.setRepeate(this.isPopupRepeat().booleanValue());
            popup.setRepeatInterval(Long.parseLong(this.getPopupRepeatInterVal()));
            popup.setFromDateTime(fromDateTime);
            StringBuffer sb = new StringBuffer();
            boolean isExist = false;
            if (this.getEventDelegationAll() != null) {
                for (String s : this.getEventDelegationAll()) {
                    if (!s.equals(CalendarUtils.getCurrentUser())) continue;
                    isExist = true;
                    break;
                }
                for (String s : this.getEventDelegationAll()) {
                    if (sb.length() > 0) {
                        sb.append(CalendarUtils.COMMA);
                    }
                    sb.append(s);
                }
            }
            if (!isExist) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(CalendarUtils.getCurrentUser());
            }
            popup.setReminderOwner(sb.toString());
            reminders.add(popup);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_TASKDETAIL);
        eventDetailTab.getUIFormSelectBox(UITaskDetailTab.FIELD_PRIORITY).setValue(value);
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UITaskDetailTab uiTaskDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        if (options != null) {
            uiTaskDetailTab.getUIFormSelectBoxGroup(UITaskDetailTab.FIELD_CALENDAR).setOptions(options);
        } else {
            uiTaskDetailTab.getUIFormSelectBoxGroup(UITaskDetailTab.FIELD_CALENDAR).setOptions(this.getCalendars());
        }
        this.calType_ = calType;
    }

    private List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    protected long getTotalAttachment() {
        UITaskDetailTab uiTaskDetailTab = (UITaskDetailTab)this.getChild(UITaskDetailTab.class);
        long attSize = 0L;
        for (Attachment att : uiTaskDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    public String cleanValue(String values) throws Exception {
        String[] tmpArr = values.split(",");
        List<String> list = Arrays.asList(tmpArr);
        HashSet<String> set = new HashSet<String>(list);
        String[] result = new String[set.size()];
        set.toArray(result);
        String data2 = "";
        for (String s : result) {
            data2 = data2 + "," + s;
        }
        data2 = data2.substring(1);
        return data2;
    }

    public Attachment getAttachment(String attId) {
        UITaskDetailTab uiDetailTab = (UITaskDetailTab)this.getChildById(TAB_TASKDETAIL);
        for (Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    static /* synthetic */ boolean access$000(UITaskForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ CalendarEvent access$100(UITaskForm x0) {
        return x0.calendarEvent_;
    }

    static /* synthetic */ String access$200(UITaskForm x0) {
        return x0.calType_;
    }

    static /* synthetic */ boolean access$300(UITaskForm x0) throws Exception {
        return x0.isReminderValid();
    }

    static /* synthetic */ String access$400(UITaskForm x0) {
        return x0.errorMsg_;
    }

    static /* synthetic */ String access$500(UITaskForm x0) {
        return x0.errorValues;
    }

    static /* synthetic */ String access$600(UITaskForm x0) {
        return x0.oldCalendarId_;
    }

    static /* synthetic */ String access$700(UITaskForm x0) {
        return x0.newCalendarId_;
    }
}

