/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMonthView;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMonthView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.ChangeCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.EventSelectActionListener.class}), @EventConfig(listeners={UICalendarView.AddCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={UICalendarView.MoveEventActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class})})
public class UIMonthView
extends UICalendarView {
    private LinkedHashMap<String, CalendarEvent> dataMap_ = new LinkedHashMap();
    private Map<String, Map<String, CalendarEvent>> eventData_ = new HashMap();

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    public void refresh() throws Exception {
        String key;
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonthView());
        eventQuery.setToDate(this.getEndDateOfMonthView());
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        List allEvents = calendarService.getEvents(username, eventQuery, this.getPublicCalendars());
        List originalRecurEvents = calendarService.getOriginalRecurrenceEvents(username, eventQuery.getFromDate(), eventQuery.getToDate());
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            for (CalendarEvent recurEvent : originalRecurEvents) {
                Map tempMap = calendarService.getOccurrenceEvents(recurEvent, eventQuery.getFromDate(), eventQuery.getToDate());
                if (tempMap == null) continue;
                this.recurrenceEventsMap.put(recurEvent.getId(), tempMap);
                allEvents.addAll(tempMap.values());
            }
        }
        Iterator childIter = this.getChildren().iterator();
        while (childIter.hasNext()) {
            UIComponent comp = (UIComponent)childIter.next();
            if (!(comp instanceof UIFormCheckBoxInput)) continue;
            childIter.remove();
        }
        this.dataMap_.clear();
        Iterator eventIter = allEvents.iterator();
        int maxDay = 35;
        int i = 0;
        Calendar c = this.getBeginDateOfMonthView();
        while (i++ < maxDay) {
            HashMap list = new HashMap();
            key = this.keyGen(c.get(5), c.get(2), c.get(1));
            this.eventData_.put(key, list);
            c.add(5, 1);
        }
        while (eventIter.hasNext()) {
            CalendarEvent event = (CalendarEvent)eventIter.next();
            c.setTime(event.getFromDateTime());
            key = this.keyGen(c.get(5), c.get(2), c.get(1));
            ((Map)this.eventData_.get(key)).put(event.getId(), event);
            this.dataMap_.put(event.getId(), event);
            UIFormCheckBoxInput input = !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && !CalendarUtils.isEmpty((String)event.getRecurrenceId()) ? new UIFormCheckBoxInput(this.getCheckboxId(event), this.getCheckboxId(event), (Object)false) : new UIFormCheckBoxInput(event.getId(), event.getId(), (Object)false);
            input.setBindingField(event.getCalendarId());
            this.addChild((UIComponent)input);
            eventIter.remove();
        }
    }

    public String getCheckboxId(CalendarEvent event) throws Exception {
        if (!CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && !CalendarUtils.isEmpty((String)event.getRecurrenceId())) {
            return event.getId() + "-" + event.getRecurrenceId();
        }
        return event.getId();
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        while (temCal.get(5) < 20 && temCal.get(5) != 1) {
            temCal.add(5, -7);
        }
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, 1);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, this.getDaysInMonth());
        return this.getEndDay(temCal);
    }

    protected List<CalendarEvent> getSelectedEvents() {
        UIFormCheckBoxInput checkbox;
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String id : this.dataMap_.keySet()) {
            checkbox = (UIFormCheckBoxInput)this.getChildById(id);
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add((CalendarEvent)this.dataMap_.get(id));
        }
        if (this.recurrenceEventsMap.isEmpty()) {
            return events;
        }
        for (String eventId : this.recurrenceEventsMap.keySet()) {
            for (String recurId : ((Map)this.recurrenceEventsMap.get(eventId)).keySet()) {
                checkbox = (UIFormCheckBoxInput)this.getChildById(eventId + "-" + recurId);
                if (checkbox == null || !checkbox.isChecked()) continue;
                events.add((CalendarEvent)((Map)this.recurrenceEventsMap.get(eventId)).get(recurId));
            }
        }
        return events;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return this.dataMap_;
    }

    protected Map<String, Map<String, CalendarEvent>> getEventData() {
        return this.eventData_;
    }
}

