/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.popup.UIAttachFileForm;
import org.exoplatform.calendar.webui.popup.UIConfirmForm;
import org.exoplatform.calendar.webui.popup.UIEventAttenderTab;
import org.exoplatform.calendar.webui.popup.UIEventDetailTab;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIEventReminderTab;
import org.exoplatform.calendar.webui.popup.UIEventShareTab;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.calendar.webui.popup.UIRepeatEventForm;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.calendar.webui.popup.UITaskForm;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.BufferAttachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.MailServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MoveNextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MovePreviousActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddEmailAddressActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmOKActionListener.class}, name="ConfirmOK", phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmCancelActionListener.class}, name="ConfirmCancel", phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateOnlyInstance.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateAllSeries.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateCancel.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditRepeatActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowAddUserEventForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={UITaskForm.CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIEventForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    private Log log;
    public static final String TAB_EVENTDETAIL = "eventDetail".intern();
    public static final String TAB_EVENTREMINDER = "eventReminder".intern();
    public static final String TAB_EVENTSHARE = "eventShare".intern();
    public static final String TAB_EVENTATTENDER = "eventAttender".intern();
    public static final String FIELD_MEETING = "participant".intern();
    public static final String FIELD_ISSENDMAIL = "isSendMail".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_OUTSIDE = "outside".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ITEM_ALWAYS = "always".intern();
    public static final String ITEM_NERVER = "never".intern();
    public static final String ITEM_ASK = "ask".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    public static final String ACT_EDITREPEAT = "EditRepeat".intern();
    public static final String STATUS_EMPTY = "".intern();
    public static final String STATUS_PENDING = "pending".intern();
    public static final String STATUS_YES = "yes".intern();
    public static final String STATUS_NO = "no".intern();
    public static final String RP_END_BYDATE = "endByDate";
    public static final String RP_END_AFTER = "endAfter";
    public static final String RP_END_NEVER = "neverEnd";
    private boolean isAddNew_;
    private boolean isChangedSignificantly;
    private CalendarEvent calendarEvent_;
    protected String calType_;
    protected String invitationMsg_;
    protected String participantList_;
    private String errorMsg_;
    private String errorValues;
    protected Map<String, String> participants_;
    protected Map<String, String> participantStatus_;
    protected LinkedList<ParticipantStatus> participantStatusList_;
    private String oldCalendarId_;
    private String newCalendarId_;
    private String saveEventInvitation;
    private String saveEventNoInvitation;
    private CalendarEvent repeatEvent;
    private String repeatSummary;

    public UIEventForm() throws Exception {
        block2: {
            super("UIEventForm");
            this.log = ExoLogger.getLogger(this.getClass());
            this.isAddNew_ = true;
            this.isChangedSignificantly = false;
            this.calendarEvent_ = null;
            this.calType_ = "0";
            this.invitationMsg_ = "";
            this.participantList_ = "";
            this.errorMsg_ = null;
            this.errorValues = null;
            this.participants_ = new LinkedHashMap();
            this.participantStatus_ = new LinkedHashMap();
            this.participantStatusList_ = new LinkedList();
            this.oldCalendarId_ = null;
            this.newCalendarId_ = null;
            this.saveEventInvitation = "";
            this.saveEventNoInvitation = "";
            this.setId("UIEventForm");
            this.saveEventInvitation = "SaveEvent-Invitation";
            this.saveEventNoInvitation = "SaveEvent-NoSendInvitation";
            try {
                this.saveEventInvitation = this.getLabel("SaveEvent-Invitation");
                this.saveEventNoInvitation = this.getLabel("SaveEvent-NoSendInvitation");
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Fail to get label: " + this.saveEventInvitation), (Throwable)e);
                this.log.debug((Object)("Fail to get label: " + this.saveEventNoInvitation), (Throwable)e);
            }
        }
        UIEventDetailTab eventDetailTab = new UIEventDetailTab(TAB_EVENTDETAIL);
        this.addChild((UIComponent)eventDetailTab);
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_EVENTREMINDER);
        this.addChild((UIComponent)eventReminderTab);
        UIEventShareTab eventShareTab = new UIEventShareTab(TAB_EVENTSHARE);
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE, UIEventShareTab.FIELD_SHARE, this.getShareValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS, UIEventShareTab.FIELD_STATUS, this.getStatusValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SEND, UIEventShareTab.FIELD_SEND, CalendarUtils.getSendValue(null)));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormInputInfo(UIEventShareTab.FIELD_INFO, UIEventShareTab.FIELD_INFO, null));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MEETING, FIELD_MEETING, null));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addUser = new UIFormInputWithActions.ActionData();
        addUser.setActionListener("AddParticipant");
        addUser.setActionName("AddUser");
        addUser.setActionParameter(TAB_EVENTSHARE);
        addUser.setActionType(0);
        addUser.setCssIconClass("AddNewNodeIcon");
        actions.add(addUser);
        eventShareTab.setActionField(UIEventShareTab.FIELD_INFO, actions);
        this.addChild((UIComponent)eventShareTab);
        UIEventAttenderTab eventAttenderTab = new UIEventAttenderTab(TAB_EVENTATTENDER);
        this.addChild((UIComponent)eventAttenderTab);
        this.setSelectedTab(eventDetailTab.getId());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            this.log.warn((Object)("Can not find " + this.getId() + ".label." + id));
            return id;
        }
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar, String formTime) throws Exception {
        this.reset();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM)).setDateFormatStyle(calSetting.getDateFormat());
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO)).setDateFormatStyle(calSetting.getDateFormat());
        UIEventAttenderTab attenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        List fromOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        List toOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_FROM_TIME).setOptions(fromOptions);
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_TO_TIME).setOptions(toOptions);
        if (eventCalendar != null) {
            this.isAddNew_ = false;
            this.calendarEvent_ = eventCalendar;
            this.repeatEvent = new CalendarEvent(this.calendarEvent_);
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(eventCalendar.getFromDateTime());
            this.setEventToDate(eventCalendar.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(eventCalendar.getCalendarId());
            String eventCategoryId = eventCalendar.getEventCategoryId();
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox selectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                boolean hasEventCategory = false;
                for (SelectItemOption o : selectBox.getOptions()) {
                    if (!((String)o.getValue()).equals(eventCategoryId)) continue;
                    hasEventCategory = true;
                    break;
                }
                if (!hasEventCategory) {
                    selectBox.getOptions().add(new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCategoryId));
                }
                this.setSelectedCategory(eventCategoryId);
            }
            this.setEventPlace(eventCalendar.getLocation());
            this.setEventIsRepeat(eventCalendar.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(eventCalendar.getRepeatType()));
            this.setRepeatSummary(this.buildRepeatSummary(this.calendarEvent_));
            if ((CalendarEvent.RP_NOREPEAT.equals(this.calendarEvent_.getRepeatType()) || this.calendarEvent_.getRepeatType() == null) && !CalendarUtils.isEmpty((String)this.calendarEvent_.getRecurrenceId()) && this.calendarEvent_.getIsExceptionOccurrence().booleanValue()) {
                ((UIEventDetailTab)this.getChild(UIEventDetailTab.class)).getUIFormCheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).setEnable(false);
            }
            this.setSelectedEventPriority(eventCalendar.getPriority());
            if (eventCalendar.getReminders() != null) {
                this.setEventReminders(eventCalendar.getReminders());
            }
            this.setAttachments(eventCalendar.getAttachment());
            if (eventCalendar.isPrivate()) {
                this.setSelectedShareType(ITEM_PRIVATE);
            } else {
                this.setSelectedShareType(ITEM_PUBLIC);
            }
            this.setSendOption(eventCalendar.getSendOption());
            this.setMessage(eventCalendar.getMessage());
            this.setParticipantStatusValues(eventCalendar.getParticipantStatus());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            this.setSelectedEventState(eventCalendar.getEventState());
            this.setMeetingInvitation(eventCalendar.getInvitation());
            StringBuffer pars = new StringBuffer();
            if (eventCalendar.getParticipant() != null) {
                for (String par : eventCalendar.getParticipant()) {
                    if (!CalendarUtils.isEmpty((String)pars.toString())) {
                        pars.append(CalendarUtils.BREAK_LINE);
                    }
                    pars.append(par);
                }
            }
            this.setParticipant(pars.toString());
            if (eventCategoryId != null) {
                UIFormSelectBox uiSelectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                if (!this.isAddNew_ && !String.valueOf(0).equalsIgnoreCase(this.calType_)) {
                    SelectItemOption item = new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCalendar.getEventCategoryId());
                    uiSelectBox.getOptions().add(item);
                    uiSelectBox.setValue(eventCalendar.getEventCategoryId());
                    uiSelectBox.setDisabled(true);
                    eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setDisabled(true);
                    eventDetailTab.setActionField(UIEventDetailTab.FIELD_CATEGORY, null);
                }
            }
            attenderTab.calendar_.setTime(eventCalendar.getFromDateTime());
        } else {
            java.util.Calendar cal = UIEventForm.getCalendar((UIForm)this, (String)formTime, (CalendarSetting)calSetting);
            this.setEventFromDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            cal.add(12, (int)calSetting.getTimeInterval() * 2);
            this.setEventCheckTime(cal.getTime());
            this.setEventToDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            StringBuffer pars = new StringBuffer(CalendarUtils.getCurrentUser());
            this.setMeetingInvitation(new String[]{CalendarUtils.getOrganizationService().getUserHandler().findUserByName(pars.toString()).getEmail()});
            this.setParticipant(pars.toString());
            this.setSendOption(calSetting.getSendOption());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            attenderTab.updateParticipants(pars.toString());
            this.setRepeatSummary(this.buildRepeatSummary(null));
        }
    }

    public static java.util.Calendar getCalendar(UIForm uiForm, String formTime, CalendarSetting calSetting) {
        java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
        try {
            cal.setTimeInMillis(Long.parseLong(formTime));
        }
        catch (Exception e) {
            UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
            cal.setTime(miniCalendar.getCurrentCalendar().getTime());
        }
        Long beginMinute = (long)cal.get(12) / calSetting.getTimeInterval() * calSetting.getTimeInterval();
        cal.set(12, beginMinute.intValue());
        return cal;
    }

    private void setEventCheckTime(Date time) {
        UIEventAttenderTab uiAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        uiAttenderTab.calendar_.setTime(time);
    }

    private boolean setCalendarOptionOfSpaceAsSelected(String spaceId, List<? extends SelectItem> items, UIFormSelectBoxWithGroups selectBoxWithGroups) {
        if (spaceId == null || items == null) {
            return false;
        }
        for (SelectItem selectItem : items) {
            if (selectItem instanceof SelectOption) {
                SelectOption so = (SelectOption)selectItem;
                if (!so.getValue().endsWith(spaceId)) continue;
                selectBoxWithGroups.setValue(so.getValue());
                return true;
            }
            if (!(selectItem instanceof SelectOptionGroup) || !this.setCalendarOptionOfSpaceAsSelected(spaceId, ((SelectOptionGroup)selectItem).getOptions(), selectBoxWithGroups)) continue;
            return true;
        }
        return false;
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormSelectBoxWithGroups selectBoxWithGroups = uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR);
        if (options != null) {
            selectBoxWithGroups.setOptions(options);
        } else {
            selectBoxWithGroups.setOptions(this.getCalendars());
        }
        String spaceId = UICalendarPortlet.getSpaceId();
        if (spaceId != null) {
            this.setCalendarOptionOfSpaceAsSelected(spaceId, selectBoxWithGroups.getOptions(), selectBoxWithGroups);
        }
        this.calType_ = calType;
    }

    private List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setOptions(CalendarUtils.getCategory());
    }

    private List<SelectItemOption<String>> getShareValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_PRIVATE, (Object)ITEM_PRIVATE));
        options.add(new SelectItemOption(ITEM_PUBLIC, (Object)ITEM_PUBLIC));
        return options;
    }

    private List<SelectItemOption<String>> getStatusValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_BUSY, (Object)ITEM_BUSY));
        options.add(new SelectItemOption(ITEM_AVAILABLE, (Object)ITEM_AVAILABLE));
        options.add(new SelectItemOption(ITEM_OUTSIDE, (Object)ITEM_OUTSIDE));
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                this.errorValues = "";
                return false;
            }
            if (!CalendarUtils.isValidEmailAddresses((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                this.errorValues = CalendarUtils.invalidEmailAddresses((String)this.getEmailAddress());
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    protected boolean isEventDetailValid(CalendarSetting calendarSetting) throws Exception {
        String dateFormat = calendarSetting.getDateFormat();
        String timeFormat = calendarSetting.getTimeFormat();
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = this.getId() + ".msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = this.getId() + ".msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventToDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-todate-required";
            return false;
        }
        try {
            from = this.getEventFromDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Faile to get event from date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Fail to get event to date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isParticipantValid() throws Exception {
        if (this.isSendMail() && this.getMeetingInvitation() == null) {
            this.errorMsg_ = "UIEventForm.msg.error-particimant-email-required";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        String value;
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        this.newCalendarId_ = value = (String)eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void setSelectedCalendarId(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        value = this.calType_ + CalendarUtils.COLON + value;
        eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setValue(value);
        this.oldCalendarId_ = value;
    }

    protected String getEventCategory() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).getValue();
    }

    public void setSelectedCategory(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        try {
            UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
            UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
            UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
            return UITaskForm.getBeginDate((boolean)this.getEventAllDate(), (String)dateFormat, (String)((String)fromField.getValue()), (String)timeFormat, (String)((String)timeField.getValue()));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        fromField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventFromDate(date, timeFormat);
    }

    protected Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        return UITaskForm.getToDate((boolean)this.getEventAllDate(), (String)dateFormat, (String)((String)toField.getValue()), (String)timeFormat, (String)((String)timeField.getValue()));
    }

    protected void setEventToDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        toField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventToDate(date, timeFormat);
    }

    protected String getEventToDateValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected boolean getEventAllDate() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).getValue();
    }

    protected void setEventRepeat(String type) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).setValue(type);
    }

    protected boolean getEventIsRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).isChecked();
    }

    protected void setEventIsRepeat(boolean isRepeat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormCheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).setChecked(isRepeat);
    }

    protected String getEventRepeatUntilValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker untilField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_REPEAT_UNTIL);
        return (String)untilField.getValue();
    }

    protected String getEventPlace() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).getValue();
    }

    protected void setEventPlace(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    public void setEmailReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected boolean isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).getValue().toString());
    }

    public void setEmailRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getEmailRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected void setEmailRepeatInterVal(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected Boolean isPopupRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).getValue().toString());
    }

    protected void setPopupRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getPopupRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
    }

    public void setEmailRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue(value);
    }

    protected String getEmailAddress() throws Exception {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    public void setEmailAddress(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected boolean getPopupReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).isChecked();
    }

    protected void setPopupReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormCheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).setChecked(isChecked);
    }

    protected String getPopupReminderTime() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).getValue();
    }

    protected void setPopupRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue(value);
    }

    protected long getPopupReminderSnooze() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        try {
            String time = (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
            return Long.parseLong(time);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Can't get time from POPUP_REPEAT_INTERVAL", (Throwable)e);
            }
            return 0L;
        }
    }

    protected List<org.exoplatform.calendar.service.Attachment> getAttachments(String eventId, boolean isAddNew) {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        return uiEventDetailTab.getAttachments();
    }

    protected long getTotalAttachment() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        long attSize = 0L;
        for (org.exoplatform.calendar.service.Attachment att : uiEventDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    protected void setAttachments(List<org.exoplatform.calendar.service.Attachment> attachment) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        uiEventDetailTab.setAttachments(attachment);
        uiEventDetailTab.refreshUploadFileList();
    }

    protected void setPopupRepeatInterval(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected void setEventReminders(List<Reminder> reminders) {
        for (Reminder rm : reminders) {
            if (Reminder.TYPE_EMAIL.equals(rm.getReminderType())) {
                this.setEmailReminder(true);
                this.setEmailAddress(rm.getEmailAddress());
                this.setEmailRepeat(Boolean.valueOf(rm.isRepeat()));
                this.setEmailRemindBefore(String.valueOf(rm.getAlarmBefore()));
                this.setEmailRepeatInterVal(rm.getRepeatInterval());
                continue;
            }
            if (!Reminder.TYPE_POPUP.equals(rm.getReminderType())) continue;
            this.setPopupReminder(true);
            this.setPopupRepeat(Boolean.valueOf(rm.isRepeat()));
            this.setPopupRemindBefore(String.valueOf(rm.getAlarmBefore()));
            this.setPopupRepeatInterval(rm.getRepeatInterval());
        }
    }

    protected List<Reminder> getEventReminders(Date fromDateTime, List<Reminder> currentReminders) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_EMAIL)) continue;
                    email = rm;
                    break;
                }
            }
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setReminderOwner(CalendarUtils.getCurrentUser());
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            StringBuffer sbAddress = new StringBuffer();
            for (String s : this.getEmailAddress().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA)) {
                if (sbAddress.indexOf(s = s.trim()) >= 0) continue;
                if (sbAddress.length() > 0) {
                    sbAddress.append(CalendarUtils.COMMA);
                }
                sbAddress.append(s);
            }
            email.setEmailAddress(sbAddress.toString());
            email.setRepeate(this.isEmailRepeat());
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            if (!CalendarUtils.isEmpty((String)email.getEmailAddress())) {
                reminders.add(email);
            }
        }
        if (this.getPopupReminder()) {
            Reminder popup = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_POPUP)) continue;
                    popup = rm;
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            boolean isExist = false;
            if (!isExist) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(CalendarUtils.getCurrentUser());
            }
            popup.setReminderOwner(sb.toString());
            popup.setReminderType(Reminder.TYPE_POPUP);
            popup.setAlarmBefore(Long.parseLong(this.getPopupReminderTime()));
            popup.setRepeate(this.isPopupRepeat().booleanValue());
            popup.setRepeatInterval(Long.parseLong(this.getPopupRepeatInterVal()));
            popup.setFromDateTime(fromDateTime);
            reminders.add(popup);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).setValue(value);
    }

    protected String getEventState() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).getValue();
    }

    public void setSelectedEventState(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).setValue((Object)value);
    }

    protected String getShareType() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).getValue();
    }

    protected String getSendOption() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).getValue();
    }

    protected void setSendOption(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).setValue((Object)value);
    }

    public String getMessage() {
        return this.invitationMsg_;
    }

    public void setMessage(String invitationMsg) {
        this.invitationMsg_ = invitationMsg;
    }

    protected void setSelectedShareType(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).setValue((Object)value);
    }

    protected String[] getMeetingInvitation() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        String invitation = (String)eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).getValue();
        if (CalendarUtils.isEmpty((String)invitation)) {
            return null;
        }
        return invitation.replace(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA);
    }

    protected String getInvitationEmail() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0 && ((String)par.getKey()).contains("@")) {
                buider.append(CalendarUtils.COMMA);
            }
            if (!((String)par.getKey()).contains("@")) continue;
            buider.append(((String)par.getKey()).substring(((String)par.getKey()).lastIndexOf(CalendarUtils.OPEN_PARENTHESIS) + 1).replace(CalendarUtils.CLOSE_PARENTHESIS, ""));
        }
        return buider.toString();
    }

    protected void setMeetingInvitation(String[] values) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            for (String s : values) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(s);
            }
        }
        eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).setValue((Object)sb.toString());
    }

    protected String getParticipantValues() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participants_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    protected String getParticipantStatusValues() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append((String)par.getKey() + ":" + (String)par.getValue());
        }
        return buider.toString();
    }

    protected void setParticipantStatusValues(String[] values) throws Exception {
        this.participantStatus_.clear();
        this.participantStatusList_.clear();
        for (String par : values) {
            String[] entry = par.split(":");
            if (entry.length <= 0 || !StringUtils.isNotBlank((String)entry[0])) continue;
            if (entry.length > 1) {
                this.participantStatus_.put(entry[0], entry[1]);
                this.participantStatusList_.add(new ParticipantStatus(this, entry[0], entry[1]));
                continue;
            }
            if (entry.length != 1) continue;
            this.participantStatus_.put(entry[0], STATUS_EMPTY);
            this.participantStatusList_.add(new ParticipantStatus(this, entry[0], STATUS_EMPTY));
        }
    }

    public void setParticipant(String values) throws Exception {
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        StringBuffer sb = new StringBuffer();
        for (String s : values.split(CalendarUtils.BREAK_LINE)) {
            User user = orgService.getUserHandler().findUserByName(s);
            if (user == null) continue;
            this.participants_.put(s.trim(), user.getEmail());
            if (!CalendarUtils.isEmpty((String)sb.toString())) {
                sb.append(CalendarUtils.BREAK_LINE);
            }
            sb.append(s.trim());
        }
        ((UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER)).updateParticipants(this.getParticipantValues());
    }

    public String getParticipantStatus() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participantStatus_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    public void setParticipantStatus(String values) throws Exception {
        String[] array;
        for (String s : array = values.split(CalendarUtils.BREAK_LINE)) {
            if (s.trim().length() <= 0 || this.participantStatus_.put(s.trim(), STATUS_EMPTY) != null) continue;
            this.participantStatusList_.add(new ParticipantStatus(this, s.trim(), STATUS_EMPTY));
        }
    }

    protected boolean isSendMail() {
        return false;
    }

    public void importInvitationEvent(CalendarSetting calSetting, CalendarEvent event, String calendarId, String formtime) throws Exception {
        if (event != null) {
            this.setEventSumary(event.getSummary());
            this.setEventDescription(event.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)event));
            this.setEventFromDate(event.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(event.getFromDateTime());
            this.setEventToDate(event.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(calendarId);
            this.setEventPlace(event.getLocation());
            this.setEventRepeat(event.getRepeatType());
            this.setEventReminders(event.getReminders());
            this.setAttachments(event.getAttachment());
            this.setMessage(event.getMessage());
            this.setParticipantStatusValues(event.getParticipantStatus());
        }
    }

    protected void sendMail(MailService svr, OrganizationService orSvr, CalendarSetting setting, Account acc, String fromId, String toId, CalendarEvent event) throws Exception {
        List atts = this.getAttachments(null, false);
        SimpleDateFormat df = new SimpleDateFormat(setting.getDateFormat() + " " + setting.getTimeFormat());
        User invitor = orSvr.getUserHandler().findUserByName(CalendarUtils.getCurrentUser());
        StringBuffer sbSubject = new StringBuffer("[" + this.getLabel("invitation") + "] ");
        sbSubject.append(event.getSummary());
        sbSubject.append(" ");
        sbSubject.append(df.format(event.getFromDateTime()));
        StringBuffer sbBody = new StringBuffer();
        sbBody.append("<div style=\"margin: 20px auto; padding: 8px; background: rgb(224, 236, 255) none repeat scroll 0%; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial; width: 500px;\">");
        sbBody.append("<table style=\"margin: 0px; padding: 0px; border-collapse: collapse; border-spacing: 0px; width: 100%; line-height: 16px;\">");
        sbBody.append("<tbody>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap; \">" + this.getLabel("fromWho") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> " + invitor.getUserName() + "(" + invitor.getEmail() + ")" + " </td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_MESSAGE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getMessage() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_EVENT) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getSummary() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_DESCRIPTION) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getDescription() != null && event.getDescription().trim().length() > 0 ? event.getDescription() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel("when") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> <div>" + this.getLabel(UIEventDetailTab.FIELD_FROM) + ": " + df.format(event.getFromDateTime()) + "</div>");
        sbBody.append("<div>" + this.getLabel(UIEventDetailTab.FIELD_TO) + ": " + df.format(event.getToDateTime()) + "</div></td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_PLACE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getLocation() != null && event.getLocation().trim().length() > 0 ? event.getLocation() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(FIELD_MEETING) + "</td>");
        toId = toId.replace(CalendarUtils.BREAK_LINE, CalendarUtils.COMMA);
        if (CalendarUtils.isEmpty((String)this.getInvitationEmail())) {
            sbBody.append("<td style=\"padding: 4px;\">" + toId + "</td>");
        } else {
            String newInvi = this.getInvitationEmail().replace(",", ", ");
            sbBody.append("<td style=\"padding: 4px;\">" + toId + ", " + newInvi + "</td>");
        }
        sbBody.append("</tr>");
        if (!atts.isEmpty()) {
            sbBody.append("<tr>");
            sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(UIEventDetailTab.FIELD_ATTACHMENTS) + ":</td>");
            StringBuffer sbf = new StringBuffer();
            for (org.exoplatform.calendar.service.Attachment att : atts) {
                if (sbf.length() > 0) {
                    sbf.append(",");
                }
                sbf.append(att.getName());
            }
            sbBody.append("<td style=\"padding: 4px;\"> (" + atts.size() + ") " + sbf.toString() + " </td>");
            sbBody.append("</tr>");
        }
        HashMap<String, String> eXoIdMap = new HashMap<String, String>();
        StringBuffer sbAddress = new StringBuffer();
        if (event.getInvitation() != null) {
            for (String s : event.getInvitation()) {
                s = s.trim();
                if (sbAddress.length() > 0) {
                    sbAddress.append(",");
                }
                sbAddress.append(s);
                eXoIdMap.put(s, null);
            }
        }
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        StringBuffer sb = new StringBuffer();
        for (String s : toId.split(CalendarUtils.COMMA)) {
            User user = orgService.getUserHandler().findUserByName(s);
            if (user == null) continue;
            if (!CalendarUtils.isEmpty((String)sb.toString())) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(user.getEmail());
            eXoIdMap.put(user.getEmail(), s);
        }
        if (sbAddress.length() > 0 && sb.toString().trim().length() > 0) {
            sbAddress.append(",");
        }
        sbAddress.append(sb.toString().trim());
        StringBuffer values = new StringBuffer(fromId);
        User user = orSvr.getUserHandler().findUserByName(fromId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(toId);
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalType());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getCalendarId());
        values.append(CalendarUtils.SEMICOLON + " ");
        values.append(event.getId());
        if (acc != null) {
            ArrayList<BufferAttachment> attachments;
            block23: {
                attachments = new ArrayList<BufferAttachment>();
                try {
                    CalendarService calService = CalendarUtils.getCalendarService();
                    OutputStream out = calService.getCalendarImportExports(CalendarService.ICALENDAR).exportEventCalendar(fromId, event.getCalendarId(), event.getCalType(), event.getId());
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                    BufferAttachment bf = new BufferAttachment();
                    bf.setInputStream((InputStream)is);
                    bf.setName("icalendar.ics");
                    bf.setMimeType("text/calendar");
                    attachments.add(bf);
                    for (org.exoplatform.calendar.service.Attachment att : atts) {
                        bf = new BufferAttachment();
                        bf.setInputStream(att.getInputStream());
                        bf.setName(att.getName());
                        bf.setMimeType(att.getMimeType());
                        attachments.add(bf);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block23;
                    this.log.debug((Object)"Fail to create attachment list", (Throwable)e);
                }
            }
            for (String s : sbAddress.toString().split(CalendarUtils.COMMA)) {
                org.exoplatform.mail.service.Message message = new org.exoplatform.mail.service.Message();
                message.setSubject(sbSubject.toString());
                message.setMessageBody(this.getBodyMail(sbBody.toString(), eXoIdMap, s, invitor, event));
                message.setContentType(org.exoplatform.mail.service.Utils.MIMETYPE_TEXTHTML);
                message.setFrom(user.getEmail());
                message.setMessageTo(s);
                message.setHeader(CalendarUtils.EXO_INVITATION, values.toString());
                message.setSendDate(new Date());
                message.setAttachements(attachments);
                svr.sendMessage(user.getUserName(), acc.getId(), message);
            }
        } else {
            Attachment attachmentCal;
            org.exoplatform.services.mail.MailService mService;
            block24: {
                CalendarService calService = CalendarUtils.getCalendarService();
                mService = (org.exoplatform.services.mail.MailService)this.getApplicationComponent(MailServiceImpl.class);
                attachmentCal = new Attachment();
                try {
                    OutputStream out = calService.getCalendarImportExports(CalendarService.ICALENDAR).exportEventCalendar(fromId, event.getCalendarId(), event.getCalType(), event.getId());
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                    attachmentCal.setInputStream((InputStream)is);
                    attachmentCal.setName("icalendar.ics");
                    attachmentCal.setMimeType("text/calendar");
                }
                catch (Exception e) {
                    attachmentCal = null;
                    if (!this.log.isDebugEnabled()) break block24;
                    this.log.debug((Object)"Fail to create attachment", (Throwable)e);
                }
            }
            for (String s : sbAddress.toString().split(CalendarUtils.COMMA)) {
                if (CalendarUtils.isEmpty((String)s)) continue;
                Message message = new Message();
                message.setSubject(sbSubject.toString());
                message.setBody(this.getBodyMail(sbBody.toString(), eXoIdMap, s, invitor, event));
                message.setTo(s);
                message.setMimeType(org.exoplatform.mail.service.Utils.MIMETYPE_TEXTHTML);
                message.setFrom(user.getEmail());
                if (attachmentCal != null) {
                    message.addAttachment(attachmentCal);
                }
                if (!atts.isEmpty()) {
                    for (org.exoplatform.calendar.service.Attachment att : atts) {
                        Attachment attachment = new Attachment();
                        attachment.setInputStream(att.getInputStream());
                        attachment.setMimeType(att.getMimeType());
                        message.addAttachment(attachment);
                    }
                }
                mService.sendMessage(message);
            }
        }
        ContactService contactService = (ContactService)PortalContainer.getComponent(ContactService.class);
        contactService.saveAddress(CalendarUtils.getCurrentUser(), sbAddress.toString());
    }

    private String getBodyMail(String sbBody, Map<String, String> eXoIdMap, String s, User invitor, CalendarEvent event) throws Exception {
        StringBuilder body = new StringBuilder(sbBody.toString());
        String eXoId = CalendarUtils.isEmpty((String)eXoIdMap.get(s)) ? "null" : eXoIdMap.get(s);
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append("Would you like to attend? </td><td> <a href=\"" + this.getReplyInvitationLink(1, invitor, s, eXoId, event) + "\" >Yes</a>" + " - " + "<a href=\"" + this.getReplyInvitationLink(2, invitor, s, eXoId, event) + "\" >Not sure</a>" + " - " + "<a href=\"" + this.getReplyInvitationLink(0, invitor, s, eXoId, event) + "\" >No</a>");
        body.append("</td></tr>");
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append("Would you like to see more details? </td><td><a href=\"" + this.getReplyInvitationLink(3, invitor, s, eXoId, event) + "\" >Import to your eXo Calendar</a> or <a href=\"" + this.getReplyInvitationLink(4, invitor, s, eXoId, event) + "\" >Jump to eXo Calendar</a>");
        body.append("</td></tr>");
        body.append("</tbody>");
        body.append("</table>");
        body.append("</div>");
        return body.toString();
    }

    protected String getReplyInvitationLink(int answer, User invitor, String invitee, String eXoId, CalendarEvent event) throws Exception {
        String portalURL = CalendarUtils.getServerBaseUrl() + PortalContainer.getCurrentPortalContainerName();
        String restURL = portalURL + "/" + PortalContainer.getCurrentRestContextName();
        String calendarURL = CalendarUtils.getCalendarURL();
        if (answer == 1 || answer == 0 || answer == 2) {
            return restURL + "/cs/calendar" + CalendarUtils.INVITATION_URL + event.getCalendarId() + "/" + event.getCalType() + "/" + event.getId() + "/" + invitor.getUserName() + "/" + invitee + "/" + eXoId + "/" + answer;
        }
        if (answer == 3) {
            return calendarURL + CalendarUtils.INVITATION_IMPORT_URL + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        if (answer == 4) {
            return calendarURL + CalendarUtils.INVITATION_DETAIL_URL + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        return "";
    }

    public org.exoplatform.calendar.service.Attachment getAttachment(String attId) {
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    public List<ParticipantStatus> getParticipantStatusList() {
        return this.participantStatusList_;
    }

    public static void downloadAtt(Event<?> event, UIForm uiForm, boolean isEvent) throws Exception {
        String attId = event.getRequestContext().getRequestParameter("objectId");
        org.exoplatform.calendar.service.Attachment attach = null;
        if (isEvent) {
            UIEventForm uiEventForm = (UIEventForm)uiForm;
            attach = uiEventForm.getAttachment(attId);
        } else {
            UITaskForm uiTaskForm = (UITaskForm)uiForm;
            attach = uiTaskForm.getAttachment(attId);
        }
        if (attach != null) {
            String mimeType = attach.getMimeType().substring(attach.getMimeType().indexOf("/") + 1);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(attach.getInputStream(), mimeType);
            DownloadService dservice = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
            dresource.setDownloadName(attach.getName());
            String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            if (isEvent) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getChildById(TAB_EVENTDETAIL));
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getChildById(UITaskForm.TAB_TASKDETAIL));
            }
        }
    }

    private boolean isSignificantChanged(CalendarEvent newCalendarEvent, CalendarEvent oldCalendarEvent) {
        return newCalendarEvent != null && oldCalendarEvent != null && (oldCalendarEvent.getSummary() != null && !oldCalendarEvent.getSummary().equalsIgnoreCase(newCalendarEvent.getSummary()) || newCalendarEvent.getSummary() != null && !newCalendarEvent.getSummary().equalsIgnoreCase(oldCalendarEvent.getSummary()) || oldCalendarEvent.getDescription() != null && !oldCalendarEvent.getDescription().equalsIgnoreCase(newCalendarEvent.getDescription()) || newCalendarEvent.getDescription() != null && !newCalendarEvent.getDescription().equalsIgnoreCase(oldCalendarEvent.getDescription()) || oldCalendarEvent.getLocation() != null && !oldCalendarEvent.getLocation().equalsIgnoreCase(newCalendarEvent.getLocation()) || newCalendarEvent.getLocation() != null && !newCalendarEvent.getLocation().equalsIgnoreCase(oldCalendarEvent.getLocation()) || !oldCalendarEvent.getFromDateTime().equals(newCalendarEvent.getFromDateTime()) || !oldCalendarEvent.getToDateTime().equals(newCalendarEvent.getToDateTime()));
    }

    private CalendarEvent sendInvitation(Event<UIEventForm> event, CalendarSetting calSetting, CalendarEvent calendarEvent) throws Exception {
        String[] entry;
        String username = WebuiRequestContext.getCurrentInstance().getRemoteUser();
        Account acc = CalendarUtils.getMailService().getDefaultAccount(username);
        String toId = null;
        if (this.isAddNew_ || this.isChangedSignificantly) {
            toId = this.getParticipantValues();
        } else {
            LinkedHashMap<String, String> invitations = new LinkedHashMap<String, String>();
            for (String s : calendarEvent.getInvitation()) {
                invitations.put(s, s);
            }
            for (String parSt : calendarEvent.getParticipantStatus()) {
                entry = parSt.split(":");
                if (entry.length <= 1 || !entry[0].contains("@")) continue;
                invitations.remove(entry[0]);
            }
            calendarEvent.setInvitation(invitations.keySet().toArray(new String[invitations.size()]));
            StringBuilder builder = new StringBuilder("");
            for (String parSt : calendarEvent.getParticipantStatus()) {
                String[] entry2 = parSt.split(":");
                if (entry2.length != 1 || entry2[0].contains("@")) continue;
                if (builder.length() > 0) {
                    builder.append(CalendarUtils.BREAK_LINE);
                }
                builder.append(entry2[0]);
            }
            if (builder.toString().trim().length() > 0 || invitations.size() > 0) {
                toId = builder.toString();
            }
        }
        try {
            if (toId != null) {
                this.sendMail(CalendarUtils.getMailService(), CalendarUtils.getOrganizationService(), calSetting, acc, username, toId, calendarEvent);
                LinkedList<String> parsUpdated = new LinkedList<String>();
                for (String parSt : calendarEvent.getParticipantStatus()) {
                    entry = parSt.split(":");
                    if (entry.length > 1) {
                        parsUpdated.add(entry[0] + ":" + entry[1]);
                        continue;
                    }
                    parsUpdated.add(entry[0] + ":" + STATUS_PENDING);
                }
                calendarEvent.setParticipantStatus(parsUpdated.toArray(new String[parsUpdated.size()]));
            }
            return calendarEvent;
        }
        catch (Exception e) {
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.error-send-email", null));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Fail to send mail ivitation to the participant", (Throwable)e);
            }
            return null;
        }
    }

    public void saveAndNoAsk(Event<UIEventForm> event, boolean isSend, boolean updateSeries) throws Exception {
        UIEventForm uiForm;
        block50: {
            Calendar currentCalendar;
            Date to;
            String description;
            uiForm = (UIEventForm)event.getSource();
            UICalendarPortlet calendarPortlet = (UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class);
            UIPopupAction uiPopupAction = (UIPopupAction)uiForm.getAncestorOfType(UIPopupAction.class);
            UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)calendarPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
            CalendarSetting calSetting = calendarPortlet.getCalendarSetting();
            CalendarService calService = CalendarUtils.getCalendarService();
            String summary = uiForm.getEventSumary().trim();
            summary = CalendarUtils.enCodeTitle((String)summary);
            String location = uiForm.getEventPlace();
            if (!CalendarUtils.isEmpty((String)location)) {
                location = location.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "");
            }
            if (!CalendarUtils.isEmpty((String)(description = uiForm.getEventDescription()))) {
                description = description.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "");
            }
            if (!uiForm.isEventDetailValid(calSetting)) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, null));
                uiForm.setSelectedTab(TAB_EVENTDETAIL);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            if (!uiForm.isReminderValid()) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
                uiForm.setSelectedTab(TAB_EVENTREMINDER);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            if (!uiForm.isParticipantValid()) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
                uiForm.setSelectedTab(TAB_EVENTSHARE);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            Date from = uiForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
            if (from.after(to = uiForm.getEventToDate(calSetting.getDateFormat(), calSetting.getTimeFormat()))) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.event-date-time-logic", null, 1));
                return;
            }
            String username = CalendarUtils.getCurrentUser();
            String calendarId = uiForm.getCalendarId();
            if (from.equals(to)) {
                to = CalendarUtils.getEndDay((Date)from).getTime();
            }
            if (uiForm.getEventAllDate()) {
                java.util.Calendar tempCal = CalendarUtils.getInstanceOfCurrentCalendar();
                tempCal.setTime(to);
                tempCal.add(14, -1);
                to = tempCal.getTime();
            }
            if ((currentCalendar = CalendarUtils.getCalendar((String)uiForm.calType_, (String)calendarId)) == null) {
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendars.msg.have-no-calendar", null, 1));
                return;
            }
            boolean canEdit = false;
            if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                canEdit = CalendarUtils.canEdit(null, (String[])Utils.getEditPerUsers((Calendar)currentCalendar), (String)username);
            } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                canEdit = CalendarUtils.canEdit((OrganizationService)CalendarUtils.getOrganizationService(), (String[])currentCalendar.getEditPermission(), (String)username);
            }
            if (!canEdit && !uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendars.msg.have-no-permission-to-edit", null, 1));
                return;
            }
            CalendarEvent calendarEvent = null;
            CalendarEvent oldCalendarEvent = null;
            String[] pars = uiForm.getParticipantValues().split(CalendarUtils.BREAK_LINE);
            String eventId = null;
            if (uiForm.isAddNew_) {
                calendarEvent = new CalendarEvent();
            } else {
                calendarEvent = uiForm.calendarEvent_;
                oldCalendarEvent = new CalendarEvent();
                oldCalendarEvent.setSummary(calendarEvent.getSummary());
                oldCalendarEvent.setDescription(calendarEvent.getDescription());
                oldCalendarEvent.setLocation(calendarEvent.getLocation());
                oldCalendarEvent.setFromDateTime(calendarEvent.getFromDateTime());
                oldCalendarEvent.setToDateTime(calendarEvent.getToDateTime());
            }
            calendarEvent.setFromDateTime(from);
            calendarEvent.setToDateTime(to);
            calendarEvent.setSendOption(uiForm.getSendOption());
            calendarEvent.setMessage(uiForm.getMessage());
            String[] parStatus = uiForm.getParticipantStatusValues().split(CalendarUtils.BREAK_LINE);
            calendarEvent.setParticipantStatus(parStatus);
            calendarEvent.setParticipant(pars);
            if (CalendarUtils.isEmpty((String)uiForm.getInvitationEmail())) {
                calendarEvent.setInvitation(null);
            } else if (CalendarUtils.isValidEmailAddresses((String)uiForm.getInvitationEmail())) {
                String addressList = uiForm.getInvitationEmail().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA);
                LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
                for (String email : addressList.split(CalendarUtils.COMMA)) {
                    String address = email.trim();
                    if (emails.containsKey(address)) continue;
                    emails.put(address, address);
                }
                if (!emails.isEmpty()) {
                    calendarEvent.setInvitation(emails.keySet().toArray(new String[emails.size()]));
                }
            } else {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.event-email-invalid", (Object[])new String[]{CalendarUtils.invalidEmailAddresses((String)uiForm.getInvitationEmail())}));
                uiForm.setSelectedTab(TAB_EVENTSHARE);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            calendarEvent.setCalendarId(uiForm.getCalendarId());
            calendarEvent.setEventType(CalendarEvent.TYPE_EVENT);
            calendarEvent.setSummary(summary);
            calendarEvent.setDescription(description);
            calendarEvent.setCalType(uiForm.calType_);
            calendarEvent.setCalendarId(calendarId);
            calendarEvent.setEventCategoryId(uiForm.getEventCategory());
            UIFormSelectBox selectBox = ((UIFormInputWithActions)uiForm.getChildById(TAB_EVENTDETAIL)).getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
            for (SelectItemOption o : selectBox.getOptions()) {
                if (!((String)o.getValue()).equals(selectBox.getValue())) continue;
                calendarEvent.setEventCategoryName(o.getLabel());
                break;
            }
            calendarEvent.setLocation(location);
            if (uiForm.getEventIsRepeat()) {
                if (this.repeatEvent != null) {
                    calendarEvent.setRepeatType(this.repeatEvent.getRepeatType());
                    calendarEvent.setRepeatInterval(this.repeatEvent.getRepeatInterval());
                    calendarEvent.setRepeatCount(this.repeatEvent.getRepeatCount());
                    calendarEvent.setRepeatUntilDate(this.repeatEvent.getRepeatUntilDate());
                    calendarEvent.setRepeatByDay(this.repeatEvent.getRepeatByDay());
                    calendarEvent.setRepeatByMonthDay(this.repeatEvent.getRepeatByMonthDay());
                }
            } else {
                calendarEvent.setRepeatType(CalendarEvent.RP_NOREPEAT);
                calendarEvent.setRepeatInterval(0L);
                calendarEvent.setRepeatCount(0L);
                calendarEvent.setRepeatUntilDate(null);
                calendarEvent.setRepeatByDay(null);
                calendarEvent.setRepeatByMonthDay(null);
            }
            calendarEvent.setPriority(uiForm.getEventPriority());
            calendarEvent.setPrivate(ITEM_PRIVATE.equals(uiForm.getShareType()));
            calendarEvent.setEventState(uiForm.getEventState());
            calendarEvent.setAttachment(uiForm.getAttachments(calendarEvent.getId(), uiForm.isAddNew_));
            calendarEvent.setReminders(uiForm.getEventReminders(from, calendarEvent.getReminders()));
            eventId = calendarEvent.getId();
            CalendarView calendarView = (CalendarView)uiViewContainer.getRenderedChild();
            this.isChangedSignificantly = this.isSignificantChanged(calendarEvent, oldCalendarEvent);
            try {
                block49: {
                    if (calendarEvent != null && isSend) {
                        try {
                            CalendarEvent tempCal = this.sendInvitation(event, calSetting, calendarEvent);
                            calendarEvent = tempCal != null ? tempCal : calendarEvent;
                        }
                        catch (Exception e) {
                            if (!this.log.isWarnEnabled()) break block49;
                            this.log.warn((Object)"Sending invitation failed!", (Throwable)e);
                        }
                    }
                }
                if (uiForm.isAddNew_) {
                    if (uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                        calService.saveUserEvent(username, calendarId, calendarEvent, uiForm.isAddNew_);
                    } else if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                        calService.saveEventToSharedCalendar(username, calendarId, calendarEvent, uiForm.isAddNew_);
                    } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                        calService.savePublicEvent(calendarId, calendarEvent, uiForm.isAddNew_);
                    }
                } else {
                    String fromCal = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[1].trim();
                    String toCal = uiForm.newCalendarId_.split(CalendarUtils.COLON)[1].trim();
                    String fromType = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[0].trim();
                    String toType = uiForm.newCalendarId_.split(CalendarUtils.COLON)[0].trim();
                    ArrayList<CalendarEvent> listEvent = new ArrayList<CalendarEvent>();
                    listEvent.add(calendarEvent);
                    if (!uiForm.calendarEvent_.getRepeatType().equals(CalendarEvent.RP_NOREPEAT) && !CalendarUtils.isEmpty((String)uiForm.calendarEvent_.getRecurrenceId())) {
                        if (!updateSeries) {
                            calService.updateOccurrenceEvent(fromCal, toCal, fromType, toType, listEvent, username);
                        } else if (CalendarUtils.isSameDate((Date)oldCalendarEvent.getFromDateTime(), (Date)calendarEvent.getFromDateTime())) {
                            calService.updateRecurrenceSeries(fromCal, toCal, fromType, toType, calendarEvent, username);
                        } else {
                            calService.updateOccurrenceEvent(fromCal, toCal, fromType, toType, listEvent, username);
                        }
                    } else if (Utils.isExceptionOccurrence((CalendarEvent)this.calendarEvent_)) {
                        calService.updateOccurrenceEvent(fromCal, toCal, fromType, toType, listEvent, username);
                    } else {
                        calService.moveEvent(fromCal, toCal, fromType, toType, listEvent, username);
                    }
                    UITaskForm.updateListView((CalendarView)calendarView, (CalendarEvent)calendarEvent, (CalendarService)calService, (String)username);
                }
                if (calendarView instanceof UIListContainer) {
                    UIListContainer uiListContainer = (UIListContainer)calendarView;
                    if (!uiListContainer.isDisplaySearchResult()) {
                        uiViewContainer.refresh();
                    }
                } else {
                    uiViewContainer.refresh();
                }
                calendarView.setLastUpdatedEventId(eventId);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
                UIMiniCalendar uiMiniCalendar = (UIMiniCalendar)calendarPortlet.findFirstComponentOfType(UIMiniCalendar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMiniCalendar);
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            }
            catch (Exception e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.add-event-error", null));
                if (!this.log.isDebugEnabled()) break block50;
                this.log.debug((Object)"Fail to add the event", (Throwable)e);
            }
        }
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)uiForm.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            UIAttachFileForm.removeUploadTemp((UploadService)((UploadService)uiForm.getApplicationComponent(UploadService.class)), (String)att.getResourceId());
        }
    }

    public void setRepeatEvent(CalendarEvent repeatEvent) throws Exception {
        this.repeatEvent = repeatEvent;
        this.setEventIsRepeat(true);
        this.setRepeatSummary(this.buildRepeatSummary(repeatEvent));
    }

    public void setRepeatSummary(String summary) {
        this.repeatSummary = summary;
    }

    public String getRepeatSummary() {
        return this.repeatSummary;
    }

    public CalendarEvent getRepeatEvent() {
        return this.repeatEvent;
    }

    public String buildRepeatSummary(CalendarEvent repeatEvent) throws Exception {
        CalendarSetting calSetting = CalendarUtils.getCurrentUserCalendarSetting();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] dayOfWeeks = symbols.getWeekdays();
        String summary = "";
        if (repeatEvent == null) {
            return "";
        }
        String repeatType = repeatEvent.getRepeatType();
        if (CalendarEvent.RP_NOREPEAT.equals(repeatType) || repeatType == null) {
            return "";
        }
        int interval = (int)repeatEvent.getRepeatInterval();
        int count = (int)repeatEvent.getRepeatCount();
        Date until = repeatEvent.getRepeatUntilDate();
        String endType = "neverEnd";
        if (count > 0) {
            endType = "endAfter";
        }
        if (until != null) {
            endType = "endByDate";
        }
        String pattern = "";
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            pattern = interval == 1 ? this.getLabel("daily") : this.getLabel("every-day");
            if (endType.equals("endAfter")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("count-times");
            }
            if (endType.equals("endByDate")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("until");
            }
            summary = pattern.replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate()));
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
            pattern = interval == 1 ? this.getLabel("weekly") : this.getLabel("every-week");
            if (endType.equals("endAfter")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("count-times");
            }
            if (endType.equals("endByDate")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("until");
            }
            String[] weeklyByDays = repeatEvent.getRepeatByDay();
            StringBuffer byDays = new StringBuffer();
            for (int i = 0; i < weeklyByDays.length; ++i) {
                if (i == 0) {
                    byDays.append(dayOfWeeks[UIRepeatEventForm.convertToDayOfWeek((String)weeklyByDays[0])]);
                    continue;
                }
                byDays.append(", ");
                byDays.append(dayOfWeeks[UIRepeatEventForm.convertToDayOfWeek((String)weeklyByDays[i])]);
            }
            summary = pattern.replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{byDays}", byDays.toString());
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            String monthlyType = "monthlyByMonthDay";
            if (repeatEvent.getRepeatByDay() != null && repeatEvent.getRepeatByDay().length > 0) {
                monthlyType = "monthlyByDay";
            }
            pattern = interval == 1 ? this.getLabel("monthly") : this.getLabel("every-month");
            if (monthlyType.equals("monthlyByDay")) {
                pattern = pattern + " ";
                pattern = pattern + this.getLabel("monthly-by-day");
            } else {
                pattern = pattern + " ";
                pattern = pattern + this.getLabel("monthly-by-month-day");
            }
            if (endType.equals("endAfter")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("count-times");
            }
            if (endType.equals("endByDate")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("until");
            }
            String theNumber = "";
            String theDay = "";
            if (monthlyType.equals("monthlyByDay")) {
                java.util.Calendar temp = CalendarUtils.getInstanceOfCurrentCalendar();
                temp.setTime(repeatEvent.getFromDateTime());
                int weekOfMonth = temp.get(4);
                java.util.Calendar temp2 = CalendarUtils.getInstanceOfCurrentCalendar();
                temp2.setTime(temp.getTime());
                temp2.add(5, 7);
                if (temp2.get(2) != temp.get(2)) {
                    weekOfMonth = 5;
                }
                int dayOfWeek = temp.get(7);
                String[] weekOfMonths = new String[]{this.getLabel("summary-the-first"), this.getLabel("summary-the-second"), this.getLabel("summary-the-third"), this.getLabel("summary-the-fourth"), this.getLabel("summary-the-last")};
                theNumber = weekOfMonths[weekOfMonth - 1];
                theDay = dayOfWeeks[dayOfWeek];
            } else {
                java.util.Calendar temp = CalendarUtils.getInstanceOfCurrentCalendar();
                temp.setTime(repeatEvent.getFromDateTime());
                int dayOfMonth = temp.get(5);
                theDay = String.valueOf(dayOfMonth);
            }
            summary = pattern.replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay).replace("{theNumber}", theNumber);
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            pattern = interval == 1 ? this.getLabel("yearly") : this.getLabel("every-year");
            if (endType.equals("endAfter")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("count-times");
            }
            if (endType.equals("endByDate")) {
                pattern = pattern + ", ";
                pattern = pattern + this.getLabel("until");
            }
            String theDay = format.format(repeatEvent.getFromDateTime());
            summary = pattern.replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay);
            return summary;
        }
        return summary;
    }

    private void confirmSaveEvent(Event<UIEventForm> event, boolean isSend) throws Exception {
        UIEventForm uiEventForm = (UIEventForm)event.getSource();
        UICalendarPortlet uiPortlet = (UICalendarPortlet)uiEventForm.getAncestorOfType(UICalendarPortlet.class);
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiEventForm.getAncestorOfType(UIPopupContainer.class);
        UIPopupAction uiPopupAction = (UIPopupAction)uiPopupContainer.getChild(UIPopupAction.class);
        uiPopupAction.deActivate();
        CalendarSetting calSetting = uiPortlet.getCalendarSetting();
        Date fromDate = uiEventForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
        CalendarEvent occurrence = uiEventForm.calendarEvent_;
        if (occurrence != null && !CalendarEvent.RP_NOREPEAT.equals(occurrence.getRepeatType()) && !CalendarUtils.isEmpty((String)occurrence.getRecurrenceId()) && CalendarUtils.isSameDate((Date)fromDate, (Date)occurrence.getFromDateTime())) {
            UIConfirmForm confirmForm = (UIConfirmForm)uiPopupAction.activate(UIConfirmForm.class, 600);
            confirmForm.setConfirmMessage(uiEventForm.getLabel("update-recurrence-event-confirm-msg"));
            confirmForm.setConfig_id(uiEventForm.getId());
            String[] actions = new String[]{"ConfirmUpdateOnlyInstance", "ConfirmUpdateAllSeries", "ConfirmUpdateCancel"};
            confirmForm.setActions(actions);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        } else {
            uiEventForm.saveAndNoAsk(event, isSend, false);
        }
    }

    static /* synthetic */ boolean access$000(UIEventForm x0) throws Exception {
        return x0.isReminderValid();
    }

    static /* synthetic */ String access$100(UIEventForm x0) {
        return x0.errorMsg_;
    }

    static /* synthetic */ String access$200(UIEventForm x0) {
        return x0.errorValues;
    }

    static /* synthetic */ String access$300(UIEventForm x0) {
        return x0.saveEventNoInvitation;
    }

    static /* synthetic */ String access$400(UIEventForm x0) {
        return x0.saveEventInvitation;
    }

    static /* synthetic */ CalendarEvent access$500(UIEventForm x0) {
        return x0.calendarEvent_;
    }

    static /* synthetic */ void access$600(UIEventForm x0, Event x1, boolean x2) throws Exception {
        x0.confirmSaveEvent(x1, x2);
    }

    static /* synthetic */ CalendarEvent access$700(UIEventForm x0) {
        return x0.repeatEvent;
    }
}

